/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.toolpack;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.ui.Dialog;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Http;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Timer;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.dialogs.MessageDialog;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class arcChatPicture {
    public static final String ShareType = "[yellow]<Picture>";
    private static Pixmap oriImage;
    static Table tTable;
    static Fi figureFile;
    static TextField figureLink;
    static final int maxPicture = 10;
    static int curPicture;

    public static boolean resolveMessage(String text, @Nullable Player playersender) {
        if (!Core.settings.getBool("arcShareMedia")) {
            return false;
        }
        if (!text.contains(ShareType) || !text.contains("http")) {
            return false;
        }
        if (!arcChatPicture.checkPic()) {
            return true;
        }
        int Indexer = text.indexOf(ShareType) + ShareType.length();
        Indexer = text.indexOf("http", Indexer);
        String url = text.substring(Indexer);
        MessageDialog.addMsg(new MessageDialog.advanceMsg(MessageDialog.arcMsgType.arcChatPicture, text));
        Http.get(url, res -> {
            byte[] data = res.getResult();
            new Thread(() -> {
                try {
                    Pixmap pix = new Pixmap(data);
                    Timer.schedule(() -> new floatFigure(pix, playersender), 0.01f);
                }
                catch (Exception e) {
                    Log.err(e);
                    ARCVars.arcui.arcInfo("[orange]\u56fe\u7247\u8bfb\u53d6\u5931\u8d25");
                }
            }).start();
        });
        return true;
    }

    public static void arcSharePicture() {
        BaseDialog dialog = new BaseDialog("\u56fe\u7247\u5206\u4eab\u5668");
        dialog.cont.table(t -> {
            t.button("[cyan]\u9009\u62e9\u56fe\u7247[white](png)", () -> Vars.platform.showFileChooser(false, "png", file -> {
                figureFile = file;
                try {
                    byte[] bytes = file.readBytes();
                    oriImage = new Pixmap(bytes);
                    arcChatPicture.rebuildShare();
                    if (arcChatPicture.oriImage.width > 500 || arcChatPicture.oriImage.height > 500) {
                        ARCVars.arcui.arcInfo("[orange]\u8b66\u544a\uff1a\u56fe\u7247\u53ef\u80fd\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u538b\u7f29\u56fe\u7247", 5.0f);
                    }
                }
                catch (Throwable e) {
                    ARCVars.arcui.arcInfo("\u8bfb\u53d6\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u56fe\u7247\n" + e);
                }
            })).size(240.0f, 50.0f).padBottom(20.0f).row();
            t.table(a -> {
                tTable = a;
            });
            t.row();
            figureLink = t.field("\u5728\u6b64\u8f93\u5165\u56fe\u7247\u7f51\u5740api", text -> {}).width(400.0f).get();
            t.button("\u2650", () -> {
                RFuncs.shareString(RFuncs.getPrefix("yellow", "Picture").append(figureLink.getText()).toString().replace(" ", ""));
                figureLink.clear();
            }).disabled(disable -> !figureLink.getText().startsWith("http"));
            t.row();
            t.button("[orange]\u968f\u673a\u4e8c\u6b21\u5143(\u5927\u96fe)", () -> {
                try {
                    Http.get("https://api.yimian.xyz/img/?type=moe", res -> {
                        Pixmap pix = new Pixmap(res.getResult());
                        Timer.schedule(() -> new floatFigure(pix, Vars.player), 0.01f);
                    });
                }
                catch (Exception e) {
                    Log.err(e);
                    Core.app.post(() -> ARCVars.arcui.arcInfo("[orange]\u56fe\u7247\u8bfb\u53d6\u5931\u8d25"));
                }
            }).padTop(30.0f).width(400.0f);
            t.row();
            t.add("\u5173\u95ed\u8bc6\u522b\u65b9\u6cd5\uff1a\u4e2d\u592e\u76d1\u63a7\u5ba4\u2014\u2014\u8bbe\u7f6e" + (Vars.mobile ? "" : "\nPC\u7aef\u53ef\u901a\u8fc7[cyan]\u626b\u63cf\u6a21\u5f0f[white]\u6765\u9690\u85cf\u9644\u5c5e\u4fe1\u606f"));
        });
        ((Dialog)dialog).addCloseButton();
        dialog.show();
    }

    private static void rebuildShare() {
        tTable.clear();
        tTable.table(t -> {
            t.add("\u540d\u79f0").color(ARCVars.getThemeColor()).padRight(25.0f).padBottom(10.0f);
            t.add(figureFile.name()).padBottom(10.0f).row();
            t.add("\u5927\u5c0f").color(ARCVars.getThemeColor()).padRight(25.0f);
            t.add(arcChatPicture.oriImage.width + "\ue815" + arcChatPicture.oriImage.height);
        });
        tTable.row();
        tTable.add("\u64cd\u4f5c\u56fe\u7247").pad(25.0f);
        tTable.row();
        tTable.table(t -> {
            t.button("\u6dfb\u52a0\u5230\u672c\u5730", () -> new floatFigure(oriImage, Vars.player)).width(300.0f).row();
            t.button("\u4e0a\u4f20\u5230\u4e91\u4ee5\u5206\u4eab", () -> RFuncs.uploadToWeb(figureFile, s -> figureLink.setText((String)s))).width(300.0f);
        });
    }

    private static boolean checkPic() {
        if (curPicture >= 10) {
            Core.app.post(() -> ARCVars.arcui.arcInfo("\u5f53\u524d\u56fe\u7247\u5df2\u8fbe\u4e0a\u9650\uff0c\u4ec5\u5141\u8bb8\u81ea\u5df1\u6dfb\u52a0\u56fe\u7247", 10.0f));
            return false;
        }
        return true;
    }

    static {
        tTable = new Table(Tex.button);
        curPicture = 0;
    }

    public static class floatFigure {
        private final Table t;
        private final Table pic = new Table();
        private final Pixmap pix;
        private float sizeM = 1.0f;
        @Nullable
        private final Player sender;
        private TextureRegion cache;

        floatFigure(Pixmap pixmap, @Nullable Player playersender) {
            ++curPicture;
            this.pix = pixmap;
            this.t = new Table(Styles.black3);
            this.sender = playersender;
            this.cache = new TextureRegion(new Texture(this.pix));
            this.t.add(this.pic);
            this.t.visible = false;
            this.t.setPosition((float)Core.graphics.getWidth() / 3.0f * 2.0f, (float)Core.graphics.getHeight() / 3.0f * 2.0f, 1);
            this.t.pack();
            this.t.act(0.1f);
            this.t.update(() -> {
                if (!Vars.state.isGame()) {
                    this.clear();
                }
            });
            Core.scene.add(this.t);
            this.buildTable();
            ARCVars.arcui.arcInfo("\u5df2\u6536\u5230\u56fe\u7247!\uff0c\u6765\u6e90\uff1a" + (playersender != null ? (playersender.isNull() ? "" : playersender.name) : "") + "\n[gray]\u4f7f\u7528\u53c2\u8003\u4e2d\u592e\u76d1\u63a7\u5ba4-\u56fe\u7247\u5206\u4eab\u5668");
            this.pix.dispose();
        }

        private void buildTable() {
            this.pic.clear();
            float ratio = (float)Math.max(this.pix.width, this.pix.height) / 500.0f / this.sizeM;
            this.t.visible = true;
            this.pic.image(this.cache).size((float)this.pix.width / ratio, (float)this.pix.height / ratio).get();
            this.pic.row();
            this.pic.table(tp -> {
                if (this.sender != null) {
                    tp.add("[cyan]\u6765\u6e90\uff1a" + this.sender.name()).fontScale(this.sizeM).row();
                }
                tp.table(tpa -> {
                    tpa.button("\ue879", Styles.cleart, this::saveFig).size(40.0f);
                    tpa.button("-", Styles.cleart, () -> {
                        this.sizeM /= 1.2f;
                        this.buildTable();
                    }).size(40.0f);
                    tpa.button("+", Styles.cleart, () -> {
                        this.sizeM *= 1.2f;
                        this.buildTable();
                    }).size(40.0f);
                    tpa.button("[red]x", Styles.cleart, this::clear).size(40.0f);
                });
            }).visible(() -> Vars.mobile || Vars.control.input.arcScanMode);
            this.t.addListener(new ElementGestureListener(){

                @Override
                public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                    t.setPosition(((floatFigure)this).t.x + deltaX / 2.0f, ((floatFigure)this).t.y + deltaY / 2.0f);
                }
            });
        }

        private void clear() {
            this.t.visible = false;
            this.t.clearListeners();
            this.t.remove();
            --curPicture;
        }

        private void saveFig() {
            Vars.platform.export("\u56fe\u7247-" + Time.millis(), "png", file -> PixmapIO.writePng(file, this.pix));
            ARCVars.arcui.arcInfo("[cyan]\u5df2\u4fdd\u5b58\u56fe\u7247");
        }
    }
}

