/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.toolpack;

import arc.Core;
import arc.Events;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.arcModule.ui.PowerInfo;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Groups;
import mindustry.type.Item;
import mindustry.world.blocks.storage.CoreBlock;

public class ARCTeam {
    public Seq<Team> updateTeam = new Seq();
    public Seq<Team> lastUpdateTeam = new Seq();
    public Seq<Team> forceUpdateTeam = new Seq();
    public Seq<Team> activeTeam = new Seq();
    public float lastUpd = 0.0f;
    public float resUpd = 0.0f;
    public float statisUpd = 0.0f;
    private static final int updateTimer = 5;
    public static int statisticsInterval = 0;
    public static int setStatisticsInterval = 0;
    public int[][] resources;
    public static int statisticsCounter = 0;
    public static int size = 0;
    public static final int defaultTime = 18000;

    public ARCTeam() {
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.forceUpdateTeam.clear();
            this.initTeamList();
            this.updateTeam.each(team -> team.arcTeamData.init());
            statisticsCounter = 0;
        });
        Events.run((Object)EventType.Trigger.update, () -> {
            if (!Vars.state.isGame()) {
                return;
            }
            setStatisticsInterval = Core.settings.getInt("statisticsInterval", 0);
            if (Time.time - this.lastUpd > 120.0f) {
                this.lastUpd = Time.time;
                this.updateTeamList();
            }
            if (Time.time - this.resUpd > 60.0f) {
                this.resUpd = Time.time;
                this.updateTeam.each(team -> team.arcTeamData.updateDiffItems());
            }
            this.update();
            if (statisticsInterval != setStatisticsInterval) {
                statisticsInterval = setStatisticsInterval;
                this.updateTeam.each(team -> team.arcTeamData.init());
                statisticsCounter = 0;
            }
            if (statisticsInterval != 0) {
                size = 18000 / statisticsInterval;
                if (Time.time - this.statisUpd > (float)(statisticsInterval * 60) && statisticsCounter < size) {
                    this.statisUpd = Time.time;
                    this.updateTeam.each(team -> team.arcTeamData.updateRes());
                    ++statisticsCounter;
                }
            }
        });
    }

    private void initTeamList() {
        this.updateTeam.clear();
        Vars.state.teams.getActive().each(teamData -> this.updateTeam.add(teamData.team));
        if (Vars.state.rules.waveTimer) {
            this.updateTeam.addUnique(Vars.state.rules.waveTeam);
        }
    }

    private void updateTeamList() {
        this.activeTeam = Vars.state.teams.getActive().map(teamData -> teamData.team);
        this.updateTeam.retainAll(team -> this.activeTeam.contains((Team)team));
        this.forceUpdateTeam.each(team -> this.updateTeam.addUnique((Team)team));
    }

    private void update() {
        if (this.lastUpdateTeam != this.updateTeam) {
            this.updateTeam.each(team -> {
                if (!this.lastUpdateTeam.contains((Team)team)) {
                    team.arcTeamData.init();
                }
            });
        }
        this.lastUpdateTeam = this.updateTeam;
        this.updatePower();
        this.updateTeam.each(team -> team.arcTeamData.update());
    }

    private void updatePower() {
        this.updateTeam.each(team -> team.arcTeamData.powerInfo.clear());
        Groups.powerGraph.each(item -> {
            if (this.updateTeam.contains(item.graph().team)) {
                item.graph().team.arcTeamData.powerInfo.add(item.graph().getPowerBalance(), item.graph().getLastPowerStored(), item.graph().getLastCapacity(), item.graph().getLastPowerProduced(), item.graph().getLastPowerNeeded());
            }
        });
    }

    public static class ARCTeamData {
        public Team team;
        private CoreBlock.CoreBuild core;
        public int[] currentItems;
        public float[] updateItems;
        public int[] lastItems;
        public PowerInfo powerInfo;
        public int[][] resStatistics;

        public ARCTeamData(Team thisTeam) {
            this.currentItems = new int[Vars.content.items().size];
            this.updateItems = new float[Vars.content.items().size];
            this.lastItems = new int[Vars.content.items().size];
            this.powerInfo = new PowerInfo();
            this.team = thisTeam;
        }

        public void init() {
            this.core = this.team.core();
            this.currentItems = new int[Vars.content.items().size];
            this.updateItems = new float[Vars.content.items().size];
            this.lastItems = new int[Vars.content.items().size];
            if (statisticsInterval != 0) {
                this.resStatistics = new int[18000 / statisticsInterval][Vars.content.items().size];
            }
        }

        public void update() {
            this.core = this.team.core();
            if (this.core == null) {
                return;
            }
            this.updateItems();
        }

        public void updateItems() {
            if (this.currentItems.length == 0) {
                this.init();
            }
            for (Item item : Vars.content.items()) {
                this.currentItems[item.id] = this.core.items.get(item);
            }
        }

        public void updateDiffItems() {
            for (Item item : Vars.content.items()) {
                this.updateItems[item.id] = (this.updateItems[item.id] * 4.0f + (float)this.currentItems[item.id] - (float)this.lastItems[item.id]) / 5.0f;
                this.lastItems[item.id] = this.currentItems[item.id];
            }
        }

        public void updateRes() {
            this.resStatistics[ARCTeam.statisticsCounter] = (int[])this.currentItems.clone();
        }
    }
}

