/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.player;

import arc.Core;
import arc.Events;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.gen.Call;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.storage.StorageBlock;

public class AutoFill {
    public static final AutoFill INSTANCE = new AutoFill();
    private long lastRunTime = System.currentTimeMillis();
    public long interval = 500L;
    public Item item = null;

    private AutoFill() {
        Events.run((Object)EventType.Trigger.update, () -> {
            long timeMillis = System.currentTimeMillis();
            if (timeMillis > this.lastRunTime + this.interval && Core.settings.getBool("autoFill") && Vars.player.unit() != null && Vars.state.rules.mode() != Gamemode.pvp) {
                if (Vars.player.unit().hasItem()) {
                    ItemStack stack = Vars.player.unit().stack;
                    Item item = stack.item;
                    this.lastRunTime = timeMillis;
                    boolean[] tried = new boolean[]{false};
                    Vars.indexer.eachBlock(Vars.player.team(), Vars.player.x, Vars.player.y, 220.0f, build -> build.acceptStack(Vars.player.unit().item(), Vars.player.unit().stack.amount, Vars.player.unit()) > 0 && (build.block instanceof BaseTurret || build.block instanceof GenericCrafter), build -> {
                        Call.transferInventory(Vars.player, build);
                        tried[0] = true;
                    });
                    if (tried[0]) {
                        this.item = item;
                        this.pickItem();
                    }
                } else {
                    this.pickItem();
                }
            }
        });
        Events.run(EventType.WorldLoadEvent.class, this::clearItemRecord);
    }

    public void interactionTooFastWarning() {
        this.lastRunTime = System.currentTimeMillis() + 5000L;
    }

    public void clearItemRecord() {
        this.item = null;
    }

    private void pickItem() {
        if (this.item == null) {
            return;
        }
        Vars.indexer.eachBlock(Vars.player.team(), Vars.player.x, Vars.player.y, 220.0f, build -> build.block instanceof StorageBlock && build.items.get(this.item) > 0, build -> Call.requestItem(Vars.player, build, this.item, Vars.player.unit().maxAccepted(this.item)));
    }
}

