/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.draw;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.ai.types.LogicAI;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.DrawUtilities;
import mindustry.arcModule.toolpack.arcPlayerEffect;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.blocks.payloads.Payload;

public class ARCUnits {
    public static float defaultUnitTrans;
    public static float unitTrans;
    private static boolean drawUnit;
    private static boolean drawUnitBar;
    private static float unitDrawMinHealth;
    private static float unitBarDrawMinHealth;
    private static float unitWeaponRangeAlpha;
    private static float unitWeaponRange;
    public static boolean selectedUnitsFlyer;
    public static boolean selectedUnitsLand;
    private static boolean alwaysShowPlayerUnit;
    private static boolean alwaysShowUnitRTSAi;
    private static boolean unitHealthBar;
    private static boolean unitLogicMoveLine;
    private static boolean unitLogicTimerBars;
    private static boolean unitBuildPlan;
    private static boolean unithitbox;
    private static boolean canHitPlayer;
    private static boolean canHitCommand;
    private static boolean canHitPlans;
    private static boolean canHitMouse;
    private static float curStroke;
    private static float iconSize;
    private static int unitTargetType;
    private static int superUnitEffect;
    private static boolean arcBuildInfo;

    public static void drawARCUnits(Unit unit) {
        unitTrans = defaultUnitTrans;
        drawUnit = unit.maxHealth + unit.shield > unitDrawMinHealth;
        boolean bl = drawUnitBar = unit.maxHealth + unit.shield > unitBarDrawMinHealth;
        if (!drawUnit) {
            unitTrans = 0.0f;
            drawUnitBar = false;
        }
        if (unit.controller() instanceof Player) {
            ARCUnits.drawPlayerEffect(unit);
            if (alwaysShowPlayerUnit) {
                unitTrans = 100.0f;
                drawUnitBar = true;
            }
        }
        if (drawUnitBar) {
            if (ARCVars.arcInfoControl(unit.team()).booleanValue()) {
                ARCUnits.drawWeaponRange(unit);
                ARCUnits.drawRTSAI(unit);
                ARCUnits.drawHealthBar(unit);
                ARCUnits.drawLogic(unit);
                ARCUnits.drawBuildPlan(unit);
            }
            ARCUnits.drawHitBox(unit);
        }
    }

    private static void drawPlayerEffect(Unit unit) {
        boolean drawCircle;
        Color effectColor = unit.controller() == Vars.player ? ARCVars.getPlayerEffectColor() : unit.team.color;
        boolean bl = drawCircle = unit.controller() == Vars.player && superUnitEffect != 0 || unit.controller() instanceof Player && superUnitEffect == 2;
        if (drawCircle) {
            Lines.stroke(Lines.getStroke() * curStroke);
            Draw.z(108.0f);
            Draw.color(effectColor);
            Tmp.v1.trns(unit.rotation - 90.0f, unit.x, unit.y).add(unit.x, unit.y);
            if (curStroke > 0.0f) {
                for (int i = 0; i < 5; ++i) {
                    float rot = unit.rotation + (float)i * 360.0f / 5.0f + Time.time * 0.5f;
                    Lines.arc(unit.x, unit.y, unit.type.maxRange, 0.14f, rot, (int)(50.0f + unit.type.maxRange / 10.0f));
                }
            }
        }
        if (unitTargetType > 0) {
            Draw.z(110.0f);
            Draw.color(effectColor, 0.8f);
            Lines.stroke(1.0f);
            Lines.line(unit.x, unit.y, unit.aimX, unit.aimY);
            switch (unitTargetType) {
                case 1: {
                    Lines.dashCircle(unit.aimX, unit.aimY, 8.0f);
                    break;
                }
                case 2: {
                    Drawf.target(unit.aimX, unit.aimY, 6.0f, 0.7f, effectColor);
                    break;
                }
                case 3: {
                    Drawf.target2(unit.aimX, unit.aimY, 6.0f, 0.7f, effectColor);
                    break;
                }
                case 4: {
                    Drawf.targetc(unit.aimX, unit.aimY, 6.0f, 0.7f, effectColor);
                    break;
                }
                case 5: {
                    Drawf.targetd(unit.aimX, unit.aimY, 6.0f, 0.7f, effectColor);
                }
            }
        }
        if (arcPlayerEffect.show && Mathf.chanceDelta(arcPlayerEffect.effectChance)) {
            arcPlayerEffect.playerEffect.at(unit.x, unit.y, effectColor);
        }
        Draw.reset();
        if (unit.controller() == Vars.player) {
            ARCUnits.detailBuildMode();
        }
    }

    private static void drawWeaponRange(Unit unit) {
        if (unitWeaponRange == 0.0f || unitWeaponRangeAlpha == 0.0f) {
            return;
        }
        if (unitWeaponRange == 30.0f) {
            ARCUnits.drawWeaponRange(unit, unitWeaponRangeAlpha);
        } else if (unit.team != Vars.player.team()) {
            canHitPlayer = !Vars.player.unit().isNull() && Vars.player.unit().hittable() && (Vars.player.unit().isFlying() ? unit.type.targetAir : unit.type.targetGround) && unit.within(Vars.player.unit().x, Vars.player.unit().y, unit.type.maxRange + unitWeaponRange);
            canHitCommand = Vars.control.input.commandMode && (selectedUnitsFlyer && unit.type.targetAir || selectedUnitsLand && unit.type.targetGround);
            canHitPlans = (Vars.control.input.block != null || Vars.control.input.selectPlans.size > 0) && unit.type.targetGround;
            canHitMouse = unit.within(Core.input.mouseWorldX(), Core.input.mouseWorldY(), unit.type.maxRange + unitWeaponRange);
            if (canHitPlayer || canHitMouse && (canHitCommand || canHitPlans)) {
                ARCUnits.drawWeaponRange(unit, unitWeaponRangeAlpha);
            }
        }
    }

    private static void drawWeaponRange(Unit unit, float alpha) {
        Draw.color(unit.team.color);
        Draw.alpha(alpha);
        Lines.dashCircle(unit.x, unit.y, unit.type.maxRange);
        Draw.reset();
    }

    private static void drawRTSAI(Unit unit) {
        if (!Vars.control.input.commandMode && alwaysShowUnitRTSAi && unit.isCommandable() && unit.command().command != null && unit.command().command.name.equals("move")) {
            Draw.z(110.0f);
            CommandAI ai = unit.command();
            if (ai.targetPos != null) {
                Position lineDest = ai.attackTarget != null ? ai.attackTarget : ai.targetPos;
                Draw.color(unit.team.color);
                Drawf.limitLineColor(unit, lineDest, unit.hitSize / 2.0f, 3.5f, unit.team.color);
                if (ai.attackTarget == null) {
                    Draw.color(unit.team.color);
                    Drawf.square(lineDest.getX(), lineDest.getY(), 3.5f, unit.team.color);
                }
            }
            if (ai.attackTarget != null) {
                Draw.color(unit.team.color);
                Drawf.target(ai.attackTarget.getX(), ai.attackTarget.getY(), 6.0f, unit.team.color);
            }
            Draw.color();
        }
        Draw.reset();
    }

    private static void drawHealthBar(Unit unit) {
        Payloadc payload;
        if (!unitHealthBar || !drawUnitBar) {
            return;
        }
        Draw.z(131.0f);
        float y_corr = 0.0f;
        if (unit.hitSize < 30.0f && unit.hitSize > 20.0f && unit.isPlayer()) {
            y_corr = 2.0f;
        }
        if (unit.health < unit.maxHealth) {
            Draw.reset();
            Lines.stroke(4.0f);
            Draw.color(unit.team.color, 0.5f);
            Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + y_corr, unit.x + unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + y_corr);
            Lines.stroke(2.0f);
            Draw.color(Pal.health, 0.8f);
            Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + y_corr, unit.x + unit.hitSize() * (Math.min(Mathf.maxZero(unit.health), unit.maxHealth) * 1.2f / unit.maxHealth - 0.6f), unit.y + unit.hitSize() / 2.0f + y_corr);
            Lines.stroke(2.0f);
        }
        if (unit.shield > 0.0f && (double)unit.shield < 1.0E20) {
            for (int didgt = 1; didgt <= Mathf.digits((int)(unit.shield / unit.maxHealth)) + 1; ++didgt) {
                Draw.color(Pal.shield, 0.8f);
                float shieldAmountScale = unit.shield / (unit.maxHealth * Mathf.pow(10.0f, (float)didgt - 1.0f));
                if (didgt > 1) {
                    Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr, unit.x + unit.hitSize() * (((float)Mathf.ceil((shieldAmountScale - (float)Mathf.floor(shieldAmountScale)) * 10.0f) - 1.0f + 1.0E-4f) * 1.2f * 0.11111111f - 0.6f), unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr);
                    continue;
                }
                Lines.line(unit.x - unit.hitSize() * 0.6f, unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr, unit.x + unit.hitSize() * ((shieldAmountScale - (float)Mathf.floor(shieldAmountScale) - 0.001f) * 1.2f - 0.6f), unit.y + unit.hitSize() / 2.0f + (float)didgt * 2.0f + y_corr);
            }
        }
        Draw.reset();
        float index = 0.0f;
        int iconColumns = Math.max((int)(unit.hitSize() / (iconSize + 1.0f)), 4);
        float iconWidth = Math.min(unit.hitSize() / (float)iconColumns, iconSize + 1.0f);
        for (StatusEntry entry : unit.statuses()) {
            Draw.rect(entry.effect.uiIcon, unit.x - unit.hitSize() * 0.6f + iconWidth * (index % (float)iconColumns), unit.y + unit.hitSize() / 2.0f + 3.0f + iconSize * (float)Mathf.floor(index / (float)iconColumns), iconSize, iconSize);
            index += 1.0f;
        }
        index = 0.0f;
        if (unit instanceof Payloadc && (payload = (Payloadc)((Object)unit)).payloads().any()) {
            for (Payload p : payload.payloads()) {
                Draw.rect(p.icon(), unit.x - unit.hitSize() * 0.6f + 0.5f * iconSize * index, unit.y + unit.hitSize() / 2.0f - 4.0f, 4.0f, 4.0f);
                index += 1.0f;
            }
        }
        Draw.reset();
    }

    private static void drawLogic(Unit unit) {
        UnitController unitController = unit.controller();
        if (unitController instanceof LogicAI) {
            LogicAI logicai = (LogicAI)unitController;
            if (unitLogicMoveLine && Mathf.len(logicai.moveX - unit.x, logicai.moveY - unit.y) <= 1200.0f) {
                Lines.stroke(1.0f);
                Draw.color(0.2f, 0.2f, 1.0f, 0.9f);
                Lines.dashLine(unit.x, unit.y, logicai.moveX, logicai.moveY, (int)(Mathf.len(logicai.moveX - unit.x, logicai.moveY - unit.y) / 8.0f));
                Lines.dashCircle(logicai.moveX, logicai.moveY, logicai.moveRad);
                Draw.reset();
            }
            if (unitLogicTimerBars) {
                Lines.stroke(2.0f);
                Draw.color(Pal.heal);
                Lines.line(unit.x - unit.hitSize() / 2.0f, unit.y - unit.hitSize() / 2.0f, unit.x - unit.hitSize() / 2.0f, unit.y + unit.hitSize() * (logicai.controlTimer / 600.0f - 0.5f));
                Draw.reset();
            }
        }
    }

    private static void drawBuildPlan(Unit unit) {
        if (unitBuildPlan && !unit.plans().isEmpty()) {
            Draw.z(115.2f);
            int counter = 0;
            if (unit != Vars.player.unit()) {
                for (BuildPlan b : unit.plans()) {
                    unit.drawPlan(b, 0.5f);
                    if (++counter < 100) continue;
                    break;
                }
            }
            counter = 0;
            Draw.color(Pal.gray);
            Lines.stroke(2.0f);
            float x = unit.x;
            float y = unit.y;
            float s = unit.hitSize / 2.0f;
            for (BuildPlan b : unit.plans()) {
                Tmp.v2.trns(Angles.angle(x, y, b.drawx(), b.drawy()), s);
                Tmp.v3.trns(Angles.angle(x, y, b.drawx(), b.drawy()), (float)b.block.size * 2.0f);
                Lines.circle(b.drawx(), b.drawy(), (float)b.block.size * 2.0f);
                Lines.line(x + Tmp.v2.x, y + Tmp.v2.y, b.drawx() - Tmp.v3.x, b.drawy() - Tmp.v3.y);
                x = b.drawx();
                y = b.drawy();
                s = (float)b.block.size * 2.0f;
                if (++counter < 100) continue;
                break;
            }
            counter = 0;
            Draw.color(unit.team.color);
            Lines.stroke(0.75f);
            x = unit.x;
            y = unit.y;
            s = unit.hitSize / 2.0f;
            for (BuildPlan b : unit.plans()) {
                Tmp.v2.trns(Angles.angle(x, y, b.drawx(), b.drawy()), s);
                Tmp.v3.trns(Angles.angle(x, y, b.drawx(), b.drawy()), (float)b.block.size * 2.0f);
                Lines.circle(b.drawx(), b.drawy(), (float)b.block.size * 2.0f);
                Draw.color(unit.team.color);
                Lines.line(x + Tmp.v2.x, y + Tmp.v2.y, b.drawx() - Tmp.v3.x, b.drawy() - Tmp.v3.y);
                x = b.drawx();
                y = b.drawy();
                s = (float)b.block.size * 2.0f;
                if (++counter < 100) continue;
                break;
            }
            Draw.reset();
        }
    }

    private static void drawHitBox(Unit unit) {
        if (unithitbox) {
            Draw.color(unit.team.color, 0.5f);
            Lines.circle(unit.x, unit.y, unit.hitSize / 2.0f);
            Draw.reset();
        }
    }

    private static void detailBuildMode() {
        if (!arcBuildInfo) {
            return;
        }
        if (Vars.control.input.droppingItem) {
            Color color = Vars.player.within(Core.input.mouseWorld(Vars.control.input.getMouseX(), Vars.control.input.getMouseY()), 220.0f) ? Color.gold : Color.red;
            DrawUtilities.drawNSideRegion(Vars.player.unit().x, Vars.player.unit().y, 3, Vars.player.unit().type.buildRange, Vars.player.unit().rotation, color, 0.25f, Vars.player.unit().stack.item.uiIcon, false);
        } else if (Vars.control.input.isBuilding || Vars.control.input.selectedBlock() || !Vars.player.unit().plans().isEmpty()) {
            DrawUtilities.drawNSideRegion(Vars.player.unit().x, Vars.player.unit().y, 3, Vars.player.unit().type.buildRange, Vars.player.unit().rotation, Pal.heal, 0.25f, Icon.wrench.getRegion(), true);
        }
    }

    public static void drawControlTurret() {
        Unit unit = Vars.player.unit();
        if (unit instanceof BlockUnitc) {
            BlockUnitc unitc = (BlockUnitc)((Object)unit);
            unitc.tile().drawSelect();
        }
    }

    static {
        unitTrans = 1.0f;
        drawUnit = true;
        drawUnitBar = false;
        unitDrawMinHealth = 1.0f;
        unitBarDrawMinHealth = 1.0f;
        unitWeaponRangeAlpha = 1.0f;
        unitWeaponRange = 1.0f;
        selectedUnitsFlyer = false;
        selectedUnitsLand = false;
        canHitPlayer = false;
        canHitCommand = false;
        canHitPlans = false;
        canHitMouse = false;
        iconSize = 4.0f;
        Events.run((Object)EventType.Trigger.update, () -> {
            alwaysShowPlayerUnit = Core.settings.getBool("alwaysShowPlayerUnit");
            alwaysShowUnitRTSAi = Core.settings.getBool("alwaysShowUnitRTSAi");
            unitHealthBar = Core.settings.getBool("unitHealthBar");
            unitLogicMoveLine = Core.settings.getBool("unitLogicMoveLine");
            unitLogicTimerBars = Core.settings.getBool("unitLogicTimerBars");
            unithitbox = Core.settings.getBool("unithitbox");
            unitBuildPlan = Core.settings.getBool("unitbuildplan");
            defaultUnitTrans = (float)Core.settings.getInt("unitTransparency") / 100.0f;
            unitDrawMinHealth = Core.settings.getInt("unitDrawMinHealth");
            unitBarDrawMinHealth = Core.settings.getInt("unitBarDrawMinHealth");
            unitWeaponRange = Core.settings.getInt("unitWeaponRange") * 8;
            unitWeaponRangeAlpha = (float)Core.settings.getInt("unitWeaponRangeAlpha") / 100.0f;
            selectedUnitsFlyer = Vars.control.input.selectedUnits.contains((Unit)((Object)((Boolf<Unit>)unit -> unit.isFlying())));
            selectedUnitsLand = Vars.control.input.selectedUnits.contains((Unit)((Object)((Boolf<Unit>)unit -> !unit.isFlying())));
            curStroke = (float)Core.settings.getInt("playerEffectCurStroke") / 10.0f;
            unitTargetType = Core.settings.getInt("unitTargetType");
            superUnitEffect = Core.settings.getInt("superUnitEffect");
            arcBuildInfo = Core.settings.getBool("arcBuildInfo");
        });
    }
}

