/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.draw;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.draw.ARCUnits;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.distribution.MassDriver;

public class ARCBuilds {
    static boolean targetAir = false;
    static boolean targetGround = false;
    static boolean canShoot = false;
    static boolean turretForceShowRange = false;
    static int turretShowRange = 0;
    static int turretAlertRange;
    static boolean canHitPlayer;
    static boolean canHitCommand;
    static boolean canHitPlans;
    static boolean canHitMouse;
    static boolean showTurretAmmo;
    static boolean showTurretAmmoAmount;
    static boolean blockWeaponTargetLine;
    static boolean blockWeaponTargetLineWhenIdle;
    static int msLineAlpha;
    static int msLineInterval;
    static int msSlicer;
    static boolean msShootingDraw;
    static String msLineColor;
    static Building target;
    static float msSin;

    public static void drawARCBuilds(Building build) {
        if (build == null || !ARCVars.arcInfoControl(build.team).booleanValue()) {
            return;
        }
        if (build instanceof BaseTurret.BaseTurretBuild) {
            BaseTurret.BaseTurretBuild builds = (BaseTurret.BaseTurretBuild)build;
            ARCBuilds.arcTurret(builds);
        } else if (build instanceof MassDriver.MassDriverBuild) {
            MassDriver.MassDriverBuild builds = (MassDriver.MassDriverBuild)build;
            if (msLineAlpha > 0) {
                ARCBuilds.arcMassDriver(builds);
            }
        }
    }

    private static void drawRange(BaseTurret.BaseTurretBuild build) {
        Draw.z(49.2f);
        Draw.color(build.team.color, 0.6f);
        Lines.circle(build.x, build.y, build.range());
        Draw.reset();
    }

    private static void arcTurret(BaseTurret.BaseTurretBuild build) {
        Draw.z(50.0f);
        Vec2 targetPos = Vec2.ZERO;
        Block block = build.block;
        if (block instanceof Turret) {
            Turret t = (Turret)block;
            targetAir = t.targetAir;
            targetGround = t.targetGround;
            targetPos = ((Turret.TurretBuild)build).targetPos;
            canShoot = ((Turret.TurretBuild)build).hasAmmo();
        } else {
            block = build.block;
            if (block instanceof TractorBeamTurret) {
                TractorBeamTurret t = (TractorBeamTurret)block;
                targetAir = t.targetAir;
                targetGround = t.targetGround;
                Unit target = ((TractorBeamTurret.TractorBeamBuild)build).target;
                if (target != null) {
                    targetPos = Tmp.v1.set(target.x, target.y);
                }
                boolean bl = canShoot = build.potentialEfficiency > 0.0f;
            }
        }
        if (build instanceof PowerTurret.PowerTurretBuild) {
            boolean bl = canShoot = build.efficiency > 0.0f;
        }
        if (turretForceShowRange || canShoot) {
            if (turretShowRange == 3 || turretShowRange == 2 && targetAir || turretShowRange == 1 && targetGround) {
                ARCBuilds.drawRange(build);
            } else if (turretAlertRange > 0 && build.team != Vars.player.team()) {
                canHitPlayer = !Vars.player.unit().isNull() && Vars.player.unit().hittable() && (Vars.player.unit().isFlying() ? targetAir : targetGround) && build.within(Vars.player.unit().x, Vars.player.unit().y, build.range() + (float)turretAlertRange);
                canHitMouse = build.within(Core.input.mouseWorldX(), Core.input.mouseWorldY(), build.range() + (float)turretAlertRange);
                canHitCommand = Vars.control.input.commandMode && (ARCUnits.selectedUnitsFlyer && targetAir || ARCUnits.selectedUnitsLand && targetGround);
                boolean bl = canHitPlans = (Vars.control.input.block != null || Vars.control.input.selectPlans.size > 0) && targetGround;
                if (canHitPlayer || canHitMouse && (canHitCommand || canHitPlans)) {
                    ARCBuilds.drawRange(build);
                }
            }
            if (showTurretAmmo && build instanceof ItemTurret.ItemTurretBuild) {
                ItemTurret.ItemTurretBuild it = (ItemTurret.ItemTurretBuild)build;
                if (it.ammo.any()) {
                    ItemTurret.ItemEntry entry = (ItemTurret.ItemEntry)it.ammo.peek();
                    Item lastAmmo = entry.item;
                    Draw.z(50.1f);
                    float size = Math.max(4.0f, (float)(build.block.size * 8) / 2.5f);
                    float ammoX = build.x - (float)(build.block.size * 8) / 2.0f + size / 2.0f;
                    float ammoY = build.y - (float)(build.block.size * 8) / 2.0f + size / 2.0f;
                    Draw.rect(lastAmmo.uiIcon, ammoX, ammoY, size, size);
                    float leftAmmo = Mathf.lerp(0.0f, 1.0f, Math.min(1.0f, (float)entry.amount / (float)((ItemTurret)it.block).maxAmmo));
                    if (leftAmmo < 0.75f && showTurretAmmoAmount) {
                        Draw.alpha(0.5f);
                        Draw.color(lastAmmo.color);
                        Lines.stroke(Lines.getStroke() * (float)build.block.size * 0.5f);
                        Lines.arc(ammoX, ammoY, size * 0.5f, leftAmmo);
                    }
                    Draw.reset();
                }
            }
            if (targetPos.x != 0.0f && targetPos.y != 0.0f && blockWeaponTargetLine && Mathf.len(targetPos.x - build.x, targetPos.y - build.y) <= 1500.0f) {
                if (!(build instanceof Turret.TurretBuild) || ((Turret.TurretBuild)build).isShooting() || ((Turret.TurretBuild)build).isControlled()) {
                    Draw.color(1.0f, 0.2f, 0.2f, 0.8f);
                    Lines.stroke(1.5f);
                    Lines.line(build.x, build.y, targetPos.x, targetPos.y);
                    Lines.dashCircle(targetPos.x, targetPos.y, 8.0f);
                } else if (blockWeaponTargetLineWhenIdle) {
                    Draw.color(1.0f, 1.0f, 1.0f, 0.3f);
                    Lines.stroke(1.5f);
                    Lines.line(build.x, build.y, targetPos.x, targetPos.y);
                    Lines.dashCircle(targetPos.x, targetPos.y, 8.0f);
                }
            }
        }
        Draw.reset();
    }

    private static void arcMassDriver(MassDriver.MassDriverBuild build) {
        target = Vars.world.build(build.link);
        if (target == null) {
            return;
        }
        if (build.state != MassDriver.DriverState.shooting && msShootingDraw) {
            return;
        }
        Draw.z(110.0f);
        Lines.stroke(2.0f, Pal.placing);
        Draw.alpha(msLineAlpha);
        Drawf.dashLine(ARCBuilds.msLineColor(), build.x, build.y, ARCBuilds.target.x, ARCBuilds.target.y);
        Draw.alpha(msLineAlpha);
        Drawf.arrow(build.x, build.y, ARCBuilds.target.x, ARCBuilds.target.y, (float)(build.block.size * 8) + msSin, 4.0f + msSin, Pal.place);
        Tmp.v2.set(ARCBuilds.target.x - build.x, ARCBuilds.target.y - build.y);
        msSlicer = (int)(Tmp.v2.len() / (float)msLineInterval);
        Tmp.v2.limit2(Tmp.v2.len() / (float)(msSlicer + 1));
        for (int slicer = 1; slicer <= msSlicer; ++slicer) {
            Draw.alpha(msLineAlpha);
            Drawf.arrow(build.x + Tmp.v2.x * (float)slicer * 8.0f, build.y + Tmp.v2.y * (float)slicer * 8.0f, ARCBuilds.target.x, ARCBuilds.target.y, (float)(build.block.size * 8) + msSin, 4.0f + msSin, Pal.place);
        }
        Draw.reset();
    }

    public static Color msLineColor() {
        String color = Core.settings.getString("msLineColor");
        if (color != null && color.length() == 6) {
            for (char c : color.toCharArray()) {
                if (Character.isDigit(c) || Character.isLetter(c) && Character.toLowerCase(c) - 97 <= 5) continue;
                return Color.valueOf("ff8c66");
            }
            return Color.valueOf(color);
        }
        return Color.valueOf("ff8c66");
    }

    static {
        canHitPlayer = false;
        canHitCommand = false;
        canHitPlans = false;
        canHitMouse = false;
        showTurretAmmo = false;
        showTurretAmmoAmount = false;
        blockWeaponTargetLine = false;
        blockWeaponTargetLineWhenIdle = false;
        msLineAlpha = 0;
        msLineInterval = 0;
        msSlicer = 0;
        msLineColor = "";
        Events.run((Object)EventType.Trigger.update, () -> {
            turretForceShowRange = Core.settings.getBool("turretForceShowRange");
            turretShowRange = Core.settings.getInt("turretShowRange");
            turretAlertRange = Core.settings.getInt("turretAlertRange") * 8;
            showTurretAmmo = Core.settings.getBool("showTurretAmmo");
            showTurretAmmoAmount = Core.settings.getBool("showTurretAmmoAmount");
            blockWeaponTargetLine = Core.settings.getBool("blockWeaponTargetLine");
            blockWeaponTargetLineWhenIdle = Core.settings.getBool("blockWeaponTargetLineWhenIdle");
            msLineAlpha = Core.settings.getInt("msLineAlpha");
            msLineInterval = Core.settings.getInt("msLineInterval");
            msLineColor = Core.settings.getString("msLineColor");
            msShootingDraw = Core.settings.getBool("msShootingDraw");
            msSin = Mathf.absin(Time.time, 6.0f, 1.0f);
        });
    }
}

