/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ai;

import arc.util.Nullable;
import arc.util.Time;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.storage.CoreBlock;

public class ArcRepairAI
extends AIController {
    public static float retreatDst = 160.0f;
    public static float fleeRange = 310.0f;
    public static float retreatDelay = 180.0f;
    @Nullable
    Teamc avoid;
    float retreatTimer;
    Building damagedTarget;

    @Override
    public void updateMovement() {
        if (this.target instanceof Building) {
            boolean shoot = false;
            if (this.target.within(this.unit, this.unit.type.range)) {
                this.unit.aim(this.target);
                shoot = true;
            }
            this.unit.controlWeapons(shoot);
        } else if (this.target == null) {
            this.unit.controlWeapons(false);
        }
        if (this.target != null) {
            Teamc teamc;
            if (!this.target.within(this.unit, this.unit.type.range * 0.65f) && (teamc = this.target) instanceof Building) {
                Building b = (Building)teamc;
                if (b.team == this.unit.team) {
                    this.moveTo(this.target, this.unit.type.range * 0.65f);
                }
            }
            this.unit.lookAt(this.target);
        }
        if (!(this.target instanceof Building)) {
            CoreBlock.CoreBuild core;
            float f;
            if (this.timer.get(3, 40.0f)) {
                this.avoid = this.target(this.unit.x, this.unit.y, fleeRange, true, true);
            }
            this.retreatTimer += Time.delta;
            if (f >= retreatDelay && this.avoid != null && (core = this.unit.closestCore()) != null && !this.unit.within(core, retreatDst)) {
                this.moveTo(core, retreatDst);
            }
        } else {
            this.retreatTimer = 0.0f;
        }
    }

    @Override
    public void updateTargeting() {
        if (this.timer.get(0, 15.0f)) {
            this.damagedTarget = Units.findDamagedTile(this.unit.team, this.unit.x, this.unit.y);
            if (this.damagedTarget instanceof ConstructBlock.ConstructBuild) {
                this.damagedTarget = null;
            }
        }
        if (this.damagedTarget == null) {
            super.updateTargeting();
        } else {
            this.target = this.damagedTarget;
        }
    }
}

