/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ai;

import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.storage.CoreBlock;

public class ArcMinerAI
extends AIController {
    public static final Seq<Block> oreAllList = Vars.content.blocks().select(b -> {
        if (!(b instanceof Floor)) return false;
        Floor f = (Floor)b;
        if (f.wallOre) return false;
        if (f.itemDrop == null) return false;
        return true;
    });
    public static final Seq<Block> oreAllWallList = Vars.content.blocks().select(b -> {
        block3: {
            block2: {
                if (!(b instanceof Floor)) break block2;
                Floor f = (Floor)b;
                if (f.wallOre) break block3;
            }
            if (!(b instanceof StaticWall)) return false;
        }
        if (b.itemDrop == null) return false;
        return true;
    });
    public static Seq<Block> oreList = Vars.content.blocks().select(b -> {
        if (!(b instanceof Floor)) return false;
        Floor f = (Floor)b;
        if (f.wallOre) return false;
        if (f.itemDrop == null) return false;
        return true;
    });
    public static Seq<Block> oreWallList = Vars.content.blocks().select(b -> {
        block3: {
            block2: {
                if (!(b instanceof Floor)) break block2;
                Floor f = (Floor)b;
                if (f.wallOre) break block3;
            }
            if (!(b instanceof StaticWall)) return false;
        }
        if (b.itemDrop == null) return false;
        return true;
    });
    public Seq<Item> canMineList;
    public boolean mining = true;
    public Item targetItem;
    public Tile ore;

    @Override
    public void init() {
        if (!this.unit.canMine()) {
            return;
        }
        if (this.unit.type.mineFloor) {
            this.canMineList = oreList.map(b -> b.itemDrop).select(i -> this.unit.canMine((Item)i));
        } else if (this.unit.type.mineWalls) {
            this.canMineList = oreWallList.map(b -> b.itemDrop).select(i -> this.unit.canMine((Item)i));
        }
    }

    private Item updateTargetItem(boolean canMineNonBuildable) {
        if (this.unit.type.mineFloor) {
            this.canMineList = oreList.map(b -> b.itemDrop).select(i -> this.unit.canMine((Item)i));
        } else if (this.unit.type.mineWalls) {
            this.canMineList = oreWallList.map(b -> b.itemDrop).select(i -> this.unit.canMine((Item)i));
        }
        return this.canMineList.select(i -> (this.unit.type.mineFloor ? Vars.indexer.hasOre((Item)i) : Vars.indexer.hasWallOre((Item)i)) && (canMineNonBuildable || i.buildable) && this.unit.core().acceptItem(null, (Item)i)).reverse().min(i -> this.unit.core().items.get((Item)i));
    }

    private Tile findClosetOre(Building build) {
        if (this.unit.type.mineFloor) {
            return Vars.indexer.findClosestOre(build.x, build.y, this.targetItem);
        }
        return Vars.indexer.findClosestWallOre(build.x, build.y, this.targetItem);
    }

    @Override
    public void updateMovement() {
        CoreBlock.CoreBuild targetCore;
        if (!this.unit.canMine() || this.canMineList.isEmpty() || this.unit.core() == null) {
            return;
        }
        CoreBlock.CoreBuild core = this.unit.closestCore();
        CoreBlock.CoreBuild core2 = this.unit.team.data().cores.select(c -> !((CoreBlock)c.block).incinerateNonBuildable).min(c -> this.unit.dst((Position)c));
        CoreBlock.CoreBuild coreBuild = targetCore = this.targetItem == null || this.targetItem.buildable || core2 == null ? core : core2;
        if (this.unit.type.canBoost) {
            Vars.player.boosting = true;
        }
        if (this.mining) {
            if (this.targetItem != null && (!core.acceptItem(null, this.targetItem) || core2 == null && !this.targetItem.buildable)) {
                this.unit.mineTile = null;
                this.targetItem = null;
            }
            if (this.targetItem == null || this.timer.get(1, 300.0f)) {
                this.targetItem = this.updateTargetItem(core2 != null);
                if (this.targetItem == null) {
                    return;
                }
            }
            if (!this.unit.acceptsItem(this.targetItem) || this.unit.stack.amount >= this.unit.type.itemCapacity) {
                this.mining = false;
                return;
            }
            if (this.ore == null || !this.unit.validMine(this.ore, false) || this.ore.drop() != this.targetItem || this.timer.get(2, 120.0f)) {
                this.ore = this.findClosetOre(targetCore);
                if (this.ore == null) {
                    return;
                }
            }
            Tmp.v1.setLength(this.unit.type.mineRange * 0.9f).limit(this.ore.dst(targetCore) - 0.5f).setAngle(this.ore.angleTo(targetCore)).add(this.ore);
            this.moveTo(Tmp.v1, 0.1f);
            if (this.unit.validMine(this.ore)) {
                this.unit.mineTile = this.ore;
            }
        } else {
            this.unit.mineTile = null;
            if (this.unit.stack.amount == 0) {
                this.mining = true;
                return;
            }
            if (!core.acceptItem(null, this.unit.stack.item)) {
                this.unit.clearItem();
            }
            this.moveTo(targetCore, core.hitSize());
            if (this.unit.within(targetCore, 220.0f) && targetCore.acceptItem(null, this.targetItem)) {
                DesktopInput di;
                InputHandler inputHandler = Vars.control.input;
                if (inputHandler instanceof DesktopInput) {
                    di = (DesktopInput)inputHandler;
                    di.autoAim = true;
                }
                this.unit.aimX = core.x;
                this.unit.aimY = core.y;
                Call.transferInventory(Vars.player, core);
                this.targetItem = this.updateTargetItem(core2 != null);
                inputHandler = Vars.control.input;
                if (inputHandler instanceof DesktopInput) {
                    di = (DesktopInput)inputHandler;
                    Time.run(30.0f, () -> {
                        di.autoAim = false;
                    });
                }
            }
        }
    }

    @Override
    public void updateVisuals() {
    }
}

