/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ai;

import arc.func.Boolf;
import arc.func.Cons;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.GroundAI;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.input.DesktopInput;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.StaticWall;

public class ATRIAI
extends AIController {
    public static float buildRadius = 1500.0f;
    public static float retreatDst = 110.0f;
    public static float retreatDelay = 120.0f;
    public static float rebuildTime = 120.0f;
    @Nullable
    public Unit following;
    @Nullable
    public Teamc enemy;
    @Nullable
    public Teams.BlockPlan lastPlan;
    public float fleeRange = 370.0f;
    boolean found = false;
    float retreatTimer;
    public static final Seq<Block> oreAllList = Vars.content.blocks().select(b -> {
        if (!(b instanceof Floor)) return false;
        Floor f = (Floor)b;
        if (f.wallOre) return false;
        if (f.itemDrop == null) return false;
        return true;
    });
    public static final Seq<Block> oreAllWallList = Vars.content.blocks().select(b -> {
        block3: {
            block2: {
                if (!(b instanceof Floor)) break block2;
                Floor f = (Floor)b;
                if (f.wallOre) break block3;
            }
            if (!(b instanceof StaticWall)) return false;
        }
        if (b.itemDrop == null) return false;
        return true;
    });
    public static Seq<Block> oreList = Vars.content.blocks().select(b -> {
        if (!(b instanceof Floor)) return false;
        Floor f = (Floor)b;
        if (f.wallOre) return false;
        if (f.itemDrop == null) return false;
        return true;
    });
    public static Seq<Block> oreWallList = Vars.content.blocks().select(b -> {
        block3: {
            block2: {
                if (!(b instanceof Floor)) break block2;
                Floor f = (Floor)b;
                if (f.wallOre) break block3;
            }
            if (!(b instanceof StaticWall)) return false;
        }
        if (b.itemDrop == null) return false;
        return true;
    });
    public Seq<Item> canMineList;
    public boolean mining = true;
    public Item targetItem;
    public Tile ore;

    public ATRIAI(float fleeRange) {
        this.fleeRange = fleeRange;
    }

    public ATRIAI() {
    }

    @Override
    public void init() {
        if (!this.unit.canMine()) {
            return;
        }
        if (this.unit.type.mineFloor) {
            this.canMineList = oreList.map(b -> b.itemDrop).select(i -> this.unit.canMine((Item)i));
        } else if (this.unit.type.mineWalls) {
            this.canMineList = oreWallList.map(b -> b.itemDrop).select(i -> this.unit.canMine((Item)i));
        }
    }

    @Override
    public void updateMovement() {
        this.builderMode();
    }

    /*
     * Unable to fully structure code
     */
    private void builderMode() {
        block23: {
            block21: {
                block22: {
                    if (this.target != null && this.shouldShoot()) {
                        this.unit.lookAt(this.target);
                    }
                    this.unit.updateBuilding = true;
                    if (this.following != null) {
                        this.retreatTimer = 0.0f;
                        if (!this.following.isValid() || !this.following.activelyBuilding()) {
                            this.following = null;
                            this.unit.plans.clear();
                            return;
                        }
                        this.unit.plans.clear();
                        this.unit.plans.addFirst(this.following.buildPlan());
                        this.lastPlan = null;
                    } else if (this.unit.buildPlan() == null) {
                        if (this.timer.get(3, 40.0f)) {
                            this.enemy = this.target(this.unit.x, this.unit.y, this.fleeRange, true, true);
                        }
                        this.retreatTimer += Time.delta;
                        if (v0 >= ATRIAI.retreatDelay && this.enemy != null) {
                            this.unit.clearBuilding();
                            core = this.unit.closestCore();
                            if (core != null && !this.unit.within(core, ATRIAI.retreatDst)) {
                                this.moveTo(core, ATRIAI.retreatDst);
                            }
                        }
                    }
                    if (this.unit.buildPlan() == null) break block21;
                    if (this.unit.controller() == Vars.player && (var2_2 = Vars.control.input) instanceof DesktopInput) {
                        di = (DesktopInput)var2_2;
                        di.isBuilding = true;
                    }
                    req = this.unit.buildPlan();
                    if (!req.breaking && this.timer.get(1, 40.0f)) {
                        for (Player player : Groups.player) {
                            if (!player.isBuilder() || !player.unit().activelyBuilding() || !player.unit().buildPlan().samePos(req) || !player.unit().buildPlan().breaking) continue;
                            this.unit.plans.removeFirst();
                            this.unit.team.data().plans.remove((Teams.BlockPlan)(Boolf<Teams.BlockPlan>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$builderMode$8(mindustry.entities.units.BuildPlan mindustry.game.Teams$BlockPlan ), (Lmindustry/game/Teams$BlockPlan;)Z)((BuildPlan)req));
                            return;
                        }
                    }
                    if (this.lastPlan != null && this.lastPlan.removed) ** GOTO lbl-1000
                    if (req.tile() == null || !((var4_6 = req.tile().build) instanceof ConstructBlock.ConstructBuild)) break block22;
                    cons = (ConstructBlock.ConstructBuild)var4_6;
                    if (cons.current == req.block) ** GOTO lbl-1000
                }
                if (req.breaking != false ? Build.validBreak(this.unit.team(), req.x, req.y) != false : Build.validPlace(req.block, this.unit.team(), req.x, req.y, req.rotation) != false) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = valid = false;
                }
                if (valid) {
                    this.moveTo(req.tile(), this.unit.type.buildRange - 20.0f);
                } else {
                    this.unit.plans.removeFirst();
                    this.lastPlan = null;
                }
                break block23;
            }
            if (this.timer.get(1, 60.0f)) {
                this.found = false;
                Units.nearby(this.unit.team, this.unit.x, this.unit.y, ATRIAI.buildRadius, (Cons<Unit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$builderMode$9(mindustry.gen.Unit ), (Lmindustry/gen/Unit;)V)((ATRIAI)this));
            }
            if (!this.unit.team.data().plans.isEmpty() && this.following == null && this.timer.get(2, ATRIAI.rebuildTime)) {
                blocks = this.unit.team.data().plans;
                block = blocks.first();
                if (Vars.world.tile(block.x, block.y) != null && Vars.world.tile((int)block.x, (int)block.y).block().id == block.block.id) {
                    blocks.removeFirst();
                } else if (Build.validPlace(block.block, this.unit.team(), block.x, block.y, block.rotation) && !this.nearEnemy(block.x, block.y)) {
                    this.lastPlan = block;
                    this.unit.addBuild(new BuildPlan(block.x, block.y, block.rotation, block.block, block.config));
                    blocks.addLast(blocks.removeFirst());
                } else {
                    blocks.addLast(blocks.removeFirst());
                }
            }
        }
    }

    protected boolean nearEnemy(int x, int y) {
        return Units.nearEnemy(this.unit.team, (float)(x * 8) - this.fleeRange / 2.0f, (float)(y * 8) - this.fleeRange / 2.0f, this.fleeRange, this.fleeRange);
    }

    @Override
    public AIController fallback() {
        return this.unit.type.flying ? new FlyingAI() : new GroundAI();
    }

    @Override
    public boolean useFallback() {
        return Vars.state.rules.waves && this.unit.team == Vars.state.rules.waveTeam && !this.unit.team.rules().rtsAi;
    }

    @Override
    public boolean shouldShoot() {
        return !this.unit.isBuilding() && this.unit.type.canAttack;
    }

    private /* synthetic */ void lambda$builderMode$9(Unit u) {
        if (this.found) {
            return;
        }
        if (u.canBuild() && u != this.unit && u.activelyBuilding()) {
            ConstructBlock.ConstructBuild cons;
            float dist;
            BuildPlan plan = u.buildPlan();
            Building build = Vars.world.build(plan.x, plan.y);
            if (build instanceof ConstructBlock.ConstructBuild && (dist = Math.min((cons = (ConstructBlock.ConstructBuild)build).dst(this.unit) - this.unit.type.buildRange, 0.0f)) / this.unit.speed() < cons.buildCost * 0.9f) {
                this.following = u;
                this.found = true;
            }
        }
    }

    private static /* synthetic */ boolean lambda$builderMode$8(BuildPlan req, Teams.BlockPlan p) {
        return p.x == req.x && p.y == req.y;
    }
}

