/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.Events;
import arc.func.Floatp;
import arc.math.WindowedMean;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.game.EventType;

public class TimeControl {
    public static float gameSpeed = 1.0f;
    public static int targetFps = 60;
    public static boolean fpsLock = false;
    public static WindowedMean gameSpeedBalance = new WindowedMean(120);
    public static final Floatp deltaProvider = () -> {
        float delta = Core.graphics.getDeltaTime();
        float f = delta = Float.isNaN(delta) || Float.isInfinite(delta) ? 1.0f : Math.max(delta, 1.0E-4f);
        if (fpsLock) {
            gameSpeedBalance.add(1.0f / (delta * (float)targetFps));
            return 60.0f / (float)targetFps;
        }
        return delta * 60.0f * gameSpeed;
    };

    public static void setGameSpeed(float speed) {
        gameSpeed = speed;
        if (!fpsLock) {
            Vars.ui.announce(Strings.format("\u5f53\u524d\u6e38\u620f\u901f\u5ea6\uff1a@\u500d", Float.valueOf(gameSpeed)));
        } else {
            TimeControl.unlockFps();
        }
    }

    public static void changeGameSpeed(float mul) {
        gameSpeed *= mul;
        if (!fpsLock) {
            Vars.ui.announce(Strings.format("\u5f53\u524d\u6e38\u620f\u901f\u5ea6\uff1a@\u500d", Float.valueOf(gameSpeed)));
        } else {
            TimeControl.unlockFps();
        }
    }

    public static float getGameSpeed() {
        if (fpsLock) {
            return gameSpeedBalance.rawMean();
        }
        return gameSpeed;
    }

    public static void setTargetFps(int fps) {
        targetFps = fps;
        if (fpsLock) {
            Vars.ui.announce(Strings.format("\u5f53\u524d\u5e27\u7387\u9501\u5b9a\uff1a@", targetFps));
        }
    }

    public static void lockFps() {
        fpsLock = true;
        Vars.ui.announce(Strings.format("\u5df2\u5f00\u542f\u5e27\u7387\u9501\u5b9a\u6a21\u5f0f\n\u5f53\u524d\u5e27\u7387\u9501\u5b9a\uff1a@", targetFps));
    }

    public static void unlockFps() {
        fpsLock = false;
        gameSpeedBalance.clear();
        Vars.ui.announce(Strings.format("\u5df2\u5173\u95ed\u5e27\u7387\u9501\u5b9a\u6a21\u5f0f\n\u5f53\u524d\u6e38\u620f\u901f\u5ea6\uff1a@\u500d", Float.valueOf(gameSpeed)));
    }

    static {
        Events.on(EventType.ResetEvent.class, e -> {
            gameSpeed = 1.0f;
            targetFps = 60;
            fpsLock = false;
        });
    }
}

