/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;

public class SimpleKeystrokes {
    public static final SimpleKeystrokes INSTANCE = new SimpleKeystrokes();
    public Table table;
    public OrderedMap<String, KeystrokesConfig> buttonConfigs = new OrderedMap();

    public SimpleKeystrokes() {
        this.table = new Table();
    }

    public void initKey(String configName, Seq<KeyCode> keyCodes, Runnable run) {
        this.buttonConfigs.put(configName, new KeystrokesConfig(keyCodes, run));
    }

    public void reBindKey(String configName, Seq<KeyCode> keyCodes) {
        ((KeystrokesConfig)this.buttonConfigs.get((String)configName)).keyCodeSeq = keyCodes;
        Core.settings.put(configName, SimpleKeystrokes.keyCode2String(keyCodes));
    }

    public static String keyCode2String(Seq<KeyCode> keyCodes) {
        if (keyCodes.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(keyCodes.first().name());
        for (int i = 1; i < keyCodes.size; ++i) {
            buffer.append(",");
            buffer.append(keyCodes.get(i).name());
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static Seq<KeyCode> string2KeyCode(String string) {
        Seq<KeyCode> keyCodes = new Seq<KeyCode>();
        if (string.startsWith("[") && string.endsWith("]")) {
            String[] array;
            String trimmed = string.substring(1, string.length() - 1);
            for (String s : array = trimmed.split(",")) {
                KeyCode keyCode;
                String key = s.trim();
                if (s.isEmpty()) continue;
                try {
                    keyCode = KeyCode.valueOf(key);
                }
                catch (IllegalArgumentException ignored) {
                    return keyCodes;
                }
                keyCodes.add(keyCode);
            }
        }
        return keyCodes;
    }

    public void update() {
        this.buttonConfigs.each((b, k) -> k.tryActivated());
    }

    public static class KeystrokesConfig {
        public Seq<KeyCode> keyCodeSeq;
        public boolean activated;
        public Seq<KeyCode> record;
        public Runnable run;

        public KeystrokesConfig(Seq<KeyCode> keyCodeSeq, Runnable run) {
            this.keyCodeSeq = keyCodeSeq;
            this.run = run;
            this.activated = false;
            this.record = new Seq(keyCodeSeq.size);
        }

        public boolean tryActivated() {
            KeyCode k2;
            int length = this.keyCodeSeq.size;
            if (length == 0 || this.run == null) {
                return false;
            }
            this.keyCodeSeq.each(k -> {
                boolean b = Core.input.keyDown((KeyCode)k);
                if (b && !this.record.contains((KeyCode)k)) {
                    this.record.add((KeyCode)k);
                } else if (!b && this.record.contains((KeyCode)k)) {
                    this.activated = false;
                    this.record.remove((KeyCode)k);
                }
            });
            for (int i = 0; i < this.keyCodeSeq.size && this.record.size == length && (k2 = this.keyCodeSeq.get(i)).equals(this.record.get(i)); ++i) {
                if (i != length - 1 || this.activated) continue;
                this.activated = true;
                this.run.run();
                return true;
            }
            return false;
        }
    }

    public static class SetKeyGui {
        public static final SetKeyGui INSTANCE = new SetKeyGui();
        protected float scroll;

        public void openAllConfigUi() {
            Dialog mainDialog = new Dialog("\u6309\u94ae\u5feb\u6377\u952e");
            this.addCloseButton(mainDialog);
            mainDialog.setFillParent(true);
            mainDialog.title.setAlignment(1);
            mainDialog.titleTable.row();
            mainDialog.titleTable.add(new Image()).growX().height(3.0f).pad(4.0f).get().setColor(Pal.accent);
            mainDialog.cont.clear();
            SimpleKeystrokes simpleKeystrokes = INSTANCE;
            OrderedMap<String, KeystrokesConfig> buttonConfigs = simpleKeystrokes.buttonConfigs;
            Dialog table = new Dialog();
            ScrollPane pane = new ScrollPane((Element)table);
            pane.setFadeScrollBars(false);
            pane.update(() -> {
                this.scroll = pane.getScrollY();
            });
            for (ObjectMap.Entry entry : buttonConfigs) {
                table.add().height(10.0f);
                table.row();
                table.image().color(Color.gray).fillX().height(3.0f).pad(6.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
                String name = (String)entry.key;
                table.add((CharSequence)name, Color.white).left().padRight(20.0f).padLeft(8.0f);
                table.label(() -> SimpleKeystrokes.keyCode2String(((KeystrokesConfig)buttonConfigs.get(name)).keyCodeSeq)).color(Pal.accent).left().minWidth(90.0f).padRight(20.0f);
                this.addButton(table, name);
                table.row();
            }
            table.button("\u6e05\u7a7a\u5168\u90e8\u5df2\u7ed1\u5b9a\u6309\u94ae\u5feb\u6377\u952e", () -> simpleKeystrokes.buttonConfigs.forEach(configEntry -> simpleKeystrokes.reBindKey((String)configEntry.key, ((KeystrokesConfig)configEntry.value).keyCodeSeq))).colspan(4).padTop(4.0f).fill();
            mainDialog.cont.row();
            mainDialog.cont.add(pane).growX().colspan(simpleKeystrokes.buttonConfigs.size);
            mainDialog.show();
        }

        public void addCloseButton(Dialog dialog) {
            dialog.buttons.button("@back", Icon.left, dialog::hide).size(210.0f, 64.0f);
            dialog.keyDown(key -> {
                if (key == KeyCode.escape || key == KeyCode.back) {
                    dialog.hide();
                }
            });
        }

        public void addButton(Dialog dialog, String buttonName) {
            dialog.button("\u91cd\u65b0\u7ed1\u5b9a", Styles.defaultt, () -> this.openResetDialog(buttonName)).width(100.0f);
            dialog.button("\u53d6\u6d88\u7ed1\u5b9a", Styles.defaultt, () -> INSTANCE.reBindKey(buttonName, new Seq<KeyCode>())).width(100.0f);
        }

        public void openDialog(String name) {
            Dialog mainDialog = new Dialog();
            Dialog dialog = new Dialog();
            this.addCloseButton(mainDialog);
            mainDialog.setFillParent(true);
            mainDialog.cont.add(dialog);
            dialog.row();
            dialog.label(() -> name + " \u5f53\u524d\u5feb\u6377\u952e\u4e3a " + ((KeystrokesConfig)SimpleKeystrokes.INSTANCE.buttonConfigs.get((String)name)).keyCodeSeq.toString()).left().padRight(20.0f).padLeft(8.0f);
            this.addButton(dialog, name);
            dialog.row();
            dialog.button("\u67e5\u770b\u5168\u90e8\u6309\u94ae\u5feb\u6377\u952e", Styles.defaultt, () -> {
                mainDialog.hide();
                this.openAllConfigUi();
            }).colspan(4).padTop(4.0f).fill();
            dialog.row();
            mainDialog.show();
        }

        public void openResetDialog(String buttonName) {
            Dialog rebindDialog = new Dialog("\u8bf7\u8bbe\u7f6e\u5feb\u6377\u952e\uff0c\u53ef\u4ee5\u662f\u7ec4\u5408\u952e.");
            this.inputKey(buttonName, rebindDialog);
            rebindDialog.show();
        }

        public void inputKey(final String name, final Dialog rebindDialog) {
            InputListener inputListener = new InputListener(){
                Seq<KeyCode> downs = new Seq();
                Seq<KeyCode> ups = new Seq();

                @Override
                public boolean keyDown(InputEvent event, KeyCode keycode) {
                    if (!this.downs.contains(keycode)) {
                        this.downs.add(keycode);
                    }
                    return false;
                }

                @Override
                public boolean keyUp(InputEvent event, KeyCode keycode) {
                    this.ups.add(keycode);
                    if (!this.downs.isEmpty() && this.ups.containsAll(this.downs)) {
                        SimpleKeystrokes.INSTANCE.reBindKey(name, this.downs);
                        this.downs = new Seq();
                        this.ups = new Seq();
                        rebindDialog.hide();
                    }
                    return false;
                }
            };
            rebindDialog.addListener(inputListener);
        }
    }
}

