/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.IntMap;
import arc.util.Log;
import arc.util.Time;
import arc.util.io.ByteBufferOutput;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.TimeControl;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.net.Net;
import mindustry.net.Packet;
import mindustry.net.Packets;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class ReplayController {
    public static final int version = 2;
    private Writes writes;
    private Reads reads;
    private long startTime;
    private long allTime;
    private long lastTime;
    private long nextTime;
    private long length;
    private long skip = 0L;
    private Thread thread;
    private final Fi dir = Vars.dataDirectory.child("replays");
    private final ByteBuffer tmpBuf = ByteBuffer.allocate(32768);
    private final Writes tmpWr = new Writes(new ByteBufferOutput(this.tmpBuf));
    private boolean recording = false;
    private boolean recordEnabled = false;
    private final Table controller = new Table();
    private final IntMap<Integer> map = new IntMap();
    private ReplayData now = null;
    private BaseDialog dialog = null;
    public boolean writing = false;

    public ReplayController() {
        this.dir.mkdirs();
        this.thread = new Thread(() -> {
            while (true) {
                if (this.reads == null) {
                    try {
                        Thread thread = this.thread;
                        synchronized (thread) {
                            this.thread.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    this.readNextPacket();
                    continue;
                }
                catch (Exception e) {
                    this.closeReads();
                    this.reads = null;
                    Vars.net.disconnect();
                    ARCVars.replaying = false;
                    Core.app.post(() -> Vars.logic.reset());
                    continue;
                }
                break;
            }
        }, "Replay Controller");
        this.thread.setPriority(3);
        this.thread.setDaemon(true);
        this.thread.start();
        WidgetGroup g = new WidgetGroup();
        g.addChild(this.controller);
        g.setFillParent(true);
        g.touchable = Touchable.childrenOnly;
        g.visible(() -> ARCVars.replaying);
        this.controller.setFillParent(true);
        Events.on(EventType.ClientLoadEvent.class, e -> {
            Core.scene.add(g);
            this.dialog = new BaseDialog("\u56de\u653e\u7edf\u8ba1");
            this.dialog.shown(() -> {
                this.dialog.cont.clear();
                if (this.now == null) {
                    this.dialog.cont.add("\u672a\u52a0\u8f7d\u56de\u653e!");
                    return;
                }
                this.dialog.cont.add("\u56de\u653e\u7248\u672c:" + this.now.version).row();
                this.dialog.cont.add("\u56de\u653e\u521b\u5efa\u65f6\u95f4:" + this.now.time).row();
                this.dialog.cont.add("\u670d\u52a1\u5668ip:" + this.now.ip).row();
                this.dialog.cont.add("\u73a9\u5bb6\u540d:" + this.now.name).row();
                int secs = (int)(this.length / 1000000000L);
                this.dialog.cont.add("\u56de\u653e\u957f\u5ea6:" + secs / 3600 + ":" + secs / 60 % 60 + ":" + secs % 60).row();
                this.dialog.cont.pane(t -> this.map.keys().toArray().each(b -> t.add(Net.newPacket((byte)b).getClass().getSimpleName() + " " + this.map.get(b)).row())).growX().row();
            });
            this.dialog.addCloseButton();
            this.controller.table(t -> {
                t.setBackground(Styles.black3);
                t.table(tt -> {
                    tt.button("\u500d\u7387x2", () -> TimeControl.changeGameSpeed(2.0f));
                    tt.button("\u500d\u7387/2", () -> TimeControl.changeGameSpeed(0.5f));
                    tt.button("\u6682\u505c\u56de\u653e", () -> TimeControl.setGameSpeed(0.0f));
                    tt.button("\u6062\u590d\u539f\u901f", () -> TimeControl.setGameSpeed(1.0f));
                    tt.button("\u56de\u653e\u4fe1\u606f", this::showInfo);
                }).row();
                t.label(() -> "\u5f53\u524d\u500d\u7387:" + TimeControl.gameSpeed).row();
                t.label(() -> {
                    int secs = (int)(this.length / 1000000000L);
                    int escaped = (int)(this.timeEscaped() / 1000000000L);
                    return escaped / 3600 + ":" + escaped / 60 % 60 + ":" + escaped % 60 + "/" + secs / 3600 + ":" + secs / 60 % 60 + ":" + secs % 60;
                });
            }).growX().top().padTop(150.0f).row();
            this.controller.add().grow();
        });
        Events.run((Object)EventType.Trigger.update, () -> {
            if (Vars.state.getState() == GameState.State.menu && !Vars.netClient.isConnecting()) {
                this.closeReads();
                this.reads = null;
                ARCVars.replaying = false;
                this.stopPlay();
            }
        });
    }

    private void closeReads() {
        try {
            this.reads.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createReplay(String ip) {
        if (!this.recordEnabled || ARCVars.replaying) {
            return;
        }
        this.stop();
        try {
            this.writes = new Writes(new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new FileOutputStream(this.dir.child(new Date().getTime() + ".mrep").file())))));
        }
        catch (Exception e) {
            Log.err("\u521b\u5efa\u56de\u653e\u51fa\u9519!", e);
            return;
        }
        boolean anonymous = Core.settings.getBool("anonymous", false);
        this.writes.i(2);
        this.writes.l(new Date().getTime());
        this.writes.str(anonymous ? "anonymous" : ip);
        this.writes.str(anonymous ? "anonymous" : Vars.player.name.trim());
        this.recording = true;
        this.startTime = Time.nanos();
    }

    public void stop() {
        this.recording = false;
        try {
            this.writes.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writePacket(Packet p) {
        if (!this.recording || p instanceof Packets.WorldStream) {
            return;
        }
        try {
            byte id = Net.getPacketId(p);
            try {
                this.writes.l(Time.nanos() - this.startTime);
                this.writes.b(id);
                this.tmpBuf.position(0);
                this.writing = true;
                p.write(this.tmpWr);
                this.writing = false;
                int l = this.tmpBuf.position();
                this.writes.s(l);
                this.writes.b(this.tmpBuf.array(), 0, l);
            }
            catch (Exception e) {
                Vars.net.disconnect();
                Core.app.post(() -> Vars.ui.showException("\u5f55\u5236\u51fa\u9519!", e));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized long timeEscaped() {
        long escaped = (long)((float)(Time.nanos() - this.lastTime) * TimeControl.gameSpeed);
        this.allTime += escaped;
        this.lastTime = Time.nanos();
        return this.allTime;
    }

    private void readNextPacket() {
        long escaped = this.timeEscaped();
        if (escaped < this.nextTime && this.skip == 0L) {
            Thread.yield();
            return;
        }
        this.nextTime = this.reads.l();
        Object p = Net.newPacket(this.reads.b());
        int l = this.reads.us();
        ((Packet)p).read(this.reads, l);
        Core.app.post(() -> Vars.net.handleClientReceived((Packet)p));
        if (this.skip != 0L && escaped > this.skip) {
            this.skip = 0L;
        }
    }

    public void shouldRecord(boolean should) {
        this.recordEnabled = should;
    }

    public boolean shouldRecord() {
        return this.recordEnabled;
    }

    public Reads createReads(File input) {
        this.closeReads();
        try {
            return new Reads(new DataInputStream(new BufferedInputStream(new InflaterInputStream(new FileInputStream(input)), 32768)));
        }
        catch (Exception e) {
            Core.app.post(() -> Vars.ui.showException("\u8bfb\u53d6\u56de\u653e\u5931\u8d25!", e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlay(File input) {
        TimeControl.gameSpeed = 1.0f;
        Reads r = this.createReads(input);
        if (r == null) {
            return;
        }
        int version = r.i();
        Date time = new Date(r.l());
        String ip = r.str();
        String name = r.str();
        Log.info("version: @, time: @, ip: @, name: @", version, time, ip, name);
        this.now = new ReplayData(version, time, ip, name);
        try {
            while (true) {
                long l = r.l();
                byte id = r.b();
                r.skip(r.us());
                this.map.put(id, this.map.get((int)id, 0) + 1);
                this.length = l;
            }
        }
        catch (Exception e) {
            r = this.createReads(input);
            r.skip(12);
            r.str();
            r.str();
            ARCVars.replaying = true;
            this.reads = r;
            Vars.logic.reset();
            Vars.net.reset();
            try {
                Field f = Vars.net.getClass().getDeclaredField("active");
                f.setAccessible(true);
                f.set(Vars.net, true);
            }
            catch (Exception e2) {
                Vars.ui.showException(e2);
            }
            Packets.Connect c = new Packets.Connect();
            c.addressTCP = ip;
            Vars.net.handleClientReceived(c);
            Vars.netClient.beginConnecting();
            Vars.ui.loadfrag.setButton(() -> {
                Vars.ui.loadfrag.hide();
                Vars.netClient.disconnectQuietly();
                this.reads = null;
            });
            this.skip = 0L;
            this.allTime = 0L;
            this.nextTime = 0L;
            this.lastTime = Time.nanos();
            Thread thread = this.thread;
            synchronized (thread) {
                this.thread.notify();
            }
            return;
        }
    }

    public void stopPlay() {
        this.reads = null;
        ARCVars.replaying = false;
    }

    public void showInfo() {
        if (this.dialog != null) {
            this.dialog.show();
        }
    }

    private static class ReplayData {
        int version;
        Date time;
        String ip;
        String name;

        ReplayData(int version, Date time, String ip, String name) {
            this.version = version;
            this.time = time;
            this.ip = ip;
            this.name = name;
        }
    }
}

