/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.Graphics;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.PixmapRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.util.Http;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.NumberFormat;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.game.SpawnGroup;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Tex;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.ui.Fonts;
import mindustry.ui.fragments.ChatFragment;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.logic.LogicBlock;

public class RFuncs {
    static boolean colorized = false;
    static int msgSeperator = 145;
    public static boolean cursorChecked = false;
    public static Fi cachedCursor = null;

    public static void arcSetCamera(Tile tile) {
        RFuncs.arcSetCamera(tile.worldx(), tile.worldy());
    }

    public static void arcSetCamera(Building building) {
        RFuncs.arcSetCamera(building.x, building.y);
    }

    public static void arcSetCamera(float x, float y) {
        RFuncs.arcSetCamera(x, y, false);
    }

    public static void arcSetCamera(float x, float y, boolean effect) {
        InputHandler inputHandler = Vars.control.input;
        if (inputHandler instanceof DesktopInput) {
            DesktopInput input = (DesktopInput)inputHandler;
            input.panning = true;
        }
        Core.camera.position.set(x, y);
        if (effect) {
            Fx.arcIndexer.at(x, y);
        }
    }

    public static void shareString(String s) {
        Call.sendChatMessage(s);
    }

    public static void sendChatMsg(String msg) {
        int i = 0;
        while ((float)i < (float)msg.length() / (float)msgSeperator) {
            RFuncs.shareString(msg.substring(i * msgSeperator, Math.min(msg.length(), (i + 1) * msgSeperator)));
            ++i;
        }
    }

    public static void colorizeContent() {
        colorized = Core.settings.getBool("colorizedContent");
        Vars.content.items().each(c -> {
            c.localizedName = RFuncs.colorized(c.color, c.localizedName);
        });
        Vars.content.liquids().each(c -> {
            c.localizedName = RFuncs.colorized(c.color, c.localizedName);
        });
        Vars.content.statusEffects().each(c -> {
            c.localizedName = RFuncs.colorized(c.color, c.localizedName);
        });
        Vars.content.planets().each(c -> {
            c.localizedName = RFuncs.colorized(c.atmosphereColor, c.localizedName);
        });
        Vars.content.blocks().each(c -> {
            if (c.hasColor) {
                c.localizedName = RFuncs.colorized(RFuncs.blockColor(c), c.localizedName);
            } else if (c.itemDrop != null) {
                c.localizedName = RFuncs.colorized(c.itemDrop.color, c.localizedName);
            }
        });
    }

    public static String colorized(Color color, String name) {
        if (colorized) {
            return "[#" + color + "]" + name + "[]";
        }
        return name;
    }

    private static Color blockColor(Block block) {
        Color bc = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        Color bestColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
        int highestS = 0;
        if (!block.synthetic()) {
            PixmapRegion image = Core.atlas.getPixmap(block.fullIcon);
            for (int x = 0; x < image.width; ++x) {
                for (int y = 0; y < image.height; ++y) {
                    bc.set(image.get(x, y));
                    int s = Color.RGBtoHSV(bc)[1] * Color.RGBtoHSV(bc)[1] + Color.RGBtoHSV(bc)[2] + Color.RGBtoHSV(bc)[2];
                    if (s <= highestS) continue;
                    highestS = s;
                    bestColor = bc;
                }
            }
        } else {
            return block.mapColor.cpy().mul(1.2f);
        }
        return bestColor;
    }

    public static String arcShareWaveInfo(int waves) {
        if (!Vars.state.rules.waves) {
            return " ";
        }
        StringBuilder builder = new StringBuilder(RFuncs.getPrefix("orange", "Wave"));
        builder.append("\u6807\u8bb0\u4e86\u7b2c").append(waves).append("\u6ce2");
        if (waves < Vars.state.wave) {
            builder.append("\u3002");
        } else {
            if (waves > Vars.state.wave) {
                builder.append("\uff0c\u8fd8\u6709").append(waves - Vars.state.wave).append("\u6ce2");
            }
            int timer = (int)(Vars.state.wavetime + (float)(waves - Vars.state.wave) * Vars.state.rules.waveSpacing);
            builder.append("[").append(RFuncs.fixedTime(timer)).append("]\u3002");
        }
        builder.append(RFuncs.arcWaveInfo(waves));
        return builder.toString();
    }

    public static String calWaveTimer() {
        StringBuilder waveTimer = new StringBuilder();
        waveTimer.append("[orange]");
        int m = (int)Vars.state.wavetime / 60 / 60;
        int s = (int)Vars.state.wavetime / 60 % 60;
        int ms = (int)Vars.state.wavetime % 60;
        if (m > 0) {
            waveTimer.append(m).append("[white]: [orange]");
            if (s < 10) {
                waveTimer.append("0");
            }
            waveTimer.append(s).append("[white]min");
        } else {
            waveTimer.append(s).append("[white].[orange]").append(ms).append("[white]s");
        }
        return waveTimer.toString();
    }

    public static String arcWaveInfo(int waves) {
        StringBuilder builder = new StringBuilder();
        if (Vars.state.rules.attackMode) {
            int sum = Math.max(Vars.state.teams.present.sum(t -> t.team != Vars.player.team() ? t.cores.size : 0), 1) + Vars.spawner.countSpawns();
            builder.append("\u5305\u542b(\u00d7").append(sum).append(")");
        } else {
            builder.append("\u5305\u542b(\u00d7").append(Vars.spawner.countSpawns()).append("):");
        }
        for (SpawnGroup group : Vars.state.rules.spawns) {
            if (group.getSpawned(waves - 1) <= 0) continue;
            builder.append((char)Fonts.getUnicode(group.type.name)).append("(");
            if (group.effect != StatusEffects.invincible && group.effect != StatusEffects.none && group.effect != null) {
                builder.append((char)Fonts.getUnicode(group.effect.name)).append("|");
            }
            if (group.getShield(waves - 1) > 0.0f) {
                builder.append(NumberFormat.formatInteger((int)group.getShield(waves - 1), 2, "@@")).append("|");
            }
            builder.append(group.getSpawned(waves - 1)).append(")");
        }
        return builder.toString();
    }

    public static String arcColorTime(int timer) {
        return RFuncs.arcColorTime(timer, true);
    }

    public static String arcColorTime(int timer, boolean units) {
        StringBuilder str = new StringBuilder();
        String color = timer > 0 ? "[orange]" : "[acid]";
        timer = Math.abs(timer);
        str.append(color);
        int m = timer / 60 / 60;
        int s = timer / 60 % 60;
        int ms = timer % 60;
        if (m > 0) {
            str.append(m).append("[white]: ").append(color);
            if (s < 10) {
                str.append("0");
            }
            str.append(s);
            if (units) {
                str.append("[white]min");
            }
        } else {
            str.append(s).append("[white].").append(color).append(ms);
            if (units) {
                str.append("[white]s");
            }
        }
        return str.toString();
    }

    public static String fixedTime(int timer, boolean units) {
        StringBuilder str = new StringBuilder();
        int m = timer / 60 / 60;
        int s = timer / 60 % 60;
        int ms = timer % 60;
        if (m > 0) {
            str.append(m).append(": ");
            if (s < 10) {
                str.append("0");
            }
            str.append(s);
            if (units) {
                str.append("min");
            }
        } else {
            str.append(s).append(".").append(ms);
            if (units) {
                str.append('s');
            }
        }
        return str.toString();
    }

    public static String fixedTime(int timer) {
        return RFuncs.fixedTime(timer, true);
    }

    public static StringBuilder getPrefix(Color color, String type) {
        return RFuncs.getPrefix("#" + color, type);
    }

    public static StringBuilder getPrefix(String color, String type) {
        StringBuilder prefix = new StringBuilder();
        if (Vars.ui.chatfrag.mode == ChatFragment.ChatMode.team) {
            prefix.append("/t ");
        }
        prefix.append(ARCVars.arcVersionPrefix);
        prefix.append("[").append(color).append("]");
        prefix.append("<").append(type).append(">");
        prefix.append("[white]");
        return prefix;
    }

    public static String abilitysFormat(String format, Object ... values) {
        for (int i = 0; i < values.length; ++i) {
            String string;
            Object object = values[i];
            if (object instanceof Number) {
                Number n = (Number)object;
                string = "[stat]" + Strings.autoFixed(n.floatValue(), 1) + "[]";
            } else {
                string = "[white]" + values[i] + "[]";
            }
            values[i] = string;
        }
        return Strings.format("[lightgray]" + format.replace("~", "[#" + ARCVars.getThemeColor() + "]~[]"), values);
    }

    public static void worldProcessor() {
        Log.info("\u5f53\u524d\u5730\u56fe:@", Vars.state.map.name());
        int[] data = new int[3];
        Groups.build.each(b -> {
            if (b instanceof LogicBlock.LogicBuild) {
                LogicBlock.LogicBuild lb = (LogicBlock.LogicBuild)b;
                if (lb.block.privileged) {
                    data[0] = data[0] + 1;
                    data[1] = data[1] + (lb.code.split("\n").length + 1);
                    data[2] = data[2] + lb.code.length();
                }
            }
        });
        Log.info("\u5730\u56fe\u5171\u6709@\u4e2a\u4e16\u5904\uff0c\u603b\u5171@\u884c\u6307\u4ee4\uff0c@\u4e2a\u5b57\u7b26", data[0], data[1], data[2]);
        Vars.ui.announce(Strings.format("\u5730\u56fe\u5171\u6709@\u4e2a\u4e16\u5904\uff0c\u603b\u5171@\u884c\u6307\u4ee4\uff0c@\u4e2a\u5b57\u7b26", data[0], data[1], data[2]), 10.0f);
    }

    public static String getLogicCode(byte[] data) {
        String string;
        DataInputStream stream = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data)));
        try {
            stream.read();
            int bytelen = stream.readInt();
            if (bytelen > 102400) {
                throw new IOException("Malformed logic data! Length: " + bytelen);
            }
            byte[] bytes = new byte[bytelen];
            stream.readFully(bytes);
            string = new String(bytes, Vars.charset);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return "";
            }
        }
        stream.close();
        return string;
    }

    public static boolean has(boolean[] arr, boolean val) {
        for (boolean cur : arr) {
            if (cur != val) continue;
            return true;
        }
        return false;
    }

    public static Graphics.Cursor customCursor(String name, int scale) {
        Fi child;
        Fi path = RFuncs.getCursorDir();
        if (path != null && (child = path.child(name + ".png")).exists()) {
            Pixmap base = new Pixmap(child);
            if (scale == 1 || OS.isAndroid || OS.isIos) {
                return Core.graphics.newCursor(base, base.width / 2, base.height / 2);
            }
            Pixmap result = Pixmaps.scale(base, base.width * scale, base.height * scale);
            base.dispose();
            return Core.graphics.newCursor(result, result.width / 2, result.height / 2);
        }
        return Core.graphics.newCursor(name, scale);
    }

    private static Fi getCursorDir() {
        Fi tmp;
        if (cursorChecked) {
            return cachedCursor;
        }
        cursorChecked = true;
        String path = Core.settings.getString("arcCursorPath", null);
        if (path != null && !path.isEmpty() && (tmp = new Fi(path)).isDirectory()) {
            cachedCursor = tmp;
        }
        return cachedCursor;
    }

    public static Drawable tint(int color) {
        return ((TextureRegionDrawable)Tex.whiteui).tint(new Color(color));
    }

    public static Drawable tint(int r, int g, int b, int a) {
        return ((TextureRegionDrawable)Tex.whiteui).tint(new Color(Color.packRgba(r, g, b, a)));
    }

    public static void uploadToWeb(Fi f, Cons<String> result) {
        RFuncs.uploadToWebID(f, l -> result.get("http://124.220.46.174/api/get?id=" + l));
    }

    public static void uploadToWebID(Fi f, Cons<String> result) {
        ARCVars.arcui.arcInfo("\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7b49\u5f85...");
        Http.HttpRequest post = Http.post("http://124.220.46.174/api/upload");
        post.contentStream = f.read();
        post.header("filename", f.name());
        post.header("size", String.valueOf(f.length()));
        post.header("token", "3ab6950d5970c57f938673911f42fd32");
        post.timeout = 10000;
        post.error(e -> Core.app.post(() -> ARCVars.arcui.arcInfo("\u53d1\u751f\u4e86\u4e00\u4e2a\u9519\u8bef:" + e.toString())));
        post.submit(r -> result.get(r.getResultAsString()));
    }

    public static <T> T get(Class<?> t, Object o, String n) throws NoSuchFieldException {
        try {
            Field f = t.getDeclaredField(n);
            f.setAccessible(true);
            return (T)f.get(o);
        }
        catch (Exception e) {
            Class<?> s = t.getSuperclass();
            if (s == null) {
                throw new NoSuchFieldException();
            }
            return RFuncs.get(s, o, n);
        }
    }

    public static interface Stringf<T> {
        public String get(T var1);
    }
}

