/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.math.Mathf;
import arc.util.Strings;
import java.util.regex.Pattern;

public class NumberFormat {
    private static final String defaultFormat = "@[gray]@[]";
    private static final Pattern autoFixedRegex = Pattern.compile("(?<=\\.\\d{0,10})0+(?!\\d|E)|\\.0+(?!\\d|E)");

    public static String formatInteger(long number) {
        return NumberFormat.formatInteger(number, 2, defaultFormat);
    }

    public static String formatFloat(float number) {
        return NumberFormat.formatFloat(number, 2, defaultFormat);
    }

    public static String autoFixed(float number) {
        return NumberFormat.autoFixed(number, 2, defaultFormat);
    }

    public static String formatInteger(long number, int maxDeci) {
        return NumberFormat.formatInteger(number, maxDeci, defaultFormat);
    }

    public static String formatFloat(float number, int maxDeci) {
        return NumberFormat.formatFloat(number, maxDeci, defaultFormat);
    }

    public static String formatFloat(float number, String format) {
        return NumberFormat.formatFloat(number, 2, format);
    }

    public static String autoFixed(float number, int maxDeci) {
        return NumberFormat.autoFixed(number, maxDeci, defaultFormat);
    }

    public static String formatInteger(long number, int maxDeci, String format) {
        String unit;
        double fnumber;
        if (number == Long.MAX_VALUE) {
            return "Inf";
        }
        if (number == Long.MIN_VALUE) {
            return "-Inf";
        }
        String sign = number < 0L ? "-" : "";
        if ((number = Math.abs(number)) >= 1000000000000L) {
            int exponent = (int)Math.log10(number);
            float mantissa = (float)((double)number / Math.pow(10.0, exponent));
            return Strings.format(format, sign + Strings.format("@E@", Strings.autoFixed(mantissa, 1), exponent), "");
        }
        if (number >= 1000000000L) {
            fnumber = (double)number / 1.0E9;
            unit = "B";
        } else if (number >= 1000000L) {
            fnumber = (double)number / 1000000.0;
            unit = "M";
        } else if (number >= 1000L) {
            fnumber = (double)number / 1000.0;
            unit = "K";
        } else {
            return Strings.format(format, sign + number, "");
        }
        return Strings.format(format, sign + Strings.fixed((float)fnumber, maxDeci - (int)Math.log10(fnumber)), unit);
    }

    public static String formatFloat(float number, int maxDeci, String format) {
        if (Float.isNaN(number)) {
            return Strings.format(format, "NaN", "");
        }
        if (number == Float.POSITIVE_INFINITY) {
            return Strings.format(format, "Inf", "");
        }
        if (number == Float.NEGATIVE_INFINITY) {
            return Strings.format(format, "-Inf", "");
        }
        String sign = number < 0.0f ? "-" : "";
        String unit = "";
        if ((number = Math.abs(number)) < 1.0E-5f) {
            return Strings.format(format, sign + number, "");
        }
        if ((double)number >= Math.pow(10.0, maxDeci + 1)) {
            float tolernce = (float)Math.pow(10.0, maxDeci + 2);
            if (number >= 1.0E12f || Mathf.equal(1.0E12f, number, number / tolernce)) {
                int exponent = Mathf.floor((float)Math.log10(number));
                float mantissa = (float)((double)number / Math.pow(10.0, exponent));
                return Strings.format(format, sign + Strings.format("@E@", Strings.fixed(mantissa, 1), exponent), "");
            }
            if (number >= 1.0E9f || Mathf.equal(1.0E9f, number, number / tolernce)) {
                number /= 1.0E9f;
                unit = "B";
            } else if (number >= 1000000.0f || Mathf.equal(1000000.0f, number, number / tolernce)) {
                number /= 1000000.0f;
                unit = "M";
            } else if (number >= 1000.0f || Mathf.equal(1000.0f, number, number / tolernce)) {
                number /= 1000.0f;
                unit = "K";
            }
        }
        return Strings.format(format, sign + Strings.fixed(number, maxDeci - (int)Math.log10(number)), unit);
    }

    public static String autoFixed(float number, int maxDeci, String format) {
        return autoFixedRegex.matcher(NumberFormat.formatFloat(number, maxDeci, format)).replaceAll("");
    }

    public static String formatPercent(String prefix, float cur, float max) {
        return NumberFormat.formatPercent(prefix, cur, Math.abs(cur) > 0.001f, max, cur / max < 0.9f, 2);
    }

    public static String formatPercent(String prefix, float cur, float max, int arcFixed) {
        return NumberFormat.formatPercent(prefix, cur, cur > 1.0E-4f, max, cur / max < 0.9f, arcFixed);
    }

    public static String formatPercent(String prefix, float cur, boolean showMin, float max, boolean showPercent, int arcFixed) {
        return NumberFormat.formatPercent(prefix, cur, showMin, max, showMin & showPercent ? NumberFormat.buildPercent(cur, max) : "", arcFixed);
    }

    public static String formatPercent(String prefix, float cur, float max, String format) {
        return NumberFormat.formatPercent(prefix, cur, cur > 1.0E-4f, max, format, 2);
    }

    public static String formatPercent(String prefix, float cur, boolean showMin, float max, String format, int arcFixed) {
        return NumberFormat.formatPercent(prefix, cur, showMin, max, Math.abs(cur / max - 1.0f) > 0.01f, format, arcFixed);
    }

    public static String formatPercent(String prefix, float cur, boolean showMin, float max, boolean showMax, String format, int arcFixed) {
        StringBuilder text = new StringBuilder(prefix).append(" ");
        text.append(showMin ? NumberFormat.autoFixed(cur, arcFixed) : "\ue815");
        if (showMax) {
            text.append("/").append(NumberFormat.autoFixed(max, arcFixed));
        }
        text.append(format);
        return text.toString();
    }

    private static String buildPercent(float cur, float max) {
        return NumberFormat.buildPercent(100.0f * cur / max);
    }

    public static String buildPercent(float percent) {
        return " [lightgray]| " + (int)percent + "%";
    }
}

