/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.DrawUtilities;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.dialogs.MessageDialog;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.graphics.Drawf;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;

public class Marker {
    public static final float heatTime = 60.0f;
    public static final float retainTime = 1800.0f;
    public static MarkType mark = new MarkType("Mark", Fx.arcMarker, Color.valueOf("eab678"));
    public static MarkType gatherMark;
    public static MarkType attackMark;
    public static MarkType defenseMark;
    public static MarkType quesMark;
    public static Seq<MarkType> markTypes;
    public static boolean isLocal;
    public static final Seq<MarkElement> markList;

    public static void mark(MarkType type, float x, float y) {
        Marker.mark(type, Tmp.v1.set(x, y), true);
    }

    public static void mark(MarkType type, float x, float y, boolean sendMessage) {
        Marker.mark(type, Tmp.v1.set(x, y), sendMessage);
    }

    public static void mark(MarkType type, Vec2 pos) {
        Marker.mark(type, pos, true);
    }

    public static void mark(MarkType type, Vec2 pos, boolean sendMessage) {
        if (Marker.markList.size > 0 && Time.time - Marker.markList.peek().time < 60.0f) {
            Vars.ui.announce("\u8bf7\u4e0d\u8981\u9891\u7e41\u6807\u8bb0!");
            return;
        }
        markList.add(new MarkElement(type, pos));
        type.showEffect(pos);
        if (sendMessage) {
            isLocal = true;
            type.sendMessage(pos);
        }
    }

    public static boolean resolveMessage(String text) {
        if (isLocal) {
            isLocal = false;
            return true;
        }
        MarkType markType = null;
        int Indexer = -1;
        for (MarkType markType1 : markTypes) {
            if (!text.contains("<" + markType1.name + ">") && !text.contains("<" + markType1.localizedName + ">")) continue;
            markType = markType1;
            Indexer = text.indexOf("<" + markType1.name + ">");
        }
        if (Indexer > 0) {
            String posStr = text.substring(text.indexOf(40, Indexer + 1), text.indexOf(41, Indexer + 1) + 1);
            Vec2 pos = Tmp.v1;
            try {
                pos.fromString(posStr);
            }
            catch (Throwable e) {
                Log.err("Cannot resolve position from " + posStr, new Object[0]);
                return false;
            }
            Marker.mark(markType, pos.scl(8.0f), false);
            MessageDialog.addMsg(new MessageDialog.advanceMsg(MessageDialog.arcMsgType.markLoc, text, pos));
            return true;
        }
        if (text.contains("[YELLOW][\u96c6\u5408]") && text.contains("[WHITE]\"[WHITE]\",\u8f93\u5165\"[gold]go[WHITE]\"\u524d\u5f80")) {
            int typeStart = text.indexOf("[WHITE]\u53d1\u8d77\u96c6\u5408([RED]");
            int typeEnd = text.indexOf("[WHITE])");
            if (typeStart == -1 || typeEnd == -1) {
                return false;
            }
            String posStr = text.substring(typeStart + 17, typeEnd);
            Vec2 pos = Tmp.v1;
            try {
                pos.fromString("(" + posStr + ")");
            }
            catch (Throwable e) {
                Log.err("Cannot resolve position from " + posStr, new Object[0]);
                return false;
            }
            Marker.mark(Marker.findLocalizedName("\u96c6\u5408"), pos.scl(8.0f), false);
            MessageDialog.addMsg(new MessageDialog.advanceMsg(MessageDialog.arcMsgType.markLoc, text, pos));
            return true;
        }
        return false;
    }

    public static MarkType findType(String name) {
        return markTypes.find(maskType -> ((MarkType)maskType).name.equals(name));
    }

    public static MarkType findLocalizedName(String localizedName) {
        return markTypes.find(maskType -> maskType.localizedName.equals(localizedName));
    }

    public static void lockonLastMark() {
        if (Marker.markList.size == 0) {
            return;
        }
        InputHandler inputHandler = Vars.control.input;
        if (inputHandler instanceof DesktopInput) {
            DesktopInput input = (DesktopInput)inputHandler;
            input.panning = true;
        }
        Core.camera.position.set(Marker.markList.peek().markPos);
        markList.peek().showEffect();
    }

    public static void drawMarker() {
        if (Marker.markList.size == 0) {
            return;
        }
        markList.each(t -> Time.time - t.time < ((MarkType)t.markType).effect.lifetime, t -> t.markType.showArrow(t.markPos));
    }

    static {
        markTypes = Seq.with(mark, gatherMark = new MarkType("Gather", Fx.arcGatherMarker, Color.cyan), attackMark = new MarkType("Attack", Fx.arcAttackMarker, Color.red), defenseMark = new MarkType("Defend", Fx.arcDefenseMarker, Color.acid), quesMark = new MarkType("What", Fx.arcQuesMarker, Color.pink));
        markList = new Seq();
        Events.run(EventType.WorldLoadEvent.class, markList::clear);
    }

    public static class MarkType {
        private final String name;
        public String localizedName;
        public String describe;
        private final Effect effect;
        public final Color color;

        public MarkType(String name, Effect effect) {
            this(name, effect, Color.white);
        }

        public MarkType(String name, Effect effect, Color color) {
            this.name = name;
            this.effect = effect;
            this.color = color;
            this.localizedName = Core.bundle.get("marker." + name + ".name", "unknown");
            this.describe = Core.bundle.get("marker." + name + ".name", "unknown");
        }

        public String shortName() {
            return "[#" + this.color + "]" + this.localizedName;
        }

        public String tinyName() {
            return "[#" + this.color + "]" + this.localizedName.substring(0, 1);
        }

        public void showEffect(Vec2 pos) {
            this.effect.arcCreate(pos.x, pos.y, 0.0f, this.color, null);
        }

        public void sendMessage(Vec2 pos) {
            String text = RFuncs.getPrefix(this.color, this.name) + "(" + World.toTile(pos.x) + "," + World.toTile(pos.y) + ")";
            RFuncs.shareString(text);
            MessageDialog.addMsg(new MessageDialog.advanceMsg(MessageDialog.arcMsgType.markLoc, text, pos));
        }

        public void showArrow(Vec2 pos) {
            Draw.reset();
            Drawf.arrow(Vars.player.x, Vars.player.y, pos.x, pos.y, 40.0f, 4.0f, this.color);
            float dst = Mathf.dst(Vars.player.x, Vars.player.y, pos.x, pos.y) / 8.0f;
            Tmp.v1.set(pos.x, pos.y).sub(Vars.player.x, Vars.player.y).limit(36.0f);
            DrawUtilities.arcDrawText((int)dst + "", 0.2f, Tmp.v1.x + Vars.player.x, Tmp.v1.y + Vars.player.y, this.color, 1);
        }
    }

    public static class MarkElement {
        public MarkType markType;
        public float time;
        public String player;
        public Vec2 markPos;

        public MarkElement(MarkType markType, Vec2 markPos) {
            this(markType, "", markPos);
        }

        public MarkElement(MarkType markType, String player, Vec2 markPos) {
            this(markType, Time.time, player, markPos);
        }

        public MarkElement(MarkType markType, float time, String player, Vec2 markPos) {
            this.markType = markType;
            this.time = time;
            this.player = player;
            this.markPos = new Vec2().set(markPos);
        }

        public void showEffect() {
            this.markType.showEffect(this.markPos);
        }
    }
}

