/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.ChangeListener;
import arc.scene.event.ClickListener;
import arc.scene.event.Touchable;
import arc.scene.ui.Button;
import arc.scene.ui.Label;
import arc.scene.ui.Slider;
import arc.scene.ui.TextButton;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.arcModule.SimpleKeystrokes;
import mindustry.gen.Tex;
import mindustry.input.DesktopInput;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;

public class ElementUtils {
    public static TextButton.TextButtonStyle textStyle = new TextButton.TextButtonStyle(){
        {
            this.down = Styles.flatOver;
            this.up = Tex.pane;
            this.over = Tex.flatDownBase;
            this.font = Fonts.def;
            this.fontColor = Color.white;
            this.disabledFontColor = Color.gray;
            this.checked = Styles.flatDown;
        }
    };
    public static TextButton.TextButtonStyle NCtextStyle = new TextButton.TextButtonStyle(){
        {
            this.down = Styles.flatOver;
            this.up = Tex.pane;
            this.over = Tex.flatDownBase;
            this.font = Fonts.def;
            this.fontColor = Color.white;
            this.disabledFontColor = Color.gray;
        }
    };

    public static <T extends Element> T tooltip(T element, String text) {
        return ElementUtils.tooltip(element, text, true);
    }

    public static <T extends Element> T tooltip(T element, String text, boolean allowMobile) {
        Tooltip tooltip = Tooltip.Tooltips.getInstance().create(text);
        tooltip.allowMobile = allowMobile;
        element.addListener(tooltip);
        ElementUtils.addKey(element);
        return element;
    }

    public static <T extends Element> T tooltip(T element, Cons<Table> builder) {
        return ElementUtils.tooltip(element, builder, true);
    }

    public static <T extends Element> T tooltip(T element, Cons<Table> builder, boolean allowMobile) {
        Tooltip tooltip = new Tooltip(builder);
        tooltip.allowMobile = allowMobile;
        element.addListener(tooltip);
        return element;
    }

    public static <T extends Element> void addKey(T element) {
        if (Vars.control.input instanceof DesktopInput && element instanceof Button) {
            Button button = (Button)element;
            button.getListeners().each(tooltip -> {
                if (tooltip instanceof Tooltip) {
                    Tooltip tooltip1 = (Tooltip)tooltip;
                    tooltip1.container.getCells().each(cell -> {
                        Object patt2458$temp = cell.get();
                        if (patt2458$temp instanceof Label) {
                            Label label = (Label)patt2458$temp;
                            String string = label.getText().toString();
                            button.getListeners().each(eventListener -> {
                                Runnable run = null;
                                if (eventListener instanceof ChangeListener) {
                                    ChangeListener changeListener = (ChangeListener)eventListener;
                                    run = () -> changeListener.changed(null, null);
                                }
                                if (eventListener instanceof ClickListener) {
                                    ClickListener clickListener = (ClickListener)eventListener;
                                    run = () -> clickListener.clicked(null, 0.0f, 0.0f);
                                }
                                if (run != null) {
                                    String s = Core.settings.getString(string, "[]");
                                    Seq<KeyCode> keyCodes = SimpleKeystrokes.string2KeyCode(s);
                                    SimpleKeystrokes.INSTANCE.initKey(string, keyCodes, run);
                                }
                            });
                            ClickListener clicked = element.clicked(KeyCode.mouseRight, () -> SimpleKeystrokes.SetKeyGui.INSTANCE.openDialog(string));
                            button.addListener(clicked);
                        }
                    });
                }
            });
        }
    }

    public static Table arcSliderTable(Table table, String name, float def, float min, float max, float step, StringProFloat s, Cons<Float> cons) {
        Slider slider = new Slider(min, max, step, false);
        slider.setValue(def);
        Label value = new Label("", Styles.outlineLabel);
        Table content = new Table();
        content.add((CharSequence)name, Styles.outlineLabel).left().growX().wrap();
        content.add(value).padLeft(10.0f).right();
        content.margin(3.0f, 33.0f, 3.0f, 33.0f);
        content.touchable = Touchable.disabled;
        slider.changed(() -> {
            cons.get(Float.valueOf(slider.getValue()));
            value.setText(s.get(slider.getValue()));
        });
        slider.change();
        table.stack(slider, content).width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).left().padTop(4.0f).get();
        table.row();
        return table;
    }

    public static Table arcSliderTableInt(Table table, String name, int def, int min, int max, int step, StringProInt s, Cons<Integer> cons) {
        Slider slider = new Slider(min, max, step, false);
        slider.setValue(def);
        Label value = new Label("", Styles.outlineLabel);
        Table content = new Table();
        content.add((CharSequence)name, Styles.outlineLabel).left().growX().wrap();
        content.add(value).padLeft(10.0f).right();
        content.margin(3.0f, 33.0f, 3.0f, 33.0f);
        content.touchable = Touchable.disabled;
        slider.changed(() -> {
            cons.get((int)slider.getValue());
            value.setText(s.get((int)slider.getValue()));
        });
        slider.change();
        table.stack(slider, content).width(Math.min((float)Core.graphics.getWidth() / 1.2f, 460.0f)).left().padTop(4.0f).get();
        table.row();
        return table;
    }

    public static interface StringProFloat {
        public String get(float var1);
    }

    public static interface StringProInt {
        public String get(int var1);
    }

    public static abstract class ToolTable
    extends Table {
        public String icon = "";
        public boolean expand = false;

        public void rebuild() {
            this.clear();
            this.table().growX().left();
            if (this.expand) {
                this.buildTable();
            }
            this.button((this.expand ? "" : "[lightgray]") + this.icon, textStyle, () -> {
                this.expand = !this.expand;
                this.rebuild();
            }).right().width(40.0f).minHeight(40.0f).fillY();
        }

        protected abstract void buildTable();
    }
}

