/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.util.Time;
import arc.util.pooling.Pools;
import mindustry.arcModule.ARCVars;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.blocks.defense.MendProjector;
import mindustry.world.blocks.defense.OverdriveProjector;
import mindustry.world.blocks.defense.Radar;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.storage.CoreBlock;

public class DrawUtilities {
    private static Vec2 vector = new Vec2();
    private static int arcCircleIndex = 0;
    static float iconSize = 0.0f;
    private static final Effect effect120 = DrawUtilities.createBuildEffect(120.0f);
    private static final Effect effect180 = DrawUtilities.createBuildEffect(180.0f);

    public static float arcDrawText(String text, float scl, float dx, float dy, Color color, int halign) {
        Font font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(scl);
        layout.setText(font, text);
        float height = layout.height;
        font.setColor(color);
        font.draw(text, dx, dy + layout.height + 1.0f, halign);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
        return height;
    }

    public static float arcDrawText(String text, float scl, float dx, float dy, int halign) {
        Font font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(scl);
        layout.setText(font, text);
        float height = layout.height;
        font.draw(text, dx + layout.width / 2.0f, dy + layout.height / 2.0f, halign);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
        return height;
    }

    private void arcFillTextMain(String text, float x1, float y1, float x2, float y2, float ratio) {
        Color color = ARCVars.getThemeColor();
        Font font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(Math.abs(x2 - x1) / (float)text.length() / 2.0f / Scl.scl(1.0f) * ratio);
        layout.setText(font, text);
        font.setColor(color);
        float cx = (x1 + x2) / 2.0f * 8.0f;
        float cy = (y1 + y2) / 2.0f * 8.0f;
        font.draw(text, cx, cy, 1);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
    }

    public static void arcFillTextHead(String text, float x1, float x2, float y, float ratio) {
        Font font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(Math.abs(x2 - x1) / Math.max((float)text.length(), 1.0f) / 2.0f / Scl.scl(1.0f) * ratio);
        layout.setText(font, text);
        float cx = (x1 + x2) / 2.0f * 8.0f;
        float cy = y * 8.0f - 5.0f;
        font.draw(text, cx, cy, 1);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
    }

    public static void arcDrawTextMain(String text, int x, int y) {
        Color color = ARCVars.getThemeColor();
        Font font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.33333334f / Scl.scl(1.0f));
        layout.setText(font, text);
        font.setColor(color);
        float dx = x * 8;
        float dy = y * 8;
        font.draw(text, dx, dy + layout.height + 1.0f, 1);
        Lines.stroke(2.0f, Color.darkGray);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy -= 1.0f, dx + layout.width / 2.0f + 1.5f, dy);
        Lines.stroke(1.0f, color);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy, dx + layout.width / 2.0f + 1.5f, dy);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
    }

    public static void arcBuildEffect(Building build) {
        DrawUtilities.arcBuildEffect(build, build.x, build.y);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void arcBuildEffect(Building build, float x, float y) {
        if (build == null) return;
        if (!Core.settings.getBool("arcPlacementEffect")) {
            return;
        }
        Block block = build.block;
        if (block instanceof BaseTurret) {
            BaseTurret baseTurret = (BaseTurret)block;
            if (build.health > (float)Core.settings.getInt("blockbarminhealth")) {
                effect120.at(x, y, 0.0f, new ARCEffectData(baseTurret.range, build.team.color));
                return;
            }
        }
        if ((block = build.block) instanceof MendProjector) {
            MendProjector mendProjector = (MendProjector)block;
            effect120.at(x, y, 0.0f, new ARCEffectData(mendProjector.range, Pal.heal));
            return;
        }
        block = build.block;
        if (block instanceof OverdriveProjector) {
            OverdriveProjector overdriveProjector = (OverdriveProjector)block;
            effect120.at(x, y, 0.0f, new ARCEffectData(overdriveProjector.range, overdriveProjector.baseColor));
            return;
        }
        block = build.block;
        if (block instanceof Radar) {
            Radar radar = (Radar)block;
            effect120.at(x, y, 0.0f, new ARCEffectData(radar.fogRadius * 8, build.team.color));
            return;
        }
        block = build.block;
        if (block instanceof LogicBlock) {
            LogicBlock logic = (LogicBlock)block;
            effect120.at(x, y, 0.0f, new ARCEffectData(logic.range, logic.mapColor));
            return;
        }
        block = build.block;
        if (!(block instanceof CoreBlock)) return;
        CoreBlock block2 = (CoreBlock)block;
        effect180.at(x, y, 0.0f, new ARCEffectData(block2.fogRadius * 8, build.team.color));
    }

    public static Effect createBuildEffect(float lifeTime) {
        return new Effect(lifeTime, e -> {
            ARCEffectData d = (ARCEffectData)e.data();
            Draw.color(d.color);
            Lines.stroke((1.5f - e.fin()) * (d.range / 100.0f));
            if (e.fin() < 0.7f) {
                Lines.circle(e.x, e.y, (float)((1.0 - Math.pow((0.7f - e.fin()) / 0.7f, 2.0)) * (double)d.range));
            } else {
                Draw.alpha((1.0f - e.fin()) * 5.0f);
                Lines.circle(e.x, e.y, d.range);
            }
        });
    }

    public static void arcDashCircling(float x, float y, float radius) {
        DrawUtilities.arcDashCircling(x, y, radius, 0.5f);
    }

    public static void arcDashCircling(float x, float y, float radius, float speed) {
        DrawUtilities.arcDashCircle(x, y, radius, Time.time * speed);
    }

    public static void arcDashCircle(float x, float y, float radius) {
        DrawUtilities.arcDashCircle(x, y, radius, 0.0f);
    }

    public static void arcDashCircle(float x, float y, float radius, float rotation) {
        float scaleFactor = 0.6f;
        int sides = 10 + (int)(radius * scaleFactor);
        if (sides % 2 == 1) {
            ++sides;
        }
        vector.set(0.0f, 0.0f);
        for (int i = 0; i < sides; i += 2) {
            vector.set(radius, 0.0f).rotate(360.0f / (float)sides * (float)i + 90.0f + rotation);
            float x1 = DrawUtilities.vector.x;
            float y1 = DrawUtilities.vector.y;
            vector.set(radius, 0.0f).rotate(360.0f / (float)sides * (float)(i + 1) + 90.0f + rotation);
            Lines.line(x1 + x, y1 + y, DrawUtilities.vector.x + x, DrawUtilities.vector.y + y);
        }
    }

    public static void drawNSideRegion(float x, float y, int n, float range, float rotation, Color color, float fraction, TextureRegion region, boolean regionColor) {
        Draw.z(108.0f);
        Draw.color(color);
        Lines.stroke(2.0f);
        for (int i = 0; i < n; ++i) {
            float frac = 360.0f * (1.0f - fraction * (float)n) / (float)n / 2.0f;
            float rot = rotation + (float)i * 360.0f / (float)n + frac;
            if (!regionColor) {
                Draw.color(color);
                Lines.arc(x, y, range, 0.25f, rot, (int)(50.0f + range / 10.0f));
                Draw.color();
            } else {
                Lines.arc(x, y, range, 0.25f, rot, (int)(50.0f + range / 10.0f));
            }
            Draw.rect(region, x + range * Mathf.cos((float)Math.toRadians(rot - frac)), y + range * Mathf.sin((float)Math.toRadians(rot - frac)), 12.0f, 12.0f);
        }
        Draw.reset();
    }

    public static class ARCEffectData {
        public final float range;
        public final Color color;

        public ARCEffectData(float range, Color color) {
            this.range = range;
            this.color = color;
        }
    }
}

