/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule;

import arc.Core;
import arc.Events;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.geom.Vec2;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Slider;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.DrawUtilities;
import mindustry.arcModule.Marker;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.dialogs.MessageDialog;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class District {
    public static final String ShareType = "[violet]<District>";
    public static final float heatTime = 60.0f;
    public static final float retainTime = 1800.0f;
    public static final Seq<advDistrict> districtList = new Seq();
    public static advDistrict voidDistrict = new advDistrict();

    public static void unitSpawnMenu() {
        BaseDialog disSet = new BaseDialog("ARC-\u533a\u57df\u89c4\u5212\u4e2d\u5fc3");
        disSet.cont.table(t -> {
            t.table(tt -> tt.add("\u533a\u57df\u89c4\u5212\u5668-\u7528\u4e8e\u5355\u673a|\u670d\u52a1\u5668\u5728\u5730\u56fe\u4e0a\u8bbe\u7f6e\u3001\u7ba1\u7406\u548c\u4ea4\u6d41\u67d0\u4e2a\u533a\u57df\u7684\u7528\u9014"));
            t.row();
            t.add("\u5750\u6807\u8bbe\u7f6e").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
            t.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            t.labelWrap("\u81ea\u52a8\u586b\u5165\u4e0a\u4e2a\u5212\u5b9a\u7684\u9009\u62e9\u533a\uff08\u5373\u590d\u5236\u84dd\u56fe\u7684\u533a\u57df\uff09").growX().center().row();
            t.table(tt -> {
                tt.add("A\u70b9\uff1a ");
                tt.table(tx -> {
                    tx.add("x= ");
                    TextField Ax = tx.field(District.voidDistrict.districtA.x + "", text -> {
                        District.voidDistrict.districtA.x = Math.min(Math.max(Float.parseFloat(text), 0.0f), (float)Vars.state.map.width);
                    }).valid(Strings::canParseFloat).maxTextLength(8).get();
                    tx.add("  ,y= ");
                    TextField Ay = tx.field(District.voidDistrict.districtA.y + "", text -> {
                        District.voidDistrict.districtA.y = Math.min(Math.max(Float.parseFloat(text), 0.0f), (float)Vars.state.map.height);
                    }).valid(Strings::canParseFloat).maxTextLength(8).get();
                    tx.button(StatusEffects.blasted.emoji(), () -> {
                        if (Marker.markList.size == 0) {
                            return;
                        }
                        District.voidDistrict.districtA.set(World.toTile(Marker.markList.peek().markPos.x), World.toTile(Marker.markList.peek().markPos.y));
                        Ax.setText(District.voidDistrict.districtA.x + "");
                        Ay.setText(District.voidDistrict.districtA.y + "");
                    }).tooltip(Marker.markList.size == 0 ? "[red]\u672a\u6807\u8bb0" : "\u9009\u62e9\u4e0a\u4e2a\u6807\u8bb0\u70b9\uff1a" + World.toTile(Marker.markList.peek().markPos.x) + "," + World.toTile(Marker.markList.peek().markPos.y)).height(50.0f);
                });
                tt.row();
                tt.add("B\u70b9\uff1a ");
                tt.table(tx -> {
                    tx.add("x= ");
                    TextField Bx = tx.field(District.voidDistrict.districtB.x + "", text -> {
                        District.voidDistrict.districtB.x = Float.parseFloat(text);
                    }).valid(Strings::canParseFloat).maxTextLength(8).get();
                    tx.add("  ,y= ");
                    TextField By = tx.field(District.voidDistrict.districtB.y + "", text -> {
                        District.voidDistrict.districtB.y = Float.parseFloat(text);
                    }).valid(Strings::canParseFloat).maxTextLength(8).get();
                    tx.button(StatusEffects.blasted.emoji(), () -> {
                        if (Marker.markList.size == 0) {
                            return;
                        }
                        District.voidDistrict.districtB.set(World.toTile(Marker.markList.peek().markPos.x), World.toTile(Marker.markList.peek().markPos.y));
                        Bx.setText(District.voidDistrict.districtB.x + "");
                        By.setText(District.voidDistrict.districtB.y + "");
                    }).tooltip(Marker.markList.size == 0 ? "[red]\u672a\u6807\u8bb0" : "\u9009\u62e9\u4e0a\u4e2a\u6807\u8bb0\u70b9\uff1a" + World.toTile(Marker.markList.peek().markPos.x) + "," + World.toTile(Marker.markList.peek().markPos.y)).height(50.0f);
                });
            });
            t.row();
            t.add("\u6301\u7eed\u65f6\u95f4").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
            t.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            t.table(tt -> {
                TextField sField = tt.field("30", text -> {
                    District.voidDistrict.duration = Float.valueOf(Float.parseFloat(text));
                }).valid(Strings::canParseFloat).tooltip("\u89c4\u5212\u533a\u6301\u7eed\u65f6\u95f4(\u5355\u4f4d\uff1a\u79d2)").maxTextLength(10).get();
                tt.add("\u79d2");
                Slider sSlider = tt.slider(30.0f, 300.0f, 30.0f, District.voidDistrict.duration.floatValue(), n -> {
                    if (District.voidDistrict.duration.floatValue() != n) {
                        sField.setText(District.voidDistrict.duration + "");
                    }
                    District.voidDistrict.duration = Float.valueOf(n);
                }).get();
                sField.update(() -> sSlider.setValue(District.voidDistrict.duration.floatValue()));
            });
            t.row();
            t.add("\u89c4\u5212\u9879\u76ee").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
            t.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            t.table(tt -> {
                tt.add("\u6807\u7b7e\uff1a");
                tt.field(District.voidDistrict.districtType.districtName, text -> {
                    District.voidDistrict.districtType.districtName = text;
                }).tooltip("\u89c4\u5212\u533a\u7684\u6807\u7b7e\u6761").maxTextLength(10).width(300.0f);
            });
            t.row();
            t.add("\u89c4\u5212\u533a\u8bbe\u7f6e").color(ARCVars.getThemeColor()).colspan(4).pad(10.0f).padTop(15.0f).padBottom(4.0f).row();
            t.image().color(ARCVars.getThemeColor()).fillX().height(3.0f).colspan(4).padTop(0.0f).padBottom(10.0f).row();
            t.button("\u53d1\u5e03\u89c4\u5212\u533a!", () -> {
                if (!Core.settings.getBool("cheating_mode") && (District.voidDistrict.districtA.x - District.voidDistrict.districtB.x > 100.0f || District.voidDistrict.districtA.y - District.voidDistrict.districtB.y > 100.0f)) {
                    ARCVars.arcui.arcInfo("\u8bf7\u52ff\u53d1\u5e03\u65e0\u610f\u4e49\u5de8\u5927\u89c4\u5212\u533a");
                } else {
                    RFuncs.shareString(voidDistrict.toString());
                }
            }).fillX();
        });
        disSet.addCloseButton();
        disSet.shown(District::setVoidDistrict);
        disSet.show();
    }

    public static void setVoidDistrict() {
        District.voidDistrict.districtA.x = Vars.control.input.lastSelection.x;
        District.voidDistrict.districtA.y = Vars.control.input.lastSelection.y;
        District.voidDistrict.districtB.x = Vars.control.input.lastSelection.x + Vars.control.input.lastSelection.width;
        District.voidDistrict.districtB.y = Vars.control.input.lastSelection.y + Vars.control.input.lastSelection.height;
    }

    public static boolean resolveMessage(String text) {
        advDistrict resolveDistrict = new advDistrict();
        if (!text.contains(ShareType)) {
            return false;
        }
        int Indexer = text.indexOf(ShareType) + ShareType.length();
        resolveDistrict.message = text;
        int districtTypeHand = text.indexOf(123, Indexer + 1);
        int districtTypeTail = text.indexOf(125, Indexer + 2);
        if (districtTypeHand == -1 || districtTypeTail + 1 < districtTypeHand) {
            return false;
        }
        resolveDistrict.districtType.districtName = text.substring(districtTypeHand + 1, districtTypeTail);
        Indexer = districtTypeTail;
        int locAHand = text.indexOf(40, Indexer + 1);
        int locATail = text.indexOf(41, Indexer + 2);
        Vec2 pos = Tmp.v1;
        try {
            pos.fromString(text.substring(locAHand, locATail + 1));
        }
        catch (Throwable e) {
            Log.err("Cannot resolve position", new Object[0]);
            return false;
        }
        resolveDistrict.districtA = new Vec2(pos);
        Indexer = locATail;
        int locBHand = text.indexOf(40, Indexer + 1);
        int locBTail = text.indexOf(41, Indexer + 2);
        try {
            pos.fromString(text.substring(locBHand, locBTail + 1));
        }
        catch (Throwable e) {
            Log.err("Cannot resolve position", new Object[0]);
            return false;
        }
        resolveDistrict.districtB = new Vec2(pos);
        districtList.add(new advDistrict(resolveDistrict));
        ARCVars.districtList = districtList;
        MessageDialog.addMsg(new MessageDialog.advanceMsg(MessageDialog.arcMsgType.district, text, resolveDistrict.center()));
        return true;
    }

    public static void drawDistrict() {
        if (District.districtList.size <= 0) {
            return;
        }
        for (advDistrict advDistrict2 : districtList) {
            if (Time.time - advDistrict2.time.floatValue() > advDistrict2.duration.floatValue() * 60.0f) continue;
            advDistrict2.draw();
        }
    }

    static void showNewIconTag(final advDistrict district) {
        new Dialog("arc-\u533a\u57df\u89c4\u5212\u4e2d\u5fc3"){
            {
                super(arg0);
                this.closeOnBack();
                this.setFillParent(true);
                this.cont.pane((Table t) -> this.resized(true, () -> {
                    t.clearChildren();
                    t.marginRight(19.0f);
                    t.defaults().size(48.0f);
                    int cols = (int)Math.min(20.0f, (float)Core.graphics.getWidth() / Scl.scl(52.0f));
                    for (ContentType ctype : Vars.defaultContentIcons) {
                        t.row();
                        t.image().colspan(cols).growX().width(Float.NEGATIVE_INFINITY).height(3.0f).color(Pal.accent);
                        t.row();
                        int i = 0;
                        for (UnlockableContent u : Vars.content.getBy(ctype).as()) {
                            if (u.isHidden() || !u.unlockedNow() || !u.hasEmoji()) continue;
                            t.button(new TextureRegionDrawable(u.uiIcon), Styles.flati, 32.0f, () -> {
                                district2.districtType.districtType = u;
                                this.hide();
                            });
                            if (++i % cols != 0) continue;
                            t.row();
                        }
                    }
                }));
                this.buttons.button("@back", Icon.left, this::hide).size(210.0f, 64.0f);
            }
        }.show();
    }

    public static void districtSettingDialog() {
        BaseDialog disSet = new BaseDialog("\u89c4\u5212\u533a\u8bbe\u7f6e");
        Runnable[] rebuild = new Runnable[]{null};
        Table t = disSet.cont;
        rebuild[0] = () -> {
            t.clear();
            if (District.districtList.size <= 0) {
                return;
            }
            t.add("\u533a\u57df\u540d\u79f0");
            t.add("\u5750\u6807");
            t.row();
            for (advDistrict advDistrict2 : districtList) {
                t.add(advDistrict2.districtType.getName());
                t.add(advDistrict2.getLoc());
                t.button("[red]\u00d7", () -> {
                    districtList.remove(advDistrict2);
                    rebuild[0].run();
                });
                t.row();
            }
        };
        rebuild[0].run();
        ((Dialog)disSet).addCloseButton();
        disSet.show();
    }

    static {
        Events.run(EventType.WorldLoadEvent.class, () -> districtList.clear());
    }

    public static class advDistrict {
        public districtType districtType = new districtType("");
        public String message;
        public Float time;
        public Float duration = Float.valueOf(300.0f);
        public String creator;
        public Vec2 districtA = new Vec2();
        public Vec2 districtB = new Vec2();

        public advDistrict(districtType districtType2, String message, Float time, String creator, Vec2 districtA, Vec2 districtB) {
            this.districtType = districtType2;
            this.message = message;
            this.time = time;
            this.creator = creator;
            this.districtA = new Vec2().set(districtA);
            this.districtB = new Vec2().set(districtB);
        }

        public advDistrict(districtType districtType2, String message, String creator, Vec2 districtA, Vec2 districtB) {
            this(districtType2, message, Float.valueOf(Time.time), creator, districtA, districtB);
        }

        public advDistrict(districtType districtType2, String message, Vec2 districtA, Vec2 districtB) {
            this(districtType2, message, null, districtA, districtB);
        }

        public advDistrict(advDistrict voidDistrict) {
            this.districtType = voidDistrict.districtType;
            this.message = voidDistrict.message;
            this.duration = voidDistrict.duration;
            this.time = Float.valueOf(Time.time);
            this.creator = voidDistrict.creator;
            this.districtA = new Vec2().set(voidDistrict.districtA);
            this.districtB = new Vec2().set(voidDistrict.districtB);
        }

        public advDistrict() {
        }

        public String toString() {
            return RFuncs.getPrefix("violet", "District") + "{" + this.districtType.getName() + "}[white]\uff1a(" + (int)this.districtA.x + "," + (int)this.districtA.y + ")~(" + (int)this.districtB.x + "," + (int)this.districtB.y + ")";
        }

        public Vec2 center() {
            return new Vec2((this.districtA.x + this.districtB.x) / 2.0f, (this.districtA.y + this.districtB.y) / 2.0f);
        }

        public void draw() {
            if (this.districtA.x == this.districtB.x || this.districtA.y == this.districtB.y) {
                return;
            }
            Draw.reset();
            float width = (this.districtB.x - this.districtA.x) * 8.0f;
            float height = (this.districtB.y - this.districtA.y) * 8.0f;
            if (this.districtType.districtType != null) {
                Draw.alpha(0.5f);
                Draw.rect(this.districtType.districtType.fullIcon, this.districtA.x * 8.0f, this.districtA.y * 8.0f, width, height);
            }
            if (this.districtType.districtName != null) {
                DrawUtilities.arcFillTextHead(this.districtType.getName(), this.districtA.x, this.districtB.x, Math.max(this.districtA.y, this.districtB.y), 0.2f);
            }
            Draw.color(Pal.stat, 0.7f);
            Draw.z(109.0f);
            Lines.stroke(Math.min(Math.abs(width), Math.abs(height)) / 8.0f / 10.0f);
            Lines.rect(this.districtA.x * 8.0f, this.districtA.y * 8.0f, width, height);
            Draw.reset();
        }

        public String getLoc() {
            return "(" + (int)this.districtA.x + "," + (int)this.districtA.y + ") ~ (" + (int)this.districtB.x + "," + (int)this.districtB.y + ")";
        }
    }

    public static class districtType {
        public UnlockableContent districtType = null;
        public String districtName = null;

        districtType(UnlockableContent districtType2, String districtName) {
            this.districtType = districtType2;
            this.districtName = districtName;
        }

        districtType(UnlockableContent districtType2) {
            this.districtType = districtType2;
        }

        districtType(String districtName) {
            this.districtName = districtName;
        }

        public String getName() {
            if (this.districtName == null) {
                return this.districtType.emoji();
            }
            if (this.districtType == null) {
                return this.districtName;
            }
            return this.districtType.emoji() + " " + this.districtName;
        }
    }
}

