/*
 * Decompiled with CFR 0.152.
 */
package mindustry;

import arc.ApplicationCore;
import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.assets.AssetManager;
import arc.assets.Loadable;
import arc.assets.loaders.MusicLoader;
import arc.assets.loaders.SoundLoader;
import arc.audio.Music;
import arc.audio.Sound;
import arc.files.Fi;
import arc.graphics.Gl;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.PixmapPacker;
import arc.graphics.g2d.SpriteBatch;
import arc.graphics.g2d.TextureAtlas;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.Threads;
import arc.util.Time;
import java.security.NoSuchAlgorithmException;
import mindustry.Vars;
import mindustry.ai.BaseRegistry;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.TimeControl;
import mindustry.core.ContentLoader;
import mindustry.core.Control;
import mindustry.core.FileTree;
import mindustry.core.Logic;
import mindustry.core.NetClient;
import mindustry.core.NetServer;
import mindustry.core.PerfCounter;
import mindustry.core.Platform;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.game.EventType;
import mindustry.game.Schematics;
import mindustry.gen.Musics;
import mindustry.gen.Sounds;
import mindustry.graphics.LoadRenderer;
import mindustry.graphics.NvGpuInfo;
import mindustry.graphics.YuanShenLoadRenderer;
import mindustry.maps.Map;
import mindustry.maps.MapPreviewLoader;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import mindustry.net.Net;
import mindustry.ui.Fonts;

public abstract class ClientLauncher
extends ApplicationCore
implements Platform {
    private static final int loadingFPS = 30;
    private long nextFrame;
    private long beginTime;
    private long lastTargetFps = -1L;
    private boolean finished = false;
    private LoadRenderer loader;
    public static boolean YuanShenLoader;

    @Override
    public void setup() {
        long ram;
        boolean gb;
        String dataDir = System.getProperty("mindustry.data.dir", OS.env("MINDUSTRY_DATA_DIR"));
        if (dataDir != null) {
            Core.settings.setDataDirectory(Core.files.absolute(dataDir));
        }
        Vars.checkLaunch();
        Vars.loadLogger();
        Core.settings.setAppName("Mindustry");
        YuanShenLoader = Core.settings.getDataDirectory().child("yuanshen").exists();
        this.loader = YuanShenLoader ? new YuanShenLoadRenderer() : new LoadRenderer();
        Events.fire(new EventType.ClientCreateEvent());
        Vars.loadFileLogger();
        Vars.platform = this;
        Vars.maxTextureSize = Gl.getInt(3379);
        this.beginTime = Time.millis();
        Log.info("[GL] Version: @", Core.graphics.getGLVersion());
        Log.info("[GL] Max texture size: @", Vars.maxTextureSize);
        Log.info("[GL] Using @ context.", Core.gl30 != null ? "OpenGL 3" : "OpenGL 2");
        if (Core.gl30 == null) {
            Log.warn("[GL] Your device or video drivers do not support OpenGL 3. This will cause performance issues.", new Object[0]);
        }
        if (NvGpuInfo.hasMemoryInfo()) {
            Log.info("[GL] Total available VRAM: @mb", NvGpuInfo.getMaxMemoryKB() / 1024);
        }
        if (Vars.maxTextureSize < 4096) {
            Log.warn("[GL] Your maximum texture size is below the recommended minimum of 4096. This will cause severe performance issues.", new Object[0]);
        }
        Log.info("[JAVA] Version: @", OS.javaVersion);
        if (Core.app.isAndroid()) {
            Log.info("[ANDROID] API level: @", Core.app.getVersion());
        }
        boolean bl = gb = (ram = Runtime.getRuntime().maxMemory()) >= 0x40000000L;
        if (!OS.isIos) {
            Log.info("[RAM] Available: @ @", Strings.fixed(gb ? (float)ram / 1024.0f / 1024.0f / 1024.0f : (float)ram / 1024.0f / 1024.0f, 1), gb ? "GB" : "MB");
        }
        Time.setDeltaProvider(TimeControl.deltaProvider);
        UI.loadColors();
        Core.batch = new SpriteBatch();
        Core.assets = new AssetManager();
        Core.assets.setLoader(Texture.class, ".msav", new MapPreviewLoader());
        Vars.tree = new FileTree();
        Core.assets.setLoader(Sound.class, new SoundLoader(Vars.tree){

            @Override
            public void loadAsync(AssetManager manager, String fileName, Fi file, SoundLoader.SoundParameter parameter) {
            }

            @Override
            public Sound loadSync(AssetManager manager, String fileName, Fi file, SoundLoader.SoundParameter parameter) {
                if (parameter != null && parameter.sound != null) {
                    Vars.mainExecutor.submit(() -> parameter.sound.load(file));
                    return parameter.sound;
                }
                Sound sound = new Sound();
                Vars.mainExecutor.submit(() -> {
                    try {
                        sound.load(file);
                    }
                    catch (Throwable t) {
                        Log.err("Error loading sound: " + file, t);
                    }
                });
                return sound;
            }
        });
        Core.assets.setLoader(Music.class, new MusicLoader(Vars.tree){

            @Override
            public void loadAsync(AssetManager manager, String fileName, Fi file, MusicLoader.MusicParameter parameter) {
            }

            @Override
            public Music loadSync(AssetManager manager, String fileName, Fi file, MusicLoader.MusicParameter parameter) {
                if (parameter != null && parameter.music != null) {
                    Vars.mainExecutor.submit(() -> {
                        try {
                            parameter.music.load(file);
                        }
                        catch (Throwable t) {
                            Log.err("Error loading music: " + file, t);
                        }
                    });
                    return parameter.music;
                }
                Music music = new Music();
                Vars.mainExecutor.submit(() -> {
                    try {
                        music.load(file);
                    }
                    catch (Throwable t) {
                        Log.err("Error loading music: " + file, t);
                    }
                });
                return music;
            }
        });
        Core.assets.load("sprites/error.png", Texture.class);
        Core.atlas = TextureAtlas.blankAtlas();
        Vars.net = new Net(Vars.platform.getNet());
        MapPreviewLoader.setupLoaders();
        Vars.mods = new Mods();
        Vars.schematics = new Schematics();
        Core.assets.load(new Vars());
        Core.assets.load(new ARCVars());
        Vars.loadSettings();
        Fonts.loadSystemCursors();
        String proxy = Core.settings.getString("arcNetProxy", "");
        if (!proxy.isEmpty()) {
            try {
                String[] parts = proxy.split(":");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("\u65e0\u6548\u683c\u5f0f\uff01\u683c\u5f0f\u5e94\u4e3aip:port\uff0c\u5f53\u524d\u4ee3\u7406: " + proxy);
                }
                System.setProperty("http.proxyHost", parts[0]);
                System.setProperty("http.proxyPort", parts[1]);
                System.setProperty("https.proxyHost", parts[0]);
                System.setProperty("https.proxyPort", parts[1]);
            }
            catch (Exception err) {
                Log.err("\u65e0\u6548\u4ee3\u7406\u8bbe\u7f6e: " + proxy, new Object[0]);
                Events.on(EventType.ClientLoadEvent.class, e -> Vars.ui.showException("\u65e0\u6548\u4ee3\u7406\u8bbe\u7f6e", err));
            }
        }
        Fonts.loadDefaultFont();
        Core.assets.load(new AssetDescriptor<TextureAtlas>((String)(Vars.maxTextureSize >= 4096 ? "sprites/sprites.aatls" : "sprites/fallback/sprites.aatls"), TextureAtlas.class)).loaded = t -> {
            Core.atlas = t;
        };
        Core.assets.loadRun("maps", Map.class, () -> Vars.maps.loadPreviews());
        Musics.load();
        Sounds.load();
        Core.assets.loadRun("contentcreate", Content.class, () -> {
            Vars.content.createBaseContent();
            Vars.content.loadColors();
        }, () -> {
            Vars.mods.loadScripts();
            Vars.content.createModContent();
        });
        Core.assets.load(Vars.mods);
        Core.assets.loadRun("mergeUI", PixmapPacker.class, () -> {}, () -> Fonts.mergeFontAtlas(Core.atlas));
        Vars.logic = new Logic();
        this.add(Vars.logic);
        Vars.control = new Control();
        this.add(Vars.control);
        Vars.renderer = new Renderer();
        this.add(Vars.renderer);
        Vars.ui = new UI();
        this.add(Vars.ui);
        Vars.netServer = new NetServer();
        this.add(Vars.netServer);
        Vars.netClient = new NetClient();
        this.add(Vars.netClient);
        Core.assets.load(Vars.schematics);
        Core.assets.loadRun("contentinit", ContentLoader.class, () -> Vars.content.init(), () -> Vars.content.load());
        Core.assets.loadRun("baseparts", BaseRegistry.class, () -> {}, () -> Vars.bases.load());
        if (YuanShenLoader) {
            Core.assets.load(new YuanShenLoadRenderer.LoadLock());
        }
    }

    @Override
    public void add(ApplicationListener module) {
        super.add(module);
        if (module instanceof Loadable) {
            Loadable l = (Loadable)((Object)module);
            Core.assets.load(l);
        }
    }

    @Override
    public void resize(int width, int height) {
        if (Core.assets == null) {
            return;
        }
        if (!this.finished) {
            Draw.proj().setOrtho(0.0f, 0.0f, width, height);
        } else {
            super.resize(width, height);
        }
    }

    @Override
    public void update() {
        long current;
        PerfCounter.update.begin();
        int targetfps = Core.settings.getInt("fpscap", 120);
        boolean changed = this.lastTargetFps != (long)targetfps && this.lastTargetFps != -1L;
        boolean limitFps = targetfps > 0 && targetfps <= 240;
        this.lastTargetFps = targetfps;
        this.nextFrame = limitFps && !changed ? (this.nextFrame += (long)(1000000000 / targetfps)) : Time.nanos();
        if (!this.finished) {
            if (this.loader != null) {
                this.loader.draw();
            }
            if (Core.assets.update(33)) {
                this.loader.dispose();
                this.loader = null;
                Log.info("Total time to load: @ms", Time.timeSinceMillis(this.beginTime));
                for (ApplicationListener listener : this.modules) {
                    listener.init();
                }
                Vars.mods.eachClass(Mod::init);
                this.finished = true;
                Events.fire(new EventType.ClientLoadEvent());
                Vars.clientLoaded = true;
                super.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> Core.app.post(() -> {
                    super.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                    Vars.finishLaunch();
                }))));
            }
        } else {
            try {
                Core.graphics.setTitle(this.getWindowTitle());
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            Vars.asyncCore.begin();
            super.update();
            Vars.asyncCore.end();
        }
        if (limitFps && this.nextFrame > (current = Time.nanos())) {
            long toSleep = this.nextFrame - current;
            Threads.sleep(toSleep / 1000000L, (int)(toSleep % 1000000L));
        }
        PerfCounter.update.end();
    }

    private String getWindowTitle() throws NoSuchAlgorithmException {
        if (Control.bossKeyPressing) {
            return "\u8ba1\u7b97\u5668";
        }
        int enabled = Vars.mods.mods.count(Mods.LoadedMod::enabled);
        return "Mindustry-CN-ARC | \u7248\u672c\u53f7 " + (Version.arcBuild <= 0 ? "dev" : Integer.valueOf(Version.arcBuild)) + " | mod\u542f\u7528" + enabled + "/" + (Vars.mods == null ? 0 : Vars.mods.mods.size) + " | " + (Core.graphics != null ? Core.graphics.getWidth() + "x" + Core.graphics.getHeight() : "");
    }

    @Override
    public void exit() {
        Vars.finishLaunch();
    }

    @Override
    public void init() {
        this.nextFrame = Time.nanos();
        this.setup();
    }

    @Override
    public void resume() {
        if (this.finished) {
            super.resume();
        }
    }

    @Override
    public void pause() {
        if (Vars.mobile) {
            Vars.finishLaunch();
        }
        if (this.finished) {
            super.pause();
        }
    }
}

