/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Application;
import arc.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GLVersion {
    public final String vendorString;
    public final String rendererString;
    public final GlType type;
    public int majorVersion;
    public int minorVersion;
    public int releaseVersion;

    public GLVersion(Application.ApplicationType appType, String versionString, String vendorString, String rendererString) {
        this.type = appType == Application.ApplicationType.android ? GlType.GLES : (appType == Application.ApplicationType.iOS ? GlType.GLES : (appType == Application.ApplicationType.desktop ? GlType.OpenGL : (appType == Application.ApplicationType.web ? GlType.WebGL : GlType.NONE)));
        if (this.type == GlType.GLES) {
            this.extractVersion("OpenGL ES (\\d(\\.\\d){0,2})", versionString);
        } else if (this.type == GlType.WebGL) {
            this.extractVersion("WebGL (\\d(\\.\\d){0,2})", versionString);
        } else if (this.type == GlType.OpenGL) {
            this.extractVersion("(\\d(\\.\\d){0,2})", versionString);
        } else {
            this.majorVersion = -1;
            this.minorVersion = -1;
            this.releaseVersion = -1;
            vendorString = "";
            rendererString = "";
        }
        this.vendorString = vendorString;
        this.rendererString = rendererString;
    }

    private void extractVersion(String patternString, String versionString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(versionString);
        boolean found = matcher.find();
        if (found) {
            String result = matcher.group(1);
            String[] resultSplit = result.split("\\.");
            this.majorVersion = this.parseInt(resultSplit[0], 2);
            this.minorVersion = resultSplit.length < 2 ? 0 : this.parseInt(resultSplit[1], 0);
            this.releaseVersion = resultSplit.length < 3 ? 0 : this.parseInt(resultSplit[2], 0);
        } else {
            Log.err("[Arc GL] Invalid version string: " + versionString, new Object[0]);
            this.majorVersion = 2;
            this.minorVersion = 0;
            this.releaseVersion = 0;
        }
    }

    private int parseInt(String v, int defaultValue) {
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException nfe) {
            Log.err("[Arc GL] Error parsing number: " + v + ", assuming: " + defaultValue, new Object[0]);
            return defaultValue;
        }
    }

    public boolean atLeast(int testMajorVersion, int testMinorVersion) {
        return this.majorVersion > testMajorVersion || this.majorVersion == testMajorVersion && this.minorVersion >= testMinorVersion;
    }

    public String getDebugVersionString() {
        return "Type: " + (Object)((Object)this.type) + "\nVersion: " + this.majorVersion + ":" + this.minorVersion + ":" + this.releaseVersion + "\nVendor: " + this.vendorString + "\nRenderer: " + this.rendererString;
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.majorVersion + "." + this.minorVersion + "." + this.releaseVersion + " / " + this.vendorString + " / " + this.rendererString;
    }

    public static enum GlType {
        OpenGL,
        GLES,
        WebGL,
        NONE;

    }
}

