# LIN Middleware Library 1.10

## What's Included?

Refer to the [README.md](./README.md) and the [API Reference Guide](https://cypresssemiconductorco.github.io/lin/html/index.html) for a complete description of the LIN Middleware.

## Defect Fixes

* Added CAT2 Hardware Abstraction Layers (mtb-hal-cat2) 2.x support.

## Supported Software and Tools

This version of the LIN Middleware was validated for the compatibility with the following Software and Tools:

| Software and Tools                                      | Version |
| :---                                                    | :----:  |
| ModusToolbox Software Environment                       | 2.4.0   |
| CAT2 Peripheral Driver Library                          | 1.1.0   |
| CAT2 Hardware Abstraction Layers                        | 2.0.0   |
| Core Library                                            | 1.1.5   |
| GCC Compiler                                            | 10.3.1  |
| IAR Compiler                                            | 8.42    |
| ARM Compiler 6                                          | 6.13    |

## More information

For more information, refer to the following documents:

* [LIN Middleware README.md](./README.md)
* [LIN Middleware API Reference Guide](https://cypresssemiconductorco.github.io/lin/html/index.html)
* [ModusToolbox Software Environment, Quick Start Guide, Documentation, and Videos](https://www.cypress.com/products/modustoolbox-software-environment)
* [CAT2 Peripheral Driver Library API Reference](https://cypresssemiconductorco.github.io/mtb-pdl-cat2/pdl_api_reference_manual/html/index.html)
* [Infineon Technologies AG](https://www.infineon.com)

---
© Cypress Semiconductor Corporation (an Infineon company) or an affiliate of Cypress Semiconductor Corporation, 2021.
