# LIN Middleware Library

## Overview

The LIN middleware implements a slave node for the PSoC 4000S, PSoC 4100S,
PSoC 4100S Plus, PSoC 4500S, and PSoC 4100S Max devices.

## Features

* Full LIN 2.2 Slave Node implementation
* Compliance with ISO 17987 specification
* Full transport layer support
* Automatic baud rate synchronization
* Automatic detection of bus inactivity
* Fully implements a Diagnostic Class I Slave Node
* Supports implementation of Diagnostic Class II and III Slave Node
* Full error detection
* Automatic configuration services

## Quick Start

Refer to the [API Reference Guide Quick Start Guide](https://cypresssemiconductorco.github.io/lin/html/index.html) section for step-by-step instruction how to enable the LIN Middleware Library.

## Known issues/limitations
An event-triggered frame reports incorrect data when such a frame is associated with the unconditional frame where the response error signal is placed. To get the correct data, read an unconditional frame instead an event-triggered frame.

## More information

For more information, refer to the following documents:

* [LIN Middleware RELEASE.md](./RELEASE.md)
* [LIN Middleware API Reference Guide](https://cypresssemiconductorco.github.io/lin/html/index.html)
* [ModusToolbox Software Environment, Quick Start Guide, Documentation, and Videos](https://www.cypress.com/products/modustoolbox-software-environment)
* [CAT2 Peripheral Driver Library API Reference](https://cypresssemiconductorco.github.io/mtb-pdl-cat2/pdl_api_reference_manual/html/index.html)
* [PSoC 4100S MAX](https://www.infineon.com/cms/en/product/microcontroller/32-bit-automotive-psoc-4-based-on-arm-cortex-m/psoc-4100s-max/)
* [Infineon Technologies AG](https://www.infineon.com)

---
© Cypress Semiconductor Corporation (an Infineon company) or an affiliate of Cypress Semiconductor Corporation, 2021.
