/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.world;

import arc.func.Intc;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.game.SpawnGroup;
import mindustry.type.UnitType;
import subvoyage.content.SvUnits;

public class AtlacianWaves {
    public static Seq<SpawnGroup> generate(final float difficulty, final Rand rand, boolean attack, boolean airOnly) {
        UnitType[][] species = new UnitType[][]{{SvUnits.lapetus, SvUnits.skath, SvUnits.charon, SvUnits.callees, SvUnits.ganymede}, {SvUnits.leeft, SvUnits.flagshi, SvUnits.vanguard, SvUnits.squadron, SvUnits.armada}};
        if (airOnly) {
            species = (UnitType[][])Structs.filter(UnitType[].class, (Object[])species, v -> v[0].flying);
        }
        UnitType[][] fspec = species = (UnitType[][])Structs.filter(UnitType[].class, (Object[])species, v -> v[0].flying || v[0].naval);
        Seq out = new Seq();
        final int cap = 150;
        float shieldStart = 30.0f;
        final float shieldsPerWave = 20.0f + difficulty * 30.0f;
        final float[] scaling = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Intc createProgression = start -> {
            UnitType[] curSpecies = (UnitType[])Structs.random((Rand)rand, (Object[])fspec);
            int curTier = 0;
            int i = start;
            while (i < cap) {
                final int f = i;
                final int next = rand.random(8, 16) + (int)Mathf.lerp((float)5.0f, (float)0.0f, (float)difficulty) + curTier * 4;
                final float shieldAmount = Math.max(((float)i - shieldStart) * shieldsPerWave, 0.0f);
                final int space = start == 0 ? 1 : rand.random(1, 2);
                final int ctier = curTier;
                out.add((Object)new SpawnGroup(curSpecies[Math.min(curTier, curSpecies.length - 1)]){
                    {
                        super(arg0);
                        this.unitAmount = f == start ? 1 : 6 / (int)scaling[ctier];
                        this.begin = f;
                        this.end = f + next >= cap ? Integer.MAX_VALUE : f + next;
                        this.max = 13;
                        this.unitScaling = (difficulty < 0.4f ? rand.random(2.5f, 5.0f) : rand.random(1.0f, 4.0f)) * scaling[ctier];
                        this.shields = shieldAmount;
                        this.shieldScaling = shieldsPerWave;
                        this.spacing = space;
                    }
                });
                out.add((Object)new SpawnGroup(curSpecies[Math.min(curTier, curSpecies.length - 1)]){
                    {
                        super(arg0);
                        this.unitAmount = 3 / (int)scaling[ctier];
                        this.begin = f + next - 1;
                        this.end = f + next + rand.random(6, 10);
                        this.max = 6;
                        this.unitScaling = rand.random(2.0f, 4.0f);
                        this.spacing = rand.random(2, 4);
                        this.shields = shieldAmount / 2.0f;
                        this.shieldScaling = shieldsPerWave;
                    }
                });
                i += next + 1;
                if (curTier < 3 || rand.chance(0.05) && (double)difficulty > 0.8) {
                    ++curTier;
                }
                curTier = Math.min(curTier, 3);
                if (!rand.chance(0.3)) continue;
                curSpecies = (UnitType[])Structs.random((Rand)rand, (Object[])fspec);
            }
        };
        createProgression.get(0);
        for (int step = 5 + rand.random(5); step <= cap; step += (int)((float)rand.random(15, 30) * Mathf.lerp((float)1.0f, (float)0.5f, (float)difficulty))) {
            createProgression.get(step);
        }
        final int bossWave = (int)((float)rand.random(30, 50) * Mathf.lerp((float)1.0f, (float)0.5f, (float)difficulty));
        final int bossSpacing = (int)((float)rand.random(25, 40) * Mathf.lerp((float)1.0f, (float)0.5f, (float)difficulty));
        int bossTier = (double)difficulty < 0.6 ? 3 : 4;
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Rand)rand, (Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = bossWave;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Rand)rand, (Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = bossWave + rand.random(3, 5) * bossSpacing;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        final int finalBossStart = 120 + rand.random(30);
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Rand)rand, (Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = finalBossStart;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        out.add((Object)new SpawnGroup(((UnitType[])Structs.random((Rand)rand, (Object[])species))[bossTier]){
            {
                super(arg0);
                this.unitAmount = 1;
                this.begin = finalBossStart + 15;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        if (attack && (double)difficulty >= 0.5) {
            int amount = rand.random(1, 3 + (int)(difficulty * 2.0f));
            for (int i = 0; i < amount; ++i) {
                final int wave = rand.random(3, 20);
                out.add((Object)new SpawnGroup(UnitTypes.mega){
                    {
                        super(arg0);
                        this.unitAmount = 1;
                        this.begin = wave;
                        this.end = wave;
                        this.max = 16;
                    }
                });
            }
        }
        int shift = Math.max((int)(difficulty * 14.0f - 5.0f), 0);
        for (SpawnGroup group : out) {
            group.begin -= shift;
            group.end -= shift;
        }
        return out;
    }
}

