/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.world;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Tmp;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.ai.Astar;
import mindustry.content.Blocks;
import mindustry.game.Schematics;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.SteamVent;
import mindustry.world.blocks.environment.TallBlock;
import subvoyage.content.block.SvEnvironment;
import subvoyage.content.other.SvLoadouts;
import subvoyage.core.draw.SvPal;

public class AtlacianPlanetGenerator
extends PlanetGenerator {
    public static float heightOct = 6.0f;
    public static float heightPers = 0.6f;
    public static float heightScl = 1.3f;
    public static float heightPow = 1.2f;
    public static float heightVal = 1.5f;
    public static float airThresh = 0.5f;
    public static float airScl = 1.2f;
    public static float oceanLevel = 0.65f;
    public static float liqThresh = 0.64f;
    public static float liqScl = 87.0f;
    Block[] terrain;
    Block[] visualTerrain;

    public AtlacianPlanetGenerator() {
        this.baseSeed = 10;
        this.defaultLoadout = SvLoadouts.corePuffer;
        this.terrain = new Block[]{Blocks.water, Blocks.water, Blocks.water, Blocks.water, Blocks.water, SvEnvironment.darkLegartyteStone, SvEnvironment.darkLegartyteStone, SvEnvironment.darkLegartyteStone, SvEnvironment.legartyteStone, SvEnvironment.legartyteStone, SvEnvironment.legartyteStone, SvEnvironment.legartyteStone, SvEnvironment.agaryteStone, SvEnvironment.agaryteStone, SvEnvironment.archalyteStone, SvEnvironment.sodilateStone};
        this.visualTerrain = new Block[]{Blocks.water, Blocks.water, Blocks.water, Blocks.water, Blocks.water, SvEnvironment.legartyteStone, SvEnvironment.legartyteStone, SvEnvironment.legartyteStone, SvEnvironment.agaryteStone, SvEnvironment.archalyteStone, SvEnvironment.sodilateStone};
    }

    public void generateSector(Sector sector) {
    }

    public float getHeight(Vec3 position) {
        if (Mathf.pow((float)this.rawHeight(position), (float)heightPow) * heightVal <= oceanLevel) {
            return oceanLevel;
        }
        return Math.min(Mathf.pow((float)this.rawHeight(position), (float)heightPow) * heightVal + 0.1f, 1.2f);
    }

    public Color getColor(Vec3 position) {
        Block block = this.getVisualBlock(position);
        if (block == SvEnvironment.legartyteStone) {
            return SvPal.legartyte.value(0.2f).saturation(0.5f);
        }
        if (block == SvEnvironment.agaryteStone) {
            return SvPal.agaryte.cpy().value(0.2f);
        }
        if (block == SvEnvironment.archalyteStone) {
            return SvPal.corallite.cpy().value(0.3f);
        }
        if (block == SvEnvironment.sodilateStone) {
            Tmp.c1.set(block.mapColor).a(1.0f - block.albedo).value(0.5f);
        }
        return Tmp.c1.set(block.mapColor).a(1.0f - block.albedo);
    }

    public float getSizeScl() {
        return 2568.0f;
    }

    float rawHeight(Vec3 position) {
        return Simplex.noise3d((int)this.seed, (double)heightOct, (double)heightPers, (double)(1.0f / heightScl), (double)(10.0f + position.x), (double)(10.0f + position.y), (double)(10.0f + position.z));
    }

    float rawWeight(Vec3 position) {
        return position.dst(0.0f, 0.0f, 1.0f) * 2.2f - Simplex.noise3d((int)this.seed, (double)6.0, (double)0.35, (double)1.6f, (double)(12.0f + position.x), (double)(18.0f + position.y), (double)(15.0f + position.z)) * 2.9f;
    }

    Block getBlock(Vec3 position) {
        float wgh = this.rawWeight(position);
        Tmp.v32.set(position);
        float height = this.rawHeight(position);
        Tmp.v31.set(position);
        height *= 1.5f;
        height = Mathf.clamp((float)height);
        Block result = this.terrain[Mathf.clamp((int)((int)(height * (float)this.terrain.length)), (int)0, (int)(this.terrain.length - 1))];
        if (height <= oceanLevel - 0.15f) {
            return Blocks.deepwater;
        }
        if (height <= oceanLevel - 0.05f) {
            return Blocks.water;
        }
        if (height <= oceanLevel) {
            return Blocks.darksandWater;
        }
        position = Tmp.v32;
        return result;
    }

    Block getVisualBlock(Vec3 position) {
        float wgh = this.rawWeight(position);
        Tmp.v32.set(position);
        float height = this.rawHeight(position);
        Tmp.v31.set(position);
        height *= 1.5f;
        height = Mathf.clamp((float)height);
        Block result = this.visualTerrain[Mathf.clamp((int)((int)(height * (float)this.visualTerrain.length)), (int)0, (int)(this.visualTerrain.length - 1))];
        if (height <= oceanLevel - 0.15f) {
            return Blocks.deepwater;
        }
        if (height <= oceanLevel - 0.05f) {
            return Blocks.water;
        }
        if (height <= oceanLevel) {
            return Blocks.darksandWater;
        }
        position = Tmp.v32;
        return result;
    }

    public void genTile(Vec3 position, TileGen tile) {
        tile.floor = this.getBlock(position.scl(8.0f));
        tile.block = tile.floor.asFloor().wall;
        if (tile.block == Blocks.sandWall) {
            tile.block = SvEnvironment.legartyteWall;
        }
        if (tile.block == Blocks.duneWall) {
            tile.block = SvEnvironment.archalyteWall;
        }
        if (Ridged.noise3d((int)(this.seed + 1), (double)position.x, (double)position.y, (double)position.z, (int)2, (float)airScl) > airThresh || Simplex.noise3d((int)(this.seed + 1), (double)heightOct, (double)heightPers, (double)airScl, (double)position.x, (double)position.y, (double)position.z) > airThresh) {
            tile.block = Blocks.air;
        }
        if ((double)Ridged.noise3d((int)(this.seed + 2), (double)position.x, (double)(position.y + 4.0f), (double)position.z, (int)3, (float)0.2f) > 0.6) {
            tile.floor = Blocks.water;
        }
    }

    protected void generate() {
        this.cells(4);
        float length = (float)this.width / 2.6f;
        Vec2 trns = Tmp.v1.trns(this.rand.random(360.0f), length);
        int spawnX = (int)(trns.x + (float)this.width / 2.0f);
        int spawnY = (int)(trns.y + (float)this.height / 2.0f);
        int endX = (int)(-trns.x + (float)this.width / 2.0f);
        int endY = (int)(-trns.y + (float)this.height / 2.0f);
        float maxd = Mathf.dst((float)((float)this.width / 2.0f), (float)((float)this.height / 2.0f));
        this.erase(spawnX, spawnY, 15);
        this.brush(this.pathfind(spawnX, spawnY, endX, endY, tile -> (tile.solid() ? 300.0f : 0.0f) + maxd - tile.dst((float)this.width / 2.0f, (float)this.height / 2.0f) / 10.0f, Astar.manhattan), 9);
        this.erase(endX, endY, 15);
        this.pass((x, y) -> {
            if (this.floor != SvEnvironment.sodilateStone) {
                return;
            }
            if (this.nearWall(x, y)) {
                return;
            }
            float noise = this.noise(x + 300, (float)y - (float)x * 1.6f + 100.0f, 4.0, 0.8f, liqScl, 1.0);
            if (noise > liqThresh) {
                this.floor = SvEnvironment.darkHardWater;
            }
        });
        this.median(2, 0.6, SvEnvironment.sodilateStone);
        this.median(2, 0.6, SvEnvironment.darkHardWater);
        this.blend(SvEnvironment.darkHardWater, SvEnvironment.hardWater, 4.0f);
        this.blend(SvEnvironment.sodilateStone, SvEnvironment.darkSodilateFloor, 4.0f);
        this.distort(10.0f, 12.0f);
        this.distort(5.0f, 7.0f);
        this.median(2, 0.6, SvEnvironment.archalyteStone);
        this.inverseFloodFill(this.tiles.getn(spawnX, spawnY));
        this.blend(SvEnvironment.archalyteStone, SvEnvironment.darkArchalyteStone, 4.0f);
        this.blend(SvEnvironment.legartyteStone, SvEnvironment.darkLegartyteStone, 4.0f);
        this.erase(endX, endY, 6);
        this.tiles.getn(endX, endY).setOverlay(Blocks.spawn);
        this.pass((x, y) -> {
            if (this.block != Blocks.air) {
                if (this.nearAir(x, y)) {
                    if (this.block == SvEnvironment.sodilateWall && this.noise(x + 78, y, 4.0, 0.7f, 33.0, 1.0) > 0.52f) {
                        this.ore = SvEnvironment.wallOreSpaclanium;
                    } else if (this.block != SvEnvironment.sodilateWall && this.noise(x + 782, y, 4.0, 0.8f, 38.0, 1.0) > 0.665f) {
                        this.ore = SvEnvironment.wallOreCorallite;
                    }
                }
            } else if (!this.nearWall(x, y)) {
                if (this.noise(x + 78, y, 4.0, 0.7f, 15.0, 1.0) > 0.72f) {
                    this.ore = SvEnvironment.oreSpaclanium;
                }
                if (this.noise(x + 782, y, 4.0, 0.8f, 20.0, 1.0) > 0.665f) {
                    this.ore = SvEnvironment.oreCorallite;
                }
                if (this.noise(x + 150, y + x * 2 + 100, 4.0, 0.8f, 55.0, 1.0) > 0.76f) {
                    this.ore = SvEnvironment.oreIridium;
                }
                if (this.noise(x + 999, y + 600 - x, 4.0, 0.63f, 45.0, 1.0) < 0.27f && this.floor == SvEnvironment.agaryteStone) {
                    this.ore = SvEnvironment.oreChromium;
                }
            }
            if (this.block == Blocks.air && (this.floor == SvEnvironment.archalyteStone || this.floor == SvEnvironment.darkArchalyteStone) && this.rand.chance(0.09) && this.nearWall(x, y) && !this.near(x, y, 4, SvEnvironment.archalyteSpikes)) {
                this.block = SvEnvironment.archalyteSpikes;
                this.ore = Blocks.air;
            }
            if (this.block == SvEnvironment.sodilateWall && this.rand.chance(0.23) && this.nearAir(x, y) && !this.near(x, y, 3, SvEnvironment.sodilateBlocks)) {
                this.block = SvEnvironment.sodilateBlocks;
                this.ore = Blocks.air;
            }
            if (this.block == SvEnvironment.agaryteWall && this.rand.chance(0.3) && this.nearAir(x, y) && !this.near(x, y, 3, SvEnvironment.agaryteBlocks)) {
                this.block = SvEnvironment.agaryteBlocks;
                this.ore = Blocks.air;
            }
        });
        this.pass((x, y) -> {
            if (this.ore.asFloor().wallOre || this.block.itemDrop != null || this.block == Blocks.air && this.ore != Blocks.air) {
                this.removeWall(x, y, 3, b -> b instanceof TallBlock);
            }
        });
        this.trimDark();
        int minVents = this.rand.random(6, 9);
        int ventCount = 0;
        block0: for (Tile tile2 : this.tiles) {
            Floor floor = tile2.floor();
            if (floor != SvEnvironment.legartyteStone && floor != SvEnvironment.darkLegartyteStone || !this.rand.chance(0.002)) continue;
            int radius = 2;
            for (int x2 = -radius; x2 <= radius; ++x2) {
                for (int y2 = -radius; y2 <= radius; ++y2) {
                    Tile other = this.tiles.get(x2 + tile2.x, y2 + tile2.y);
                    if (other == null || other.floor() != SvEnvironment.legartyteStone && other.floor() != SvEnvironment.darkLegartyteStone || other.block().solid) continue block0;
                }
            }
            ++ventCount;
            for (Point2 pos : SteamVent.offsets) {
                Tile other = this.tiles.get(pos.x + tile2.x + 1, pos.y + tile2.y + 1);
                other.setFloor(SvEnvironment.crudesQuarry.asFloor());
            }
        }
        for (Tile tile2 : this.tiles) {
            if (!tile2.overlay().needsSurface || tile2.floor().hasSurface()) continue;
            tile2.setOverlay(Blocks.air);
        }
        this.pass((x, y) -> {
            if (this.block == Blocks.sandWall) {
                this.block = SvEnvironment.legartyteWall;
            }
            if (this.block == Blocks.duneWall) {
                this.block = SvEnvironment.archalyteWall;
            }
        });
        this.decoration(0.017f);
        Schematics.placeLaunchLoadout((int)spawnX, (int)spawnY);
    }
}

