/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.type;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.ammo.ItemAmmoType;
import subvoyage.content.SvItems;
import subvoyage.core.draw.SvPal;
import subvoyage.type.unit.weapon.HydromechWeapon;

public class AtlacianUnitType
extends UnitType {
    public float bodyScale = 1.0f;
    public boolean bodyHeat = false;
    public TextureRegion regionHeat;
    public Color heatColor = Pal.turretHeat;

    public AtlacianUnitType(String name) {
        super(name);
        this.outlineColor = SvPal.outline;
        this.envDisabled = 2;
        this.ammoType = new ItemAmmoType(SvItems.corallite);
        this.researchCostMultiplier = 10.0f;
    }

    public void load() {
        super.load();
        this.regionHeat = Core.atlas.find(this.name + "-heat");
    }

    public void update(Unit unit) {
        super.update(unit);
        if (this.bodyHeat) {
            for (Weapon weapon : unit.type.weapons) {
                weapon.heatColor = this.heatColor;
            }
        }
    }

    public void drawBody(Unit unit) {
        float scl = Draw.scl;
        Draw.scl((float)this.bodyScale);
        super.drawBody(unit);
        if (this.bodyHeat && this.regionHeat != null && this.regionHeat.found()) {
            float warmup = 0.0f;
            for (WeaponMount mount : unit.mounts) {
                HydromechWeapon hw;
                Weapon weapon = mount.weapon;
                if (weapon instanceof HydromechWeapon) {
                    hw = (HydromechWeapon)weapon;
                    if (!hw.hasHeat) continue;
                }
                if ((weapon = mount.weapon) instanceof HydromechWeapon) {
                    hw = (HydromechWeapon)weapon;
                    warmup = Math.max(warmup, hw.warmupToHeat ? mount.warmup : mount.heat);
                    continue;
                }
                warmup = Math.max(warmup, mount.heat);
            }
            Draw.blend((Blending)Blending.additive);
            Draw.color((Color)this.heatColor, (float)warmup);
            Draw.scl((float)this.bodyScale);
            Draw.rect((TextureRegion)this.regionHeat, (float)unit.x, (float)unit.y, (float)(unit.rotation - 90.0f));
            Draw.blend((Blending)Blending.normal);
        }
        Draw.scl();
    }

    public void drawCell(Unit unit) {
        float scl = Draw.scl;
        Draw.scl((float)this.bodyScale);
        super.drawCell(unit);
        Draw.scl();
    }
}

