/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.entity;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.math.geom.Vector;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import java.util.HashMap;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Leg;
import mindustry.entities.abilities.Ability;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Itemsc;
import mindustry.gen.LegsUnit;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.InverseKinematics;
import mindustry.graphics.Trail;
import mindustry.input.InputHandler;
import mindustry.type.Item;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.storage.CoreBlock;
import subvoyage.content.SvUnits;
import subvoyage.type.unit.custom.HydromechState;
import subvoyage.type.unit.custom.HydromechStateStats;
import subvoyage.type.unit.type.HydromechUnitType;

public class HydromechUnitEntity
extends LegsUnit {
    protected transient Trail tleft;
    protected transient Color trailColor;
    protected transient Trail tright;
    public float liquidedSmooth = 0.0f;
    public HashMap<WeaponMount, Float> mountSpeedMultiplier = new HashMap();

    public int classId() {
        return SvUnits.mapHMech;
    }

    protected HydromechUnitEntity() {
        this.tleft = new Trail(1);
        this.trailColor = Blocks.water.mapColor.cpy().mul(1.5f);
        this.tright = new Trail(1);
    }

    public boolean sameStateAs(HydromechState state) {
        if (state == HydromechState.ANY) {
            return true;
        }
        return this.getState() == state;
    }

    public HydromechState getState() {
        return this.liquidedSmooth() > 0.5f ? HydromechState.WATER : HydromechState.GROUND;
    }

    public HydromechStateStats getStatState() {
        return ((HydromechUnitType)this.type).states.get((Object)this.getState());
    }

    public HydromechStateStats getStatState(HydromechStateStats def) {
        return ((HydromechUnitType)this.type).states.getOrDefault((Object)this.getState(), def);
    }

    public static HydromechUnitEntity create() {
        return new HydromechUnitEntity();
    }

    public void controlWeapons(boolean rotate, boolean shoot) {
        super.controlWeapons(rotate, shoot);
    }

    public Vec2 legOffset(Vec2 out, int index) {
        float v = Mathf.lerp((float)this.unliquidedSmooth(), (float)(this.isOnLiquid() ? 0.0f : 1.0f), (float)(Time.delta / 60.0f));
        return (Vec2)super.legOffset(out, index).times((Vector)new Vec2(v, v));
    }

    public float liquidedSmooth() {
        return this.liquidedSmooth;
    }

    public float unliquidedSmooth() {
        return 1.0f - this.liquidedSmooth();
    }

    public boolean isOnLiquid() {
        return this.floorOn().isLiquid && this.tileOn().block().isAir();
    }

    public void damage(float amount) {
        super.damage(amount * this.getStatState().inwardsDamageMul);
    }

    public boolean canDrown() {
        return false;
    }

    public void updateDrowning() {
    }

    public void draw() {
        this.type.draw((Unit)this);
        if (this.isOnLiquid()) {
            float z = Draw.z();
            Draw.z((float)20.0f);
            Floor floor = this.tileOn() == null ? Blocks.air.asFloor() : this.tileOn().floor();
            Color color = Tmp.c1.set(floor.mapColor.equals((Object)Color.black) ? Blocks.water.mapColor : floor.mapColor).mul(1.5f);
            this.trailColor.lerp(color, Mathf.clamp((float)(Time.delta * 0.04f)));
            this.tleft.draw(this.trailColor, this.type.trailScl);
            this.tright.draw(this.trailColor, this.type.trailScl);
            Draw.z((float)z);
        }
    }

    public float legAngle(int index) {
        float v = super.legAngle(index);
        return Mathf.lerp((float)v, (float)((180.0f + v) % 360.0f), (float)this.liquidedSmooth());
    }

    public void update() {
        float cy;
        float cx;
        float range;
        float offset;
        if (!Vars.net.client() || this.isLocal()) {
            offset = this.x;
            range = this.y;
            this.move(this.vel.x * Time.delta, this.vel.y * Time.delta);
            if (Mathf.equal((float)offset, (float)this.x)) {
                this.vel.x = 0.0f;
            }
            if (Mathf.equal((float)range, (float)this.y)) {
                this.vel.y = 0.0f;
            }
            this.vel.scl(Math.max(1.0f - this.drag * Time.delta, 0.0f));
        }
        if (this.type.bounded) {
            offset = 0.0f;
            range = 0.0f;
            cx = Vars.world.unitHeight();
            cy = Vars.world.unitWidth();
            if (Vars.state.rules.limitMapArea && !this.team.isAI()) {
                offset = Vars.state.rules.limitY * 8;
                range = Vars.state.rules.limitX * 8;
                cx = (float)(Vars.state.rules.limitHeight * 8) + offset;
                cy = (float)(Vars.state.rules.limitWidth * 8) + range;
            }
            if (!Vars.net.client() || this.isLocal()) {
                float dx = 0.0f;
                float dy = 0.0f;
                if (this.x < range) {
                    dx += -(this.x - range) / 30.0f;
                }
                if (this.y < offset) {
                    dy += -(this.y - offset) / 30.0f;
                }
                if (this.x > cy) {
                    dx -= (this.x - cy) / 30.0f;
                }
                if (this.y > cx) {
                    dy -= (this.y - cx) / 30.0f;
                }
                this.velAddNet(dx * Time.delta, dy * Time.delta);
            }
            if (this.isGrounded()) {
                this.x = Mathf.clamp((float)this.x, (float)range, (float)(cy - 8.0f));
                this.y = Mathf.clamp((float)this.y, (float)offset, (float)(cx - 8.0f));
            }
            if (this.x < -250.0f + range || this.y < -250.0f + offset || this.x >= cy + 250.0f || this.y >= cx + 250.0f) {
                this.kill();
            }
        }
        this.updateBuildLogic();
        Floor floor = this.floorOn();
        if (this.isFlying() != this.wasFlying) {
            if (this.wasFlying && this.tileOn() != null) {
                Fx.unitLand.at(this.x, this.y, this.floorOn().isLiquid ? 1.0f : 0.5f, this.tileOn().floor().mapColor);
            }
            this.wasFlying = this.isFlying();
        }
        this.updateDrowning();
        this.hitTime -= Time.delta / 9.0f;
        this.stack.amount = Mathf.clamp((int)this.stack.amount, (int)0, (int)this.itemCapacity());
        this.itemTime = Mathf.lerpDelta((float)this.itemTime, (float)Mathf.num((boolean)this.hasItem()), (float)0.05f);
        if (Mathf.dst((float)this.deltaX(), (float)this.deltaY()) > 0.001f) {
            this.baseRotation = Angles.moveToward((float)this.baseRotation, (float)Mathf.angle((float)this.deltaX(), (float)this.deltaY()), (float)this.type.rotateSpeed);
        }
        if (this.type.lockLegBase) {
            this.baseRotation = this.rotation;
        }
        offset = this.type.legLength;
        if (this.legs.length != this.type.legCount) {
            this.resetLegs();
        }
        range = this.type.legSpeed;
        int div = Math.max(this.legs.length / this.type.legGroupSize, 2);
        this.moveSpace = offset / 1.6f / ((float)div / 2.0f) * this.type.legMoveSpace;
        this.totalLength += this.type.legContinuousMove ? this.type.speed * this.speedMultiplier * Time.delta : Mathf.dst((float)this.deltaX(), (float)this.deltaY());
        cy = this.moveSpace * 0.85f * this.type.legForwardScl;
        boolean moving = this.moving();
        Vec2 moveOffset = !moving ? Tmp.v4.setZero() : Tmp.v4.trns(Angles.angle((float)this.deltaX(), (float)this.deltaY()), cy);
        moveOffset = this.curMoveOffset.lerpDelta((Position)moveOffset, 0.1f);
        this.lastDeepFloor = null;
        int deeps = 0;
        for (int i = 0; i < this.legs.length; ++i) {
            boolean backLeg;
            float dstRot = this.legAngle(i);
            Vec2 baseOffset = this.legOffset(Tmp.v5, i).add(this.x, this.y);
            Leg l = this.legs[i];
            l.joint.sub(baseOffset).clampLength(this.type.legMinLength * offset / 2.0f, this.type.legMaxLength * offset / 2.0f).add(baseOffset);
            l.base.sub(baseOffset).clampLength(this.type.legMinLength * offset, this.type.legMaxLength * offset).add(baseOffset);
            float stageF = (this.totalLength + (float)i * this.type.legPairOffset) / this.moveSpace;
            int stage = (int)stageF;
            int group = stage % div;
            boolean move = i % div == group;
            boolean side = i < this.legs.length / 2;
            boolean bl = backLeg = Math.abs((float)i + 0.5f - (float)this.legs.length / 2.0f) <= 0.501f;
            if (backLeg && this.type.flipBackLegs) {
                boolean bl2 = side = !side;
            }
            if (this.type.flipLegSide) {
                side = !side;
            }
            l.moving = move;
            l.stage = moving ? stageF % 1.0f : Mathf.lerpDelta((float)l.stage, (float)0.0f, (float)0.1f);
            floor = Vars.world.floorWorld(l.base.x, l.base.y);
            if (floor.isDeep()) {
                ++deeps;
                this.lastDeepFloor = floor;
            }
            if (l.group != group && this.liquidedSmooth() < 0.5f) {
                if (!(move || !moving && this.type.legContinuousMove || i % div != l.group)) {
                    if (!Vars.headless && !this.inFogTo(Vars.player.team())) {
                        if (!floor.isLiquid) {
                            Fx.unitLandSmall.at(l.base.x, l.base.y, this.type.rippleScale, floor.mapColor);
                        }
                        if (this.type.stepShake > 0.0f) {
                            Effect.shake((float)this.type.stepShake, (float)this.type.stepShake, (Position)l.base);
                        }
                    }
                    if (this.type.legSplashDamage > 0.0f) {
                        Damage.damage((Team)this.team, (float)l.base.x, (float)l.base.y, (float)this.type.legSplashRange, (float)(this.type.legSplashDamage * Vars.state.rules.unitDamage(this.team)), (boolean)false, (boolean)true);
                    }
                }
                l.group = group;
            }
            Vec2 legDest = Tmp.v1.trns(dstRot, offset * this.type.legLengthScl).add(baseOffset).add(moveOffset);
            Vec2 jointDest = Tmp.v2;
            InverseKinematics.solve((float)(offset / 2.0f), (float)(offset / 2.0f), (Vec2)Tmp.v6.set(l.base).sub(baseOffset), (boolean)side, (Vec2)jointDest);
            jointDest.add(baseOffset);
            Tmp.v6.set(baseOffset).lerp(l.base, 0.5f);
            if (move) {
                float moveFract = stageF % 1.0f;
                l.base.lerpDelta((Position)legDest, moveFract);
                l.joint.lerpDelta((Position)jointDest, moveFract / 2.0f);
            }
            l.joint.lerpDelta((Position)jointDest, range / 4.0f);
            l.joint.sub(baseOffset).clampLength(this.type.legMinLength * offset / 2.0f, this.type.legMaxLength * offset / 2.0f).add(baseOffset);
            l.base.sub(baseOffset).clampLength(this.type.legMinLength * offset, this.type.legMaxLength * offset).add(baseOffset);
        }
        if (deeps != this.legs.length || !this.floorOn().isDeep()) {
            this.lastDeepFloor = null;
        }
        if (this.mineTile != null) {
            CoreBlock.CoreBuild core = this.closestCore();
            Item item = this.getMineResult(this.mineTile);
            if (core != null && item != null && !this.acceptsItem(item) && this.within((Position)core, 220.0f) && !this.offloadImmediately() && (div = core.acceptStack(this.item(), this.stack().amount, (Teamc)this)) > 0) {
                Call.transferItemTo((Unit)this, (Item)this.item(), (int)div, (float)(this.mineTile.worldx() + Mathf.range((float)4.0f)), (float)(this.mineTile.worldy() + Mathf.range((float)4.0f)), (Building)core);
                this.clearItem();
            }
            if (!(Vars.net.client() && !this.isLocal() || this.validMine(this.mineTile))) {
                this.mineTile = null;
                this.mineTimer = 0.0f;
            } else if (this.mining() && item != null) {
                this.mineTimer += Time.delta * this.type.mineSpeed;
                if (Mathf.chance((double)(0.06 * (double)Time.delta))) {
                    Fx.pulverizeSmall.at(this.mineTile.worldx() + Mathf.range((float)4.0f), this.mineTile.worldy() + Mathf.range((float)4.0f), 0.0f, item.color);
                }
                float f = this.type.mineHardnessScaling ? (float)item.hardness * 15.0f : 15.0f;
                if (this.mineTimer >= 50.0f + f) {
                    this.mineTimer = 0.0f;
                    if (Vars.state.rules.sector != null && this.team() == Vars.state.rules.defaultTeam) {
                        Vars.state.rules.sector.info.handleProduction(item, 1);
                    }
                    if (core != null && this.within((Position)core, 220.0f) && core.acceptStack(item, 1, (Teamc)this) == 1 && this.offloadImmediately()) {
                        if (this.item() == item && !Vars.net.client()) {
                            this.addItem(item);
                        }
                        Call.transferItemTo((Unit)this, (Item)item, (int)1, (float)(this.mineTile.worldx() + Mathf.range((float)4.0f)), (float)(this.mineTile.worldy() + Mathf.range((float)4.0f)), (Building)core);
                    } else if (this.acceptsItem(item)) {
                        InputHandler.transferItemToUnit((Item)item, (float)(this.mineTile.worldx() + Mathf.range((float)4.0f)), (float)(this.mineTile.worldy() + Mathf.range((float)4.0f)), (Itemsc)this);
                    } else {
                        this.mineTile = null;
                        this.mineTimer = 0.0f;
                    }
                }
                if (!Vars.headless) {
                    Vars.control.sound.loop(this.type.mineSound, (Position)this, this.type.mineSoundVolume);
                }
            }
        }
        this.shieldAlpha -= Time.delta / 15.0f;
        if (this.shieldAlpha < 0.0f) {
            this.shieldAlpha = 0.0f;
        }
        floor = this.floorOn();
        if (this.isGrounded() && !this.type.hovering) {
            this.apply(floor.status, floor.statusDuration);
        }
        this.applied.clear();
        this.dragMultiplier = 1.0f;
        this.buildSpeedMultiplier = 1.0f;
        this.reloadMultiplier = 1.0f;
        this.healthMultiplier = 1.0f;
        this.damageMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        this.disarmed = false;
        if (!this.statuses.isEmpty()) {
            int index = 0;
            while (index < this.statuses.size) {
                StatusEntry entry = (StatusEntry)this.statuses.get(index++);
                entry.time = Math.max(entry.time - Time.delta, 0.0f);
                if (entry.effect != null && (!(entry.time <= 0.0f) || entry.effect.permanent)) {
                    this.applied.set((int)entry.effect.id);
                    this.speedMultiplier *= entry.effect.speedMultiplier;
                    this.healthMultiplier *= entry.effect.healthMultiplier;
                    this.damageMultiplier *= entry.effect.damageMultiplier;
                    this.reloadMultiplier *= entry.effect.reloadMultiplier;
                    this.buildSpeedMultiplier *= entry.effect.buildSpeedMultiplier;
                    this.dragMultiplier *= entry.effect.dragMultiplier;
                    this.disarmed |= entry.effect.disarm;
                    entry.effect.update((Unit)this, entry.time);
                    continue;
                }
                Pools.free((Object)entry);
                this.statuses.remove(--index);
            }
        }
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
        this.type.update((Unit)this);
        if (this.wasHealed && this.healTime <= -1.0f) {
            this.healTime = 1.0f;
        }
        this.healTime -= Time.delta / 20.0f;
        this.wasHealed = false;
        if (this.team.isOnlyAI() && Vars.state.isCampaign() && Vars.state.getSector().isCaptured()) {
            this.kill();
        }
        if (!Vars.headless && this.type.loopSound != Sounds.none) {
            Vars.control.sound.loop(this.type.loopSound, (Position)this, this.type.loopSoundVolume);
        }
        if (!this.type.supportsEnv(Vars.state.rules.env) && !this.dead) {
            Call.unitEnvDeath((Unit)this);
            this.team.data().updateCount(this.type, -1);
        }
        if (Vars.state.rules.unitAmmo && this.ammo < (float)this.type.ammoCapacity - 1.0E-4f) {
            this.resupplyTime += Time.delta;
            if (this.resupplyTime > 10.0f) {
                this.type.ammoType.resupply((Unit)this);
                this.resupplyTime = 0.0f;
            }
        }
        for (Ability a : this.abilities) {
            a.update((Unit)this);
        }
        if (this.trail != null) {
            this.trail.length = this.type.trailLength;
            offset = this.type.useEngineElevation ? this.elevation : 1.0f;
            range = this.type.engineOffset / 2.0f + this.type.engineOffset / 2.0f * offset;
            cx = this.x + Angles.trnsx((float)(this.rotation + 180.0f), (float)range);
            cy = this.y + Angles.trnsy((float)(this.rotation + 180.0f), (float)range);
            this.trail.update(cx, cy);
        }
        this.drag = this.type.drag * (this.isGrounded() ? this.floorOn().dragMultiplier : 1.0f) * this.dragMultiplier * Vars.state.rules.dragMultiplier;
        if (this.team != Vars.state.rules.waveTeam && Vars.state.hasSpawns() && (!Vars.net.client() || this.isLocal()) && this.hittable()) {
            offset = Vars.state.rules.dropZoneRadius + this.hitSize / 2.0f + 1.0f;
            for (Tile spawn : Vars.spawner.getSpawns()) {
                if (!this.within(spawn.worldx(), spawn.worldy(), offset)) continue;
                this.velAddNet(Tmp.v1.set((Position)this).sub(spawn.worldx(), spawn.worldy()).setLength(1.1f - this.dst((Position)spawn) / offset).scl(0.45f * Time.delta));
            }
        }
        if (this.dead || this.health <= 0.0f) {
            this.drag = 0.01f;
            if (Mathf.chanceDelta((double)0.1)) {
                Tmp.v1.rnd(Mathf.range((float)this.hitSize));
                this.type.fallEffect.at(this.x + Tmp.v1.x, this.y + Tmp.v1.y);
            }
            if (Mathf.chanceDelta((double)0.2)) {
                offset = this.type.engineOffset / 2.0f + this.type.engineOffset / 2.0f * this.elevation;
                range = Mathf.range((float)this.type.engineSize);
                this.type.fallEngineEffect.at(this.x + Angles.trnsx((float)(this.rotation + 180.0f), (float)offset) + Mathf.range((float)range), this.y + Angles.trnsy((float)(this.rotation + 180.0f), (float)offset) + Mathf.range((float)range), Mathf.random());
            }
            this.elevation -= this.type.fallSpeed * Time.delta;
            if (this.isGrounded() || this.health <= -this.maxHealth) {
                Call.unitDestroy((int)this.id);
            }
        }
        Tile tile = this.tileOn();
        floor = this.floorOn();
        if (tile != null && this.isGrounded() && !this.type.hovering) {
            if (tile.build != null) {
                tile.build.unitOn((Unit)this);
            }
            if (floor.damageTaken > 0.0f) {
                this.damageContinuous(floor.damageTaken);
            }
        }
        if (tile != null && !this.canPassOn()) {
            if (this.type.canBoost) {
                this.elevation = 1.0f;
            } else if (!Vars.net.client()) {
                this.kill();
            }
        }
        if (!Vars.net.client() && !this.dead) {
            this.controller.updateUnit();
        }
        if (!this.controller.isValidController()) {
            this.resetController();
        }
        if (this.spawnedByCore && !this.isPlayer() && !this.dead) {
            Call.unitDespawn((Unit)this);
        }
        for (WeaponMount mount : this.mounts) {
            mount.weapon.update((Unit)this, mount);
        }
        for (int i = 0; i < 2; ++i) {
            Trail t = i == 0 ? this.tleft : this.tright;
            t.length = this.type.trailLength;
            int sign = i == 0 ? -1 : 1;
            cx = Angles.trnsx((float)(this.rotation - 90.0f), (float)(this.type.waveTrailX * (float)sign), (float)this.type.waveTrailY) + this.x;
            cy = Angles.trnsy((float)(this.rotation - 90.0f), (float)(this.type.waveTrailX * (float)sign), (float)this.type.waveTrailY) + this.y;
            t.update(cx, cy, this.isOnLiquid() ? 0.5f : 0.0f);
        }
        this.liquidedSmooth = Mathf.lerp((float)this.liquidedSmooth, (float)(this.isOnLiquid() ? 1.0f : 0.0f), (float)(Time.delta / 10.0f));
    }

    public float speed() {
        float base = this.getStatState().speed;
        for (float v : this.mountSpeedMultiplier.values()) {
            base *= v;
        }
        return base;
    }
}

