/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.unit.ai;

import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Time;
import java.util.HashMap;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.units.WeaponMount;
import mindustry.game.Team;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.world.meta.BlockFlag;
import subvoyage.core.draw.SvFx;
import subvoyage.type.block.storage.core.OffloadCore;

public class OffloadDemolisherAI
extends FlyingAI {
    public HashMap<Unit, Float> timePassed = new HashMap();

    public void updateMovement() {
        this.unloadPayloads();
        if (this.target == null) {
            this.timePassed.put(this.unit, Float.valueOf(this.timePassed.getOrDefault(this.unit, Float.valueOf(0.0f)).floatValue() + Time.delta));
        }
        if (this.timePassed.getOrDefault(this.unit, Float.valueOf(0.0f)).floatValue() > 900.0f) {
            this.unit.kill();
        }
        if (this.target != null && this.unit.hasWeapons()) {
            if (this.unit.type.circleTarget) {
                this.circleAttack(120.0f);
                for (WeaponMount mount : this.unit.mounts) {
                    Teamc teamc;
                    if (!(mount.warmup >= mount.weapon.minWarmup - 0.1f) || !((teamc = this.target) instanceof OffloadCore.OffloadCoreBuilding)) continue;
                    OffloadCore.OffloadCoreBuilding of = (OffloadCore.OffloadCoreBuilding)teamc;
                    if (of.tryBreakLayer()) {
                        Sounds.pulseBlast.at(this.unit.x, this.unit.y);
                        new MultiEffect(new Effect[]{Fx.drillSteam, SvFx.decoderWave}).create(this.unit.x, this.unit.y, 0.0f, Pal.accent, (Object)Float.valueOf(64.0f));
                        SvFx.point.create(this.unit.x, this.unit.y, 0.0f, Pal.redLight, new Object());
                        SvFx.point.create(of.x, of.y, 0.0f, Pal.redLight, new Object());
                        SvFx.beam.create(of.x, of.y, 0.0f, Pal.redLight, (Object)new float[]{this.unit.x, this.unit.y, of.x, of.y});
                    }
                    this.unit.kill();
                    mount.warmup = 0.0f;
                }
                this.unit.lookAt((Position)this.target);
            } else {
                this.moveTo((Position)this.target, this.unit.type.range * 0.8f);
                this.unit.lookAt((Position)this.target);
            }
        }
    }

    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        return this.findMainTarget(x, y, range, air, ground);
    }

    public Teamc findMainTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc core = this.targetFlag(x, y, BlockFlag.core, true, true);
        return core;
    }

    public Teamc targetFlag(float x, float y, BlockFlag flag, boolean enemy, boolean offload) {
        if (this.unit.team == Team.derelict) {
            return null;
        }
        Seq found = enemy ? Vars.indexer.getEnemy(this.unit.team, flag) : Vars.indexer.getFlagged(this.unit.team, flag);
        found.select(e -> !offload || e instanceof OffloadCore.OffloadCoreBuilding);
        return (Teamc)Geometry.findClosest((float)x, (float)y, (Iterable)found);
    }
}

