/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.bullet;

import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;

public class DecayingBulletType
extends BasicBulletType {
    public float dmgReduction;

    public DecayingBulletType(float speed, float dmg, float damageReduction) {
        super(speed, dmg);
        this.dmgReduction = damageReduction;
    }

    public void update(Bullet b) {
        super.update(b);
        if (b.time >= Time.delta / 60.0f) {
            b.damage -= this.dmgReduction / b.lifetime * Time.delta;
        }
        if (b.damage <= 0.0f) {
            b.absorb();
        }
    }

    public void drawTrail(Bullet b) {
        if (this.trailLength > 0 && b.trail != null) {
            float z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            b.trail.draw(this.trailColor, this.trailWidth * Mathf.clamp((float)(b.fout() * 2.0f)));
            Draw.z((float)z);
        }
    }
}

