/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.power.node;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.math.geom.Vector;
import arc.struct.IntSeq;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.core.UI;
import mindustry.core.World;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.power.PowerBlock;
import mindustry.world.blocks.power.PowerGraph;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.modules.PowerModule;
import subvoyage.core.draw.SvPal;
import subvoyage.type.block.power.node.PowerBubbleNode;

public class PowerBubbleMerger
extends PowerBlock {
    protected static BuildPlan otherReq;
    protected static float maxRange;
    public static int maxNodes;
    public float range;
    public boolean autolink = true;
    public boolean drawRange = true;
    public float laserScale = 0.25f;
    public Color laserColor1 = Color.white;
    public Color laserColor2 = SvPal.powerLaser;
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public TextureRegion shadowRegion;
    public TextureRegion outlineRegion;
    public DrawBlock drawer = new DrawDefault();
    protected static final ObjectSet<PowerGraph> graphs;
    public TextureRegion ship;
    public TextureRegion shipWave;
    public int transferTime = 60;
    protected static int returnInt;
    public static int nodeCount;

    public void load() {
        super.load();
        this.drawer.load((Block)this);
        this.laser = Core.atlas.find(this.name + "-laser", "laser");
        this.laserEnd = Core.atlas.find(this.name + "-laser-end", "laser-end");
        this.ship = Core.atlas.find(this.name + "-ship");
        this.shipWave = Core.atlas.find(this.name + "-ship-wave");
        this.outlineRegion = Core.atlas.find(this.name + "-ship-outline");
        this.shadowRegion = Core.atlas.find(this.name + "-ship");
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public void init() {
        super.init();
        this.clipSize = Math.max(this.clipSize, this.range * 8.0f);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public PowerBubbleMerger(String name) {
        super(name);
        this.configurable = true;
        this.consumesPower = false;
        this.outputsPower = false;
        this.canOverdrive = true;
        this.swapDiagonalPlacement = true;
        this.schematicPriority = -10;
        this.drawDisabled = true;
        this.destructible = true;
        this.config(Integer.class, (entity, value) -> {
            boolean valid;
            PowerModule power = entity.power;
            Building other = Vars.world.build(value.intValue());
            boolean contains = power.links.contains(value.intValue());
            boolean bl = valid = other != null && other.power != null;
            if (other == null) {
                return;
            }
            if (!(other.block instanceof PowerBubbleNode)) {
                return;
            }
            if (contains) {
                power.links.removeValue(value.intValue());
                if (valid) {
                    other.power.links.removeValue(entity.pos());
                }
                PowerGraph newGraph = new PowerGraph();
                newGraph.reflow(entity);
                if (valid && other.power.graph != newGraph) {
                    PowerGraph og = new PowerGraph();
                    og.reflow(other);
                }
            } else if (this.linkValid((Building)entity, other) && valid && power.links.size < maxNodes) {
                power.links.addUnique(other.pos());
                if (other.team == entity.team) {
                    other.power.links.addUnique(entity.pos());
                }
                power.graph.addGraph(other.power.graph);
            }
        });
        this.config(Point2[].class, (tile, value) -> {
            IntSeq old = new IntSeq(tile.power.links);
            for (int i = 0; i < old.size; ++i) {
                ((Cons2)this.configurations.get(Integer.class)).get(tile, (Object)old.get(i));
            }
            for (Point2 p : value) {
                ((Cons2)this.configurations.get(Integer.class)).get(tile, (Object)Point2.pack((int)(p.x + tile.tileX()), (int)(p.y + tile.tileY())));
            }
        });
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> this.overlaps(Vars.world.tile(point.x, point.y), Vars.world.tile(other.x, other.y)));
    }

    public void setBars() {
        super.setBars();
        this.addBar("power", entity -> {
            PowerGraph g = entity.power.graph;
            return new Bar(() -> Core.bundle.format("bar.powerbalance", new Object[]{(g.getPowerBalance() >= 0.0f ? "+" : "") + UI.formatAmount((long)((long)(g.getPowerBalance() * 60.0f)))}), () -> Pal.powerBar, () -> Mathf.clamp((float)(entity.power.graph.getLastPowerProduced() / entity.power.graph.getLastPowerNeeded())));
        });
        this.addBar("batteries", PowerNode.makeBatteryBalance());
        this.addBar("connections", entity -> new Bar(() -> Core.bundle.format("bar.powerlines", new Object[]{entity.power.links.size, maxNodes}), () -> Pal.items, () -> (float)entity.power.links.size / (float)maxNodes));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.powerRange, this.range, StatUnit.blocks);
        this.stats.add(Stat.powerConnections, (float)maxNodes, StatUnit.none);
    }

    public void drawLaser(float x1, float y1, float x2, float y2, int size1, int size2) {
        float angle1 = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float vx = Mathf.cosDeg((float)angle1);
        float vy = Mathf.sinDeg((float)angle1);
        float len1 = (float)(size1 * 8) / 2.0f - 1.5f;
        float len2 = (float)(size2 * 8) / 2.0f - 1.5f;
        Drawf.laser((TextureRegion)this.laser, (TextureRegion)this.laserEnd, (float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)this.laserScale);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null || !this.autolink) {
            return;
        }
        Lines.stroke((float)1.0f);
        Draw.color((Color)Pal.placing);
        Drawf.circles((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)(this.range * 8.0f));
        this.getNodeLinks(tile, tile.block(), Vars.player.team(), (Cons<Building>)((Cons)other -> {
            Draw.color((Color)this.laserColor1, (float)(Renderer.laserOpacity * 0.5f));
            this.drawLaser((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, other.x, other.y, this.size, other.block.size);
            Drawf.square((float)other.x, (float)other.y, (float)((float)(other.block.size * 8) / 2.0f + 2.0f), (Color)Pal.place);
        }));
    }

    public void drawPlanConfigTop(BuildPlan plan, Eachable<BuildPlan> list) {
        Point2[] point2Array = plan.config;
        if (point2Array instanceof Point2[]) {
            Point2[] ps = point2Array;
            this.setupColor(1.0f);
            for (Point2 point : ps) {
                int px = plan.x + point.x;
                int py = plan.y + point.y;
                otherReq = null;
                list.each(other -> {
                    if (other.block != null && px >= other.x - (other.block.size - 1) / 2 && py >= other.y - (other.block.size - 1) / 2 && px <= other.x + other.block.size / 2 && py <= other.y + other.block.size / 2 && other != plan && other.block.hasPower) {
                        otherReq = other;
                    }
                });
                if (otherReq == null || PowerBubbleMerger.otherReq.block == null) continue;
                this.drawLaser(plan.drawx(), plan.drawy(), otherReq.drawx(), otherReq.drawy(), this.size, PowerBubbleMerger.otherReq.block.size);
            }
            Draw.color();
        }
    }

    protected void setupColor(float satisfaction) {
        Draw.color((Color)this.laserColor1, (Color)this.laserColor2, (float)((1.0f - satisfaction) * 0.86f + Mathf.absin((float)3.0f, (float)0.1f)));
        Draw.alpha((float)Renderer.laserOpacity);
    }

    public void getNodeLinks(Tile tile, Block block, Team team, Cons<Building> others) {
        if (!this.autolink) {
            return;
        }
        Boolf valid = other -> other != null && other.tile != tile && other.block.connectedPower && other.power != null && other.block instanceof PowerBubbleNode && this.overlaps((float)(tile.x * 8) + this.offset, (float)(tile.y * 8) + this.offset, other.tile, this.range * 8.0f) && other.team == team && !graphs.contains((Object)other.power.graph) && !PowerBubbleMerger.insulated(tile, other.tile) && !Structs.contains((Object[])Edges.getEdges((int)this.size), p -> {
            Tile t = Vars.world.tile(tile.x + p.x, tile.y + p.y);
            return t != null && t.build == other;
        });
        tempBuilds.clear();
        graphs.clear();
        for (Point2 p : Edges.getEdges((int)this.size)) {
            Tile other2 = tile.nearby(p);
            if (other2 == null || other2.team() != team || other2.build == null || other2.build.power == null) continue;
            graphs.add((Object)other2.build.power.graph);
        }
        if (tile.build != null && tile.build.power != null) {
            graphs.add((Object)tile.build.power.graph);
        }
        float worldRange = this.range * 8.0f;
        QuadTree tree = team.data().buildingTree;
        if (tree != null) {
            tree.intersect(tile.worldx() - worldRange, tile.worldy() - worldRange, worldRange * 2.0f, worldRange * 2.0f, build -> {
                if (valid.get(build) && !tempBuilds.contains(build)) {
                    tempBuilds.add(build);
                }
            });
        }
        tempBuilds.sort((a, b) -> {
            int type = -Boolean.compare(a.block instanceof PowerBubbleNode, b.block instanceof PowerBubbleNode);
            if (type != 0) {
                return type;
            }
            return Float.compare(a.dst2((Position)tile), b.dst2((Position)tile));
        });
        returnInt = 0;
        tempBuilds.each(valid, t -> {
            if (returnInt++ < maxNodes) {
                graphs.add((Object)t.power.graph);
                others.get(t);
            }
        });
    }

    public boolean linkValid(Building tile, Building link) {
        return this.linkValid(tile, link, true);
    }

    public boolean linkValid(Building tile, Building link, boolean checkMaxNodes) {
        block5: {
            block4: {
                if (!(tile != link && link != null && link.block instanceof PowerBubbleNode && link.block.hasPower && link.block.connectedPower && tile.team == link.team)) {
                    return false;
                }
                if (this.overlaps(tile, link, this.range * 8.0f)) break block4;
                Block block = link.block;
                if (!(block instanceof PowerBubbleNode)) break block5;
                PowerBubbleNode powerBubbleNode = (PowerBubbleNode)block;
            }
            return true;
        }
        return false;
    }

    public static boolean insulated(Tile tile, Tile other) {
        return PowerBubbleMerger.insulated(tile.x, tile.y, other.x, other.y);
    }

    public static boolean insulated(Building tile, Building other) {
        return PowerBubbleMerger.insulated(tile.tileX(), tile.tileY(), other.tileX(), other.tileY());
    }

    public static boolean insulated(int x, int y, int x2, int y2) {
        return World.raycast((int)x, (int)y, (int)x2, (int)y2, (wx, wy) -> {
            Building tile = Vars.world.build(wx, wy);
            return tile != null && tile.isInsulated();
        });
    }

    private void drawLaser(float x1, float y1, float x2, float y2, int size1, int size2, float scl, float bloomIntensity) {
        float angle1 = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float vx = Mathf.cosDeg((float)angle1);
        float vy = Mathf.sinDeg((float)angle1);
        float len1 = (float)(size1 * 8) / 2.0f;
        float len2 = (float)(size2 * 8) / 2.0f;
        float layer = Draw.z();
        scl = Math.max(scl + bloomIntensity / 2.0f, 0.2f);
        Draw.z((float)35.0f);
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.stroke((float)(8.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.color();
        Lines.stroke((float)(3.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(2.0f * scl + Mathf.cos((float)(Time.time + 5.0f), (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(2.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.z((float)layer);
    }

    protected static boolean overlaps(float srcx, float srcy, Tile other, Block otherBlock, float range) {
        return Intersector.overlaps((Circle)Tmp.cr1.set(srcx, srcy, range), (Rect)Tmp.r1.setCentered(other.worldx() + otherBlock.offset, other.worldy() + otherBlock.offset, (float)(otherBlock.size * 8), (float)(otherBlock.size * 8)));
    }

    protected boolean overlaps(float srcx, float srcy, Tile other, float range) {
        return Intersector.overlaps((Circle)Tmp.cr1.set(srcx, srcy, range), (Rect)other.getHitbox(Tmp.r1));
    }

    protected boolean overlaps(Building src, Building other, float range) {
        return this.overlaps(src.x, src.y, other.tile, range);
    }

    protected boolean overlaps(Tile src, Tile other, float range) {
        return this.overlaps(src.drawx(), src.drawy(), other, range);
    }

    public boolean overlaps(@Nullable Tile src, @Nullable Tile other) {
        if (src == null || other == null) {
            return true;
        }
        return Intersector.overlaps((Circle)Tmp.cr1.set(src.worldx() + this.offset, src.worldy() + this.offset, this.range * 8.0f), (Rect)Tmp.r1.setSize((float)(this.size * 8)).setCenter(other.worldx() + this.offset, other.worldy() + this.offset));
    }

    static {
        maxNodes = 3;
        graphs = new ObjectSet();
        nodeCount = 0;
    }

    public class EnergyDockBuild
    extends Building {
        int worldChanges = 0;
        boolean upd = false;

        public void created() {
            if (PowerBubbleMerger.this.autolink && PowerBubbleMerger.this.range > maxRange) {
                maxRange = PowerBubbleMerger.this.range;
            }
            nodeCount = 0;
            Vars.world.tiles.eachTile(e -> {
                if (e.block() instanceof PowerBubbleMerger) {
                    ++nodeCount;
                }
            });
            super.created();
        }

        public void updateTile() {
            super.updateTile();
            if (this.upd) {
                PowerBubbleMerger.this.getNodeLinks(this.tile, this.tile.block(), this.team, (Cons<Building>)((Cons)other -> {
                    if (!this.power.links.contains(other.pos())) {
                        this.configureAny(other.pos());
                    }
                }));
            }
            if (this.worldChanges != Vars.world.tileChanges) {
                this.worldChanges = Vars.world.tileChanges;
                this.upd = true;
            }
        }

        public void placed() {
            if (Vars.net.client() || this.power.links.size > 0) {
                return;
            }
            PowerBubbleMerger.this.getNodeLinks(this.tile, this.tile.block(), this.team, (Cons<Building>)((Cons)other -> {
                if (!this.power.links.contains(other.pos())) {
                    this.configureAny(other.pos());
                }
            }));
        }

        public void remove() {
            super.remove();
            nodeCount = 0;
            Vars.world.tiles.eachTile(e -> {
                if (e.block() instanceof PowerBubbleMerger) {
                    ++nodeCount;
                }
            });
        }

        public void dropped() {
            nodeCount = 0;
            Vars.world.tiles.eachTile(e -> {
                if (e.block() instanceof PowerBubbleMerger) {
                    ++nodeCount;
                }
            });
            this.power.links.clear();
            this.updatePowerGraph();
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (PowerBubbleMerger.this.linkValid(this, other)) {
                this.configure(other.pos());
                return false;
            }
            if (this == other) {
                if (other.power.links.size == 0) {
                    Seq points = new Seq();
                    PowerBubbleMerger.this.getNodeLinks(this.tile, this.tile.block(), this.team, (Cons<Building>)((Cons)link -> {
                        if (!PowerBubbleMerger.insulated(this, link) && points.size < maxNodes) {
                            points.add((Object)new Point2(link.tileX() - this.tile.x, link.tileY() - this.tile.y));
                        }
                    }));
                    this.configure(points.toArray(Point2.class));
                } else {
                    this.configure(new Point2[0]);
                }
                this.deselect();
                return false;
            }
            return true;
        }

        public void drawSelect() {
            super.drawSelect();
            if (!PowerBubbleMerger.this.drawRange) {
                return;
            }
            Lines.stroke((float)1.0f);
            Draw.color((Color)Pal.accent);
            Drawf.circles((float)this.x, (float)this.y, (float)(PowerBubbleMerger.this.range * 8.0f));
            Draw.reset();
        }

        public void drawConfigure() {
            Drawf.circles((float)this.x, (float)this.y, (float)((float)(this.tile.block().size * 8) / 2.0f + 1.0f + Mathf.absin((float)Time.time, (float)4.0f, (float)1.0f)));
            if (PowerBubbleMerger.this.drawRange) {
                Drawf.circles((float)this.x, (float)this.y, (float)(PowerBubbleMerger.this.range * 8.0f));
                int x = (int)((float)this.tile.x - PowerBubbleMerger.this.range - 2.0f);
                while ((float)x <= (float)this.tile.x + PowerBubbleMerger.this.range + 2.0f) {
                    int y = (int)((float)this.tile.y - PowerBubbleMerger.this.range - 2.0f);
                    while ((float)y <= (float)this.tile.y + PowerBubbleMerger.this.range + 2.0f) {
                        boolean linked;
                        Building link = Vars.world.build(x, y);
                        if (link != this && PowerBubbleMerger.this.linkValid(this, link, false) && (linked = this.linked(link))) {
                            Drawf.square((float)link.x, (float)link.y, (float)((float)(link.block.size * 8) / 2.0f + 1.0f), (Color)Pal.place);
                        }
                        ++y;
                    }
                    ++x;
                }
                Draw.reset();
            } else {
                this.power.links.each(i -> {
                    Building link = Vars.world.build(i);
                    if (link != null && PowerBubbleMerger.this.linkValid(this, link, false)) {
                        Drawf.square((float)link.x, (float)link.y, (float)((float)(link.block.size * 8) / 2.0f + 1.0f), (Color)Pal.place);
                    }
                });
            }
        }

        public void draw() {
            PowerBubbleMerger.this.drawer.draw((Building)this);
            if (Mathf.zero((float)Renderer.laserOpacity) || this.isPayload()) {
                return;
            }
            Draw.z((float)70.0f);
            PowerBubbleMerger.this.setupColor(this.power.graph.getSatisfaction());
            for (int i = 0; i < this.power.links.size; ++i) {
                Building link = Vars.world.build(this.power.links.get(i));
                if (!PowerBubbleMerger.this.linkValid(this, link)) continue;
                PowerBubbleMerger.this.setupColor(this.power.graph.getSatisfaction());
                Draw.color((Color)SvPal.powerLaser);
                PowerBubbleMerger.this.drawLaser(this.x, this.y, link.x, link.y, PowerBubbleMerger.this.size, link.block.size, 0.5f, 0.0f);
            }
            Draw.reset();
        }

        public void drawShadow(float originX, float originY, float rot, float vectorRotMultiplier, float alpha) {
            ((Vec2)Tmp.v2.set(this.x, this.y).nor().times((Vector)new Vec2(vectorRotMultiplier, vectorRotMultiplier))).rotate(rot);
            float e = Mathf.clamp((float)1.0f, (float)-1.0f, (float)1.0f) * 1.0f;
            float x = originX - 12.0f * e;
            float y = originY - 13.0f * e;
            Floor floor = Vars.world.floorWorld(x, y);
            float dest = floor.canShadow ? alpha : 0.0f;
            Draw.color((Color)Pal.shadow, (float)(Pal.shadow.a * dest));
            Draw.rect((TextureRegion)PowerBubbleMerger.this.shadowRegion, (float)x, (float)y, (float)rot);
            Draw.color();
        }

        public void drawOutline(float originX, float originY, float rot, float vectorRotMultiplier, float alpha) {
            ((Vec2)Tmp.v2.set(this.x, this.y).nor().times((Vector)new Vec2(vectorRotMultiplier, vectorRotMultiplier))).rotate(rot);
            Draw.reset();
            if (Core.atlas.isFound(PowerBubbleMerger.this.outlineRegion)) {
                Draw.color((Color)Pal.darkOutline, (float)alpha);
                Draw.rect((TextureRegion)PowerBubbleMerger.this.outlineRegion, (float)originX, (float)originY, (float)rot);
                Draw.reset();
            }
        }

        public void drawEngine(float originX, float originY, float x, float y, float scale, float radius, float alpha, float rot, float vectorRotMultiplier, Color color, Color engineColorInner) {
            ((Vec2)Tmp.v2.set(x, y).nor().times((Vector)new Vec2(vectorRotMultiplier, vectorRotMultiplier))).rotate(rot);
            float ex = Tmp.v2.x;
            float ey = Tmp.v2.y;
            Draw.color((Color)color);
            Draw.alpha((float)alpha);
            Fill.circle((float)(originX + ex), (float)(originY + ey), (float)((radius + Mathf.absin((float)Time.time, (float)2.0f, (float)(radius / 4.0f))) * scale));
            Draw.color((Color)engineColorInner);
            Draw.alpha((float)alpha);
            Fill.circle((float)(originX + ex), (float)(originY + ey), (float)((radius + Mathf.absin((float)Time.time, (float)2.0f, (float)(radius / 4.0f))) / 2.0f * scale));
            Draw.alpha((float)1.0f);
        }

        public void drawLight() {
            super.drawLight();
            PowerBubbleMerger.this.drawer.drawLight((Building)this);
        }

        protected boolean linked(Building other) {
            return this.power.links.contains(other.pos());
        }

        public Point2[] config() {
            Point2[] out = new Point2[this.power.links.size];
            for (int i = 0; i < out.length; ++i) {
                out[i] = Point2.unpack((int)this.power.links.get(i)).sub((int)this.tile.x, (int)this.tile.y);
            }
            return out;
        }
    }
}

