/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.payload;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.struct.Queue;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.PayloadMassDriver;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import subvoyage.Subvoyage;
import subvoyage.core.draw.SvFx;
import subvoyage.util.SvMath;

public class PayloadLaunchPad
extends PayloadBlock {
    public float range = 160.0f;
    public float launchTime = 20.0f;
    public float transportationTime = 60.0f;
    public float maxPayloadSize = 3.0f;
    public Effect shootEffect = Fx.shootBig2;
    public Effect smokeEffect = Fx.shootPayloadDriver;
    public Effect receiveEffect = Fx.payloadReceive;
    public Sound shootSound = Sounds.shootBig;
    public float shake = 3.0f;
    public TextureRegion rocketRegion;
    public TextureRegion rocketOpenRegion;
    public TextureRegion side1Region;
    public TextureRegion side2Region;

    public void load() {
        super.load();
        this.topRegion = Core.atlas.find(this.name + "-top", Subvoyage.ID + "-factory-top-" + this.size + this.regionSuffix);
        this.outRegion = Core.atlas.find(this.name + "-out", Subvoyage.ID + "-factory-out-" + this.size + this.regionSuffix);
        this.inRegion = Core.atlas.find(this.name + "-in", Subvoyage.ID + "-factory-in-" + this.size + this.regionSuffix);
        this.side1Region = Core.atlas.find(this.name + "-side1");
        this.side2Region = Core.atlas.find(this.name + "-side2", this.side1Region);
        this.rocketRegion = Core.atlas.find(this.name + "-rocket");
        this.rocketOpenRegion = Core.atlas.find(this.name + "-rocket-open");
        SvFx.payloadLaunchPadRocketLaunch.lifetime = SvFx.payloadLaunchPadRocketLand.lifetime = this.transportationTime / 3.0f;
    }

    public PayloadLaunchPad(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.regionSuffix = "-fortified";
        this.configurable = true;
        this.hasPower = true;
        this.outlineIcon = true;
        this.sync = true;
        this.outputsPayload = true;
        this.rotateDraw = false;
        this.regionRotated1 = 1;
        this.rotate = true;
        this.group = BlockGroup.units;
        this.config(Point2.class, (tile, point) -> {
            tile.link = Point2.pack((int)(point.x + tile.tileX()), (int)(point.y + tile.tileY()));
        });
        this.config(Integer.class, (tile, point) -> {
            tile.link = point;
        });
    }

    public void init() {
        super.init();
        this.updateClipRadius(this.range);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.payloadCapacity, StatValues.squared((float)this.maxPayloadSize, (StatUnit)StatUnit.blocksSquared));
        this.stats.add(Stat.reload, 60.0f / (this.launchTime + this.transportationTime), StatUnit.perSecond);
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.outRegion, this.region, this.side1Region, this.rocketRegion};
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        super.drawPlanRegion(plan, list);
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.rocketRegion, (float)plan.drawx(), (float)plan.drawy());
    }

    public void setBars() {
        super.setBars();
        this.addBar("progress", build -> new Bar(() -> Core.bundle.get("bar.launchcooldown"), () -> Pal.ammo, () -> Mathf.clamp((float)build.launchWarmup)));
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashSquare((Color)Pal.accent, (float)(x * 8), (float)(y * 8), (float)(this.range * 2.0f));
        if (!Vars.control.input.config.isShown()) {
            return;
        }
        Building selected = Vars.control.input.config.getSelected();
        if (selected == null || selected.block != this || !SvMath.withinSquare(selected, x * 8, y * 8, this.range)) {
            return;
        }
        float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
        Tmp.v1.set((float)(x * 8) + this.offset, (float)(y * 8) + this.offset).sub(selected.x, selected.y).limit(((float)this.size / 2.0f + 1.0f) * 8.0f + sin + 0.5f);
        float x2 = (float)(x * 8) - Tmp.v1.x;
        float y2 = (float)(y * 8) - Tmp.v1.y;
        float x1 = selected.x + Tmp.v1.x;
        float y1 = selected.y + Tmp.v1.y;
        int segs = (int)(selected.dst((float)(x * 8), (float)(y * 8)) / 8.0f);
        Lines.stroke((float)4.0f, (Color)Pal.gray);
        Lines.dashLine((float)x1, (float)y1, (float)x2, (float)y2, (int)segs);
        Lines.stroke((float)2.0f, (Color)Pal.placing);
        Lines.dashLine((float)x1, (float)y1, (float)x2, (float)y2, (int)segs);
        Draw.reset();
    }

    public class PayloadLaunchPadBuild
    extends PayloadBlock.PayloadBlockBuild<Payload> {
        public int link;
        public PayloadLaunchPadBuild lastOther;
        public PayloadMassDriver.PayloadDriverState state;
        public Queue<Building> waitingShooters;
        public float launchWarmup;
        public boolean loaded;
        public boolean inProgress;
        public float inProgressSmooth;
        public Payload cachePayload;

        public PayloadLaunchPadBuild() {
            super((PayloadBlock)PayloadLaunchPad.this);
            this.link = -1;
            this.state = PayloadMassDriver.PayloadDriverState.idle;
            this.waitingShooters = new Queue();
            this.launchWarmup = 0.0f;
            this.inProgress = false;
            this.inProgressSmooth = 1.0f;
        }

        public void updateTile() {
            boolean hasLink;
            Building link;
            block21: {
                block22: {
                    Building current;
                    super.updateTile();
                    link = Vars.world.build(this.link);
                    hasLink = this.linkValid();
                    this.inProgressSmooth = Mathf.lerp((float)this.inProgressSmooth, (float)(this.inProgress || this.payload == null ? 1.0f : 0.0f), (float)(Time.delta / 20.0f));
                    if (hasLink) {
                        this.link = link.pos();
                    }
                    if ((current = this.currentShooter()) == null) break block21;
                    if (!(current instanceof PayloadLaunchPadBuild)) break block22;
                    PayloadLaunchPadBuild entity = (PayloadLaunchPadBuild)current;
                    if (current.isValid() && entity.efficiency > 0.0f && entity.block == this.block && entity.link == this.pos() && SvMath.withinSquare(current, (Building)this, PayloadLaunchPad.this.range)) break block21;
                }
                this.waitingShooters.removeFirst();
            }
            if (this.state == PayloadMassDriver.PayloadDriverState.idle) {
                if (!this.waitingShooters.isEmpty() && this.payload == null) {
                    this.state = PayloadMassDriver.PayloadDriverState.accepting;
                } else if (hasLink) {
                    this.state = PayloadMassDriver.PayloadDriverState.shooting;
                }
            }
            if ((this.state == PayloadMassDriver.PayloadDriverState.idle || this.state == PayloadMassDriver.PayloadDriverState.accepting) && this.payload != null) {
                this.moveOutPayload();
            }
            if (this.state == PayloadMassDriver.PayloadDriverState.accepting) {
                if (this.currentShooter() == null || this.payload != null) {
                    this.state = PayloadMassDriver.PayloadDriverState.idle;
                }
            } else if (this.state == PayloadMassDriver.PayloadDriverState.shooting) {
                if (!hasLink || !this.waitingShooters.isEmpty() && this.payload == null) {
                    this.state = PayloadMassDriver.PayloadDriverState.idle;
                    return;
                }
                boolean movedOut = false;
                if (this.loaded) {
                    movedOut = true;
                } else if (this.moveInPayload()) {
                    this.loaded = true;
                }
                if (movedOut && this.payload != null && link.getPayload() == null) {
                    PayloadLaunchPadBuild other = (PayloadLaunchPadBuild)link;
                    if (!other.waitingShooters.contains((Object)this)) {
                        other.waitingShooters.addLast((Object)this);
                    }
                    this.launchWarmup += this.edelta() / PayloadLaunchPad.this.launchTime;
                    other.launchWarmup += this.edelta() / PayloadLaunchPad.this.launchTime;
                    if (other.currentShooter() == this && other.state == PayloadMassDriver.PayloadDriverState.accepting && other.launchWarmup >= 0.99f && !this.inProgress && other.launchWarmup >= 1.0f) {
                        Payload pay;
                        PayloadLaunchPad.this.shootEffect.at(this.x, this.y, 0.0f);
                        PayloadLaunchPad.this.smokeEffect.at(this.x, this.y, 0.0f);
                        this.inProgress = true;
                        Effect.shake((float)PayloadLaunchPad.this.shake, (float)PayloadLaunchPad.this.shake, (Position)this);
                        this.cachePayload = pay = this.payload;
                        this.payload = null;
                        Sounds.release.at(this.x, this.y, 0.5f, 0.05f);
                        Fx.launchPod.create(this.x, this.y, 0.0f, Pal.accent, new Object());
                        SvFx.payloadLaunchPadRocketLaunch.create(this.x, this.y, 0.0f, Pal.accent, new Object());
                        Time.run((float)(PayloadLaunchPad.this.transportationTime / 3.0f * 2.0f), () -> {
                            if (!Vars.state.isGame()) {
                                return;
                            }
                            this.loaded = false;
                            this.state = PayloadMassDriver.PayloadDriverState.idle;
                            SvFx.payloadLaunchPadRocketLand.create(other.x, other.y, 0.0f, Pal.accent, new Object());
                        });
                        Time.run((float)PayloadLaunchPad.this.transportationTime, () -> {
                            if (!Vars.state.isGame()) {
                                return;
                            }
                            other.handlePayload((Building)this, pay);
                            other.lastOther = this;
                            other.loaded = true;
                            other.updatePayload();
                            Sounds.missileLaunch.at(this.x, this.y, 0.5f, 0.05f);
                            this.inProgress = false;
                            if (other.waitingShooters.size != 0 && other.waitingShooters.first() == this) {
                                other.waitingShooters.removeFirst();
                            }
                            other.state = PayloadMassDriver.PayloadDriverState.idle;
                            other.launchWarmup = 0.0f;
                            this.launchWarmup = 0.0f;
                            this.cachePayload = null;
                            Fx.launchPod.create(other.x, other.y, 0.0f, Pal.accent, new Object());
                        });
                    }
                }
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)PayloadLaunchPad.this.outRegion, (float)this.x, (float)this.y, (float)((float)this.rotation * 90.0f));
            super.draw();
            Draw.rect((TextureRegion)(this.rotation >= 2 ? PayloadLaunchPad.this.side2Region : PayloadLaunchPad.this.side1Region), (float)this.x, (float)this.y, (float)((float)this.rotation * 90.0f));
            Draw.rect((TextureRegion)PayloadLaunchPad.this.topRegion, (float)this.x, (float)this.y);
            Draw.z((float)35.0f);
            Draw.alpha((float)(1.0f - this.inProgressSmooth));
            if (this.payload != null) {
                Draw.scl((float)(8.0f / this.payload.size()));
                Draw.rect((TextureRegion)this.payload.icon(), (float)this.x, (float)this.y);
                Draw.scl();
            }
            Draw.rect((TextureRegion)PayloadLaunchPad.this.rocketOpenRegion, (float)this.x, (float)this.y);
            Draw.reset();
        }

        public Building currentShooter() {
            return this.waitingShooters.isEmpty() ? null : (Building)this.waitingShooters.first();
        }

        public void updatePayload() {
            if (this.payload != null) {
                if (this.loaded) {
                    this.payload.set(this.x, this.y, this.payRotation);
                } else {
                    this.payload.set(this.x + this.payVector.x, this.y + this.payVector.y, this.payRotation);
                }
            }
        }

        public void drawConfigure() {
            float sin = Mathf.absin((float)Time.time, (float)6.0f, (float)1.0f);
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Drawf.circles((float)this.x, (float)this.y, (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.accent);
            for (Building shooter : this.waitingShooters) {
                Drawf.circles((float)shooter.x, (float)shooter.y, (float)(((float)this.tile.block().size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)shooter.x, (float)shooter.y, (float)this.x, (float)this.y, (float)((float)(PayloadLaunchPad.this.size * 8) + sin), (float)(4.0f + sin), (Color)Pal.place);
            }
            if (this.linkValid()) {
                Building target = Vars.world.build(this.link);
                Drawf.circles((float)target.x, (float)target.y, (float)(((float)target.block.size / 2.0f + 1.0f) * 8.0f + sin - 2.0f), (Color)Pal.place);
                Drawf.arrow((float)this.x, (float)this.y, (float)target.x, (float)target.y, (float)((float)(PayloadLaunchPad.this.size * 8) + sin), (float)(4.0f + sin));
            }
            Drawf.dashSquare((Color)Pal.accent, (float)this.x, (float)this.y, (float)(PayloadLaunchPad.this.range * 2.0f));
        }

        public boolean acceptPayload(Building source, Payload payload) {
            return super.acceptPayload(source, payload) && payload.size() <= PayloadLaunchPad.this.maxPayloadSize * 8.0f && this.launchWarmup <= 0.0f;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean linkValid() {
            if (this.link == -1) return false;
            Building building = Vars.world.build(this.link);
            if (!(building instanceof PayloadLaunchPadBuild)) return false;
            PayloadLaunchPadBuild other = (PayloadLaunchPadBuild)building;
            if (other.block != this.block) return false;
            if (other.team != this.team) return false;
            if (!SvMath.withinSquare((Building)other, (Building)this, PayloadLaunchPad.this.range)) return false;
            return true;
        }

        public Point2 config() {
            if (this.tile == null) {
                return null;
            }
            return Point2.unpack((int)this.link).sub((int)this.tile.x, (int)this.tile.y);
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                if (this.link == -1) {
                    this.deselect();
                }
                this.configure(-1);
                return false;
            }
            if (this.link == other.pos()) {
                this.configure(-1);
                return false;
            }
            if (other.block instanceof PayloadLaunchPad && SvMath.withinSquare(other, (Building)this, PayloadLaunchPad.this.range) && other.team == this.team) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.link);
            write.b((int)((byte)this.state.ordinal()));
            write.bool(this.loaded);
            Payload.write((Payload)this.cachePayload, (Writes)write);
        }

        public void read(Reads read, byte revision) {
            Payload pay;
            super.read(read, revision);
            this.link = read.i();
            this.state = PayloadMassDriver.PayloadDriverState.all[read.b()];
            if (revision >= 1) {
                this.loaded = read.bool();
            }
            if (revision >= 2 && (pay = Payload.read((Reads)read)) != null) {
                this.payload = pay;
            }
        }
    }
}

