/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser;

import arc.graphics.Color;
import arc.math.Mathf;
import java.util.LinkedHashMap;
import subvoyage.core.draw.SvPal;

public class LaserUtil {
    public static LinkedHashMap<Float, Color> laserPowerColors = new LinkedHashMap();

    public static Color getLaserColor(float power) {
        if (power <= 0.05f) {
            return laserPowerColors.get(Float.valueOf(0.0f));
        }
        Object[] i_color = new Object[]{0, laserPowerColors.get(Float.valueOf(0.0f)), false};
        laserPowerColors.forEach((f, c) -> {
            if ((Integer)i_color[0] == 0 || ((Boolean)i_color[2]).booleanValue()) {
                i_color[0] = (Integer)i_color[0] + 1;
                return;
            }
            if (power == f.floatValue()) {
                i_color[1] = c;
            }
            if (power < f.floatValue()) {
                Color prevColor = (Color)laserPowerColors.values().toArray()[(Integer)i_color[0] - 1];
                float prevValue = ((Float)laserPowerColors.keySet().toArray()[(Integer)i_color[0] - 1]).floatValue();
                float progress = (power - prevValue) / (f.floatValue() - prevValue);
                float[] hsv = prevColor.toHsv(new float[3]);
                float[] hsv2 = c.toHsv(new float[3]);
                float[] newHsv = new float[]{Mathf.lerp((float)hsv[0], (float)hsv2[0], (float)progress), Mathf.lerp((float)hsv[1], (float)hsv2[1], (float)progress), Mathf.lerp((float)hsv[2], (float)hsv2[2], (float)progress)};
                i_color[1] = prevColor.cpy().fromHsv(newHsv);
                i_color[2] = true;
            }
            i_color[0] = (Integer)i_color[0] + 1;
        });
        return (Color)i_color[1];
    }

    static {
        laserPowerColors.put(Float.valueOf(0.0f), SvPal.laserRed.cpy().mul(0.2f));
        laserPowerColors.put(Float.valueOf(10.0f), SvPal.laserRed);
        laserPowerColors.put(Float.valueOf(100.0f), SvPal.laserGreen);
        laserPowerColors.put(Float.valueOf(270.0f), SvPal.laserBlue);
        laserPowerColors.put(Float.valueOf(500.0f), SvPal.laserViolet);
        laserPowerColors.put(Float.valueOf(1000.0f), Color.valueOf((String)"D8D1FF"));
    }
}

