/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.laser;

import arc.Core;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import java.util.ArrayList;
import java.util.List;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Block;
import subvoyage.core.SvSettings;
import subvoyage.type.block.laser.LaserBuild;
import subvoyage.type.block.laser.LaserGraph;
import subvoyage.type.block.laser.LaserLink;
import subvoyage.type.block.laser.LaserUtil;

public interface LaserBlock {
    public short inputRange();

    public short outputRange();

    public byte maxSuppliers();

    public IntSeq inputs();

    public IntSeq outputs();

    default public void drawLinks(Block block, int x, int y, int rotation, boolean drawInputs, boolean drawOutputs) {
        List<LaserLink> links = LaserGraph.getLinks(x, y, rotation, block);
        LaserLink[] consLinks = new LaserLink[4];
        LaserLink[] suppLinks = new LaserLink[4];
        int supps = Seq.with(links).count(f -> f.isSupplier);
        for (LaserLink link : links) {
            Building other = link.object;
            if (link.isConsumer) {
                Drawf.square((float)other.x, (float)other.y, (float)((float)other.block.size / 2.0f * 8.0f), (float)0.0f, (Color)Pal.techBlue);
                consLinks[link.side] = link;
            }
            if (!link.isSupplier) continue;
            Drawf.square((float)other.x, (float)other.y, (float)((float)other.block.size / 2.0f * 8.0f), (float)0.0f, (Color)(supps > this.maxSuppliers() ? Pal.remove : Pal.heal));
            suppLinks[link.side] = link;
        }
        ArrayList selfInputs = new ArrayList();
        ArrayList selfOutputs = new ArrayList();
        this.inputs().each(input -> selfInputs.add((input + rotation) % 4));
        this.outputs().each(output -> selfOutputs.add((output + rotation) % 4));
        for (int i = 0; i < 4; ++i) {
            Point2 dir = Geometry.d4[i];
            int dx = dir.x;
            int dy = dir.y;
            float inputLen = this.inputRange();
            float outputLen = this.outputRange();
            LaserLink consLink = consLinks[i];
            LaserLink suppLink = suppLinks[i];
            if (!selfInputs.contains(i) || !drawInputs) {
                inputLen = 0.0f;
            }
            if (!selfOutputs.contains(i) || !drawOutputs) {
                outputLen = 0.0f;
            }
            if (consLink != null) {
                outputLen = (float)consLink.len - (float)consLink.object.block.size / 2.0f;
            }
            if (suppLink != null) {
                inputLen = (float)suppLink.len - (float)suppLink.object.block.size / 2.0f;
            }
            Drawf.dashLine((Color)Pal.techBlue, (float)((float)(x * 8) + (float)(dx * block.size) / 2.0f * 8.0f), (float)((float)(y * 8) + (float)(dy * block.size) / 2.0f * 8.0f), (float)((float)(x * 8) + (float)(dx * block.size) / 2.0f * 8.0f + outputLen * 8.0f * (float)dx), (float)((float)(y * 8) + (float)(dy * block.size) / 2.0f * 8.0f + outputLen * 8.0f * (float)dy));
            Drawf.dashLine((Color)Pal.heal, (float)((float)(x * 8) + (float)(dx * block.size) / 2.0f * 8.0f), (float)((float)(y * 8) + (float)(dy * block.size) / 2.0f * 8.0f), (float)((float)(x * 8) + (float)(dx * block.size) / 2.0f * 8.0f + inputLen * 8.0f * (float)dx), (float)((float)(y * 8) + (float)(dy * block.size) / 2.0f * 8.0f + inputLen * 8.0f * (float)dy));
            if (selfOutputs.contains(i) && drawOutputs) {
                Drawf.arrow((float)((float)(x * 8) + (float)(dx * block.size) / 2.0f * 8.0f), (float)((float)(y * 8) + (float)(dy * block.size) / 2.0f * 8.0f), (float)(x * 8 + dx * block.size * 8), (float)(y * 8 + dy * block.size * 8), (float)((float)block.size / 4.0f * 8.0f), (float)((float)block.size / 4.0f * 8.0f), (Color)Pal.techBlue);
            }
            if (!selfInputs.contains(i) || !drawInputs) continue;
            Drawf.arrow((float)(x * 8 + dx * block.size * 8), (float)(y * 8 + dy * block.size * 8), (float)((float)(x * 8) - (float)(dx * block.size) / 2.0f * 8.0f), (float)((float)(y * 8) - (float)(dy * block.size) / 2.0f * 8.0f), (float)((float)block.size / 4.0f * 8.0f), (float)((float)block.size / 4.0f * 8.0f), (Color)(supps > this.maxSuppliers() ? Pal.remove : Pal.heal));
        }
    }

    default public <T extends Building> Func<T, Bar> bar() {
        return build -> {
            if (build instanceof LaserBuild) {
                LaserBuild lb = (LaserBuild)build;
                return new Bar(() -> Core.bundle.format("bar.sv_laser_power", new Object[]{Strings.fixed((float)lb.rawLaser(), (int)1)}), () -> LaserUtil.getLaserColor(lb.laser()), () -> Mathf.clamp((float)lb.rawLaser()));
            }
            return new Bar();
        };
    }

    default public void drawLaser(float x1, float y1, float x2, float y2, int size1, int size2, float power, float scl, float bloomIntensity) {
        if (SvSettings.bool("laser-shaders") && (double)power > 0.99) {
            this.drawLaserShadered(x1, y1, x2, y2, size1, size2, scl, bloomIntensity);
            return;
        }
        float angle1 = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float vx = Mathf.cosDeg((float)angle1);
        float vy = Mathf.sinDeg((float)angle1);
        float len1 = (float)(size1 * 8) / 2.0f;
        float len2 = (float)(size2 * 8) / 2.0f;
        float layer = Draw.z();
        scl = Math.max(scl + bloomIntensity / 2.0f, 0.2f);
        Draw.z((float)35.0f);
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.stroke((float)(8.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.color((Color)Draw.getColor().cpy().lerp(Color.white, 0.3f));
        Lines.stroke((float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(4.5f * scl + Mathf.cos((float)(Time.time + 5.0f), (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(4.5f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.color();
        Lines.stroke((float)(4.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(3.0f * scl + Mathf.cos((float)(Time.time + 5.0f), (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(3.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.z((float)layer);
    }

    default public void drawLaserShadered(float x1, float y1, float x2, float y2, int size1, int size2, float scl, float bloomIntensity) {
        float angle1 = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float vx = Mathf.cosDeg((float)angle1);
        float vy = Mathf.sinDeg((float)angle1);
        float len1 = (float)(size1 * 8) / 2.0f;
        float len2 = (float)(size2 * 8) / 2.0f;
        float layer = Draw.z();
        scl = Math.max(scl + bloomIntensity / 2.0f, 0.2f) * 0.5f;
        Draw.z((float)72.2f);
        Fill.circle((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Fill.circle((float)(x2 - vx * len2), (float)(y2 - vy * len2), (float)(6.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.stroke((float)(8.0f * scl + Mathf.cos((float)Time.time, (float)10.0f, (float)0.5f) * (scl - 0.2f)));
        Lines.line((float)(x1 + vx * len1), (float)(y1 + vy * len1), (float)(x2 - vx * len2), (float)(y2 - vy * len2));
        Draw.z((float)layer);
    }
}

