/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Rand;
import arc.util.Time;
import mindustry.world.Block;
import mindustry.world.Tile;

public class TreeBlock
extends Block {
    public float shadowOffset = -3.0f;
    public float shadowAlpha = 0.6f;
    public int lobesMin = 7;
    public int lobesMax = 7;
    public float sclMin = 30.0f;
    public float sclMax = 50.0f;
    public float magMin = 5.0f;
    public float magMax = 15.0f;
    public float timeRange = 40.0f;
    public float spread = 0.0f;
    static Rand rand = new Rand();

    public TreeBlock(String name) {
        super(name);
        this.solid = true;
        this.clipSize = 90.0f;
        this.customShadow = true;
    }

    public void init() {
        super.init();
        this.hasShadow = true;
    }

    public void drawBase(Tile tile) {
        rand.setSeed((long)tile.pos());
        float offset = rand.random(180.0f);
        rand.random(this.lobesMin, this.lobesMax);
        int lobes = 1;
        for (int i = 0; i < lobes; ++i) {
            float ba = (float)i / (float)lobes * 360.0f + offset + rand.range(this.spread);
            float angle = ba + Mathf.sin((float)(Time.time + rand.random(0.0f, this.timeRange)), (float)rand.random(this.sclMin, this.sclMax), (float)rand.random(this.magMin, this.magMax));
            Draw.z((float)69.0f);
            Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)this.shadowAlpha);
            Draw.rect((TextureRegion)(this.variants > 0 ? this.variantShadowRegions[Mathf.randomSeed((long)tile.pos(), (int)0, (int)Math.max(0, this.variantShadowRegions.length - 1))] : this.customShadowRegion), (float)(tile.worldx() + this.shadowOffset), (float)(tile.worldy() + this.shadowOffset), (float)angle);
            Draw.color();
            Draw.z((float)71.0f);
            Draw.rect((TextureRegion)(this.variants > 0 ? this.variantRegions[Mathf.randomSeed((long)tile.pos(), (int)0, (int)Math.max(0, this.variantRegions.length - 1))] : this.region), (float)tile.worldx(), (float)tile.worldy(), (float)angle);
        }
    }

    public void drawShadow(Tile tile) {
    }

    public TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.variants == 0) {
            textureRegionArray = super.icons();
        } else {
            TextureRegion[] textureRegionArray2 = new TextureRegion[1];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[0] = Core.atlas.find(this.name + "1");
        }
        return textureRegionArray;
    }
}

