/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.distribution;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Renderer;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ItemBridge;

public class ItemPipeline
extends ItemBridge {
    public ItemPipeline(String name) {
        super(name);
        this.swapDiagonalPlacement = true;
        this.bridgeWidth = 8.0f;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        this.drawOverlay((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation);
        Tile link = this.findLink(x, y);
        for (int i = 0; i < 4; ++i) {
            Drawf.dashLine((Color)Pal.placing, (float)((float)(x * 8) + (float)Geometry.d4[i].x * 6.0f), (float)((float)(y * 8) + (float)Geometry.d4[i].y * 6.0f), (float)(x * 8 + Geometry.d4[i].x * this.range * 8), (float)(y * 8 + Geometry.d4[i].y * this.range * 8));
        }
        Draw.reset();
        Draw.color((Color)Pal.placing);
        Lines.stroke((float)1.0f);
        if (link != null && Math.abs(link.x - x) + Math.abs(link.y - y) > 1) {
            byte rot = link.absoluteRelativeTo(x, y);
            float w = link.x == x ? 8 : Math.abs(link.x - x) * 8 - 8;
            float h = link.y == y ? 8 : Math.abs(link.y - y) * 8 - 8;
            Lines.dashLine((float)x, (float)y, (float)link.x, (float)link.y, (int)6);
        }
        Draw.reset();
    }

    public boolean positionsValid(int x1, int y1, int x2, int y2) {
        return Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2) <= (float)this.range;
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> Mathf.dst((float)point.x, (float)point.y, (float)other.x, (float)other.y) <= (float)this.range);
    }

    public class ItemPipelineBuild
    extends ItemBridge.ItemBridgeBuild {
        public ItemPipelineBuild() {
            super((ItemBridge)ItemPipeline.this);
        }

        public void draw() {
            Draw.rect((TextureRegion)ItemPipeline.this.region, (float)this.x, (float)this.y, (float)this.drawrot());
            this.drawTeamTop();
            Draw.z((float)70.0f);
            Tile other = Vars.world.tile(this.link);
            if (!ItemPipeline.this.linkValid(this.tile, other)) {
                Draw.rect((TextureRegion)ItemPipeline.this.arrowRegion, (float)this.x, (float)this.y, (float)0.0f);
                Draw.rect((TextureRegion)ItemPipeline.this.arrowRegion, (float)this.x, (float)this.y, (float)90.0f);
                Draw.rect((TextureRegion)ItemPipeline.this.arrowRegion, (float)this.x, (float)this.y, (float)180.0f);
                Draw.rect((TextureRegion)ItemPipeline.this.arrowRegion, (float)this.x, (float)this.y, (float)270.0f);
                return;
            }
            if (Mathf.zero((float)Renderer.bridgeOpacity)) {
                return;
            }
            byte i = this.relativeTo(other.x, other.y);
            if (ItemPipeline.this.pulse) {
                Draw.color((Color)Color.white, (Color)Color.black, (float)Mathf.absin((float)Time.time, (float)6.0f, (float)0.07f));
            }
            float warmup = ItemPipeline.this.hasPower ? this.warmup : 1.0f;
            Draw.alpha((float)((ItemPipeline.this.fadeIn ? Math.max(warmup, 0.25f) : 1.0f) * Renderer.bridgeOpacity));
            Draw.rect((TextureRegion)ItemPipeline.this.endRegion, (float)this.x, (float)this.y, (float)(Angles.angle((float)other.drawx(), (float)other.drawy(), (float)this.x, (float)this.y) - 90.0f));
            Draw.rect((TextureRegion)ItemPipeline.this.endRegion, (float)other.drawx(), (float)other.drawy(), (float)(Angles.angle((float)this.x, (float)this.y, (float)other.drawx(), (float)other.drawy()) - 90.0f));
            Lines.stroke((float)ItemPipeline.this.bridgeWidth);
            Tmp.v1.set(this.x, this.y).sub(other.worldx(), other.worldy()).setLength(4.0f).scl(-1.0f);
            Lines.line((TextureRegion)ItemPipeline.this.bridgeRegion, (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)(other.worldx() - Tmp.v1.x), (float)(other.worldy() - Tmp.v1.y), (boolean)false);
            int dist = Math.max(Math.abs(other.x - this.tile.x), Math.abs(other.y - this.tile.y)) - 1;
            Draw.color();
            Draw.rect((TextureRegion)ItemPipeline.this.arrowRegion, (float)this.x, (float)this.y, (float)Angles.angle((float)this.x, (float)this.y, (float)other.drawx(), (float)other.drawy()));
            Draw.reset();
        }

        protected boolean checkDump(Building to) {
            return true;
        }
    }
}

