/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.defense;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import subvoyage.core.SvSettings;

public class PowerWall
extends Wall {
    public TextureRegion corner1;
    public TextureRegion corner2;
    public TextureRegion corner3;
    public TextureRegion corner4;
    public TextureRegion light;
    public TextureRegion dark;
    public TextureRegion corner;
    public TextureRegion decal;
    public TextureRegion decalLarge;
    public TextureRegion decalDark;
    public TextureRegion decalLargeDark;
    public TextureRegion full;
    public float hitGenerationTime = 0.0f;
    public float hitPower_pt = 0.0f;

    public PowerWall(String name) {
        super(name);
        this.conductivePower = true;
        this.hasPower = true;
        this.outputsPower = true;
        this.consumesPower = false;
        this.sync = true;
        this.update = true;
    }

    public void setBars() {
        super.setBars();
        if (this.hasPower && this.outputsPower) {
            this.addBar("power", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", new Object[]{Strings.fixed((float)(entity.getPowerProduction() * 60.0f * entity.timeScale()), (int)1)}), () -> Pal.powerBar, () -> entity.warmup));
        }
    }

    public void load() {
        super.load();
        this.corner1 = this.txr("1");
        this.corner2 = this.txr("2");
        this.corner3 = this.txr("3");
        this.corner4 = this.txr("4");
        this.light = this.txr("light");
        this.dark = this.txr("dark");
        this.corner = this.txr("corner");
        this.decal = this.txr("decal");
        this.decalLarge = this.txr("decal-large");
        this.decalDark = this.txr("decal-dark");
        this.decalLargeDark = this.txr("decal-large-dark");
        this.full = this.txr("full");
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.basePowerGeneration, this.hitPower_pt * 60.0f, StatUnit.powerSecond);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.full};
    }

    public TextureRegion txr(String name, String def) {
        return this.txr(name, this.txr(def));
    }

    public TextureRegion txr(String name, TextureRegion def) {
        return Core.atlas.find(this.name + "-" + name, def);
    }

    public TextureRegion txr(String name) {
        return Core.atlas.find(this.name + "-" + name);
    }

    public class PhosphideWallBuild
    extends Wall.WallBuild {
        float generationTime;
        float warmup;

        public PhosphideWallBuild() {
            super((Wall)PowerWall.this);
            this.generationTime = 0.0f;
            this.warmup = 0.0f;
        }

        public void drawSelf() {
            if (!SvSettings.wallTiling()) {
                Draw.rect((TextureRegion)PowerWall.this.full, (float)this.x, (float)this.y, (float)this.drawrot());
                return;
            }
            Draw.rect((TextureRegion)PowerWall.this.region, (float)this.x, (float)this.y, (float)this.drawrot());
            boolean right = this.nearbyWall(0);
            boolean top = this.nearbyWall(1);
            boolean left = this.nearbyWall(2);
            boolean bot = this.nearbyWall(3);
            boolean upLeft = !top && !left;
            boolean upRight = !top && !right;
            boolean botLeft = !bot && !left;
            boolean botRight = !bot && !right;
            for (int i = 0; i < 4; ++i) {
                if (!this.nearbyCornerWall(i)) continue;
                Draw.rect((TextureRegion)PowerWall.this.corner, (float)this.x, (float)this.y, (float)((float)i * 90.0f - 90.0f));
            }
            this.drawShadeAndDecal(right, 0, !botRight && !upRight);
            this.drawShadeAndDecal(top, 1, !upLeft && !upRight);
            this.drawShadeAndDecal(left, 2, !botLeft && !upLeft);
            this.drawShadeAndDecal(bot, 3, !botLeft && !botRight);
            if (upLeft) {
                Draw.rect((TextureRegion)PowerWall.this.corner1, (float)this.x, (float)this.y, (float)0.0f);
            }
            if (upRight) {
                Draw.rect((TextureRegion)PowerWall.this.corner2, (float)this.x, (float)this.y, (float)0.0f);
            }
            if (botRight) {
                Draw.rect((TextureRegion)PowerWall.this.corner3, (float)this.x, (float)this.y, (float)0.0f);
            }
            if (botLeft) {
                Draw.rect((TextureRegion)PowerWall.this.corner4, (float)this.x, (float)this.y, (float)0.0f);
            }
        }

        public void damage(float damage) {
            super.damage(damage);
            this.generationTime += PowerWall.this.hitGenerationTime;
        }

        public void updateTile() {
            super.updateTile();
            this.warmup = Mathf.lerp((float)this.warmup, (float)(this.generationTime > 0.0f ? 1.0f : 0.0f), (float)(Time.delta / 3.0f));
            if (this.generationTime >= 0.0f) {
                this.generationTime -= Time.delta;
            } else if (this.generationTime < 0.0f) {
                this.generationTime = 0.0f;
            }
        }

        public float getPowerProduction() {
            return PowerWall.this.hitPower_pt * this.warmup;
        }

        public void drawShadeAndDecal(boolean side, int rotation, boolean decal) {
            float rot = (float)rotation * 90.0f - 90.0f;
            if (!side) {
                Draw.rect((TextureRegion)(rot >= 90.0f ? PowerWall.this.dark : PowerWall.this.light), (float)this.x, (float)this.y, (float)rot);
                if (decal) {
                    Draw.rect((TextureRegion)(rot >= 90.0f ? PowerWall.this.decalLargeDark : PowerWall.this.decalLarge), (float)this.x, (float)this.y, (float)rot);
                }
            }
        }

        public boolean nearbyWall(int rotation) {
            Tmp.v1.trns((float)rotation * 90.0f, 12.0f, 4.0f).add(this.x, this.y);
            Tmp.v2.trns((float)rotation * 90.0f, 12.0f, -4.0f).add(this.x, this.y);
            int x1 = Mathf.round((float)(Tmp.v1.getX() / 8.0f));
            int y1 = Mathf.round((float)(Tmp.v1.getY() / 8.0f));
            int x2 = Mathf.round((float)(Tmp.v2.getX() / 8.0f));
            int y2 = Mathf.round((float)(Tmp.v2.getY() / 8.0f));
            Building b1 = Vars.world.build(x1, y1);
            Building b2 = Vars.world.build(x2, y2);
            return b2 instanceof PhosphideWallBuild && b1 == b2;
        }

        public boolean nearbyCornerWall(int rotation) {
            Tmp.v1.trns((float)rotation * 90.0f, 12.0f, 12.0f).add(this.x, this.y);
            int x1 = Mathf.round((float)(Tmp.v1.getX() / 8.0f));
            int y1 = Mathf.round((float)(Tmp.v1.getY() / 8.0f));
            Building b1 = Vars.world.build(x1, y1);
            return b1 instanceof PhosphideWallBuild;
        }

        public void draw() {
            this.drawSelf();
            if (PowerWall.this.flashHit) {
                if (this.hit < 1.0E-4f) {
                    return;
                }
                Draw.color((Color)PowerWall.this.flashColor);
                Draw.alpha((float)(this.hit * 0.5f));
                Draw.blend((Blending)Blending.additive);
                Fill.rect((float)this.x, (float)this.y, (float)(8 * PowerWall.this.size), (float)(8 * PowerWall.this.size));
                Draw.blend();
                Draw.reset();
                if (!Vars.state.isPaused()) {
                    this.hit = Mathf.clamp((float)(this.hit - Time.delta / 10.0f));
                }
            }
        }
    }
}

