/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.crafter.crude;

import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.HashMap;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.DirectionalItemBuffer;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import subvoyage.type.block.crafter.crude.CrudeSmelterRecipe;

public class CrudeSmelter
extends GenericCrafter {
    public HashMap<Item, CrudeSmelterRecipe> recipes = new HashMap();

    public CrudeSmelter(String name) {
        super(name);
        this.configurable = true;
        this.saveConfig = true;
        this.clearOnDoubleTap = true;
        this.config(Item.class, (tile, item) -> {
            tile.produceItem = item;
        });
        this.configClear(tile -> {
            tile.produceItem = null;
        });
    }

    public void setStats() {
        super.setStats();
        for (CrudeSmelterRecipe v : this.recipes.values()) {
            this.stats.add(Stat.output, StatValues.items((float)v.craftTime, (ItemStack[])new ItemStack[]{v.outputItem}));
        }
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "center", true);
    }

    public static HashMap<Item, CrudeSmelterRecipe> recipes(Object ... T) {
        HashMap<Item, CrudeSmelterRecipe> recipes = new HashMap<Item, CrudeSmelterRecipe>();
        for (int i = 0; i < T.length; ++i) {
            final Item itemA = (Item)T[i];
            final int countA = (Integer)T[++i];
            final int craftTimeA = (Integer)T[++i];
            recipes.put(itemA, new CrudeSmelterRecipe(){
                {
                    this.craftTime = craftTimeA;
                    this.outputItem = new ItemStack(itemA, countA);
                }
            });
        }
        return recipes;
    }

    public class CrudeSmelterBuild
    extends GenericCrafter.GenericCrafterBuild {
        @Nullable
        public Item produceItem;

        public CrudeSmelterBuild() {
            super((GenericCrafter)CrudeSmelter.this);
        }

        public void drawConfigure() {
            super.drawConfigure();
        }

        public void buildConfiguration(Table table) {
            ItemSelection.buildTable((Block)CrudeSmelter.this, (Table)table, (Seq)Seq.with(CrudeSmelter.this.recipes.keySet()), () -> this.produceItem, arg_0 -> ((CrudeSmelterBuild)this).configure(arg_0), (int)CrudeSmelter.this.selectionRows, (int)CrudeSmelter.this.selectionColumns);
        }

        public Item config() {
            return this.produceItem;
        }

        public void updateTile() {
            CrudeSmelterRecipe recipe = CrudeSmelter.this.recipes.getOrDefault(this.produceItem, CrudeSmelter.this.recipes.values().iterator().next());
            if (this.efficiency > 0.0f && this.produceItem != null) {
                this.progress += this.getProgressIncrease(recipe.craftTime);
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.warmupTarget(), (float)CrudeSmelter.this.warmupSpeed);
                if (this.wasVisible && Mathf.chanceDelta((double)CrudeSmelter.this.updateEffectChance)) {
                    CrudeSmelter.this.updateEffect.at(this.x + Mathf.range((float)((float)CrudeSmelter.this.size * 4.0f)), this.y + (float)Mathf.range((int)(CrudeSmelter.this.size * 4)));
                }
            } else {
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)CrudeSmelter.this.warmupSpeed);
            }
            this.totalProgress += this.warmup * Time.delta;
            if (this.progress >= 1.0f && this.produceItem != null) {
                this.craft();
            }
            this.dumpOutputs();
        }

        public void craft() {
            this.consume();
            CrudeSmelterRecipe recipe = CrudeSmelter.this.recipes.getOrDefault(this.produceItem, CrudeSmelter.this.recipes.values().iterator().next());
            if (recipe.outputItem != null) {
                for (int i = 0; i < recipe.outputItem.amount; ++i) {
                    this.offload(recipe.outputItem.item);
                }
            }
            if (this.wasVisible) {
                CrudeSmelter.this.craftEffect.at(this.x, this.y);
            }
            this.progress %= 1.0f;
        }

        public void dumpOutputs() {
            if (this.produceItem != null && this.timer(CrudeSmelter.this.timerDump, (float)CrudeSmelter.this.dumpTime / this.timeScale)) {
                CrudeSmelterRecipe recipe = CrudeSmelter.this.recipes.getOrDefault(this.produceItem, CrudeSmelter.this.recipes.values().iterator().next());
                this.dump(recipe.outputItem.item);
            }
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            write.s(this.produceItem == null ? -1 : (int)this.produceItem.id);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.produceItem = Vars.content.item((int)read.s());
            if (revision == 1) {
                new DirectionalItemBuffer(20).read(read);
            }
        }
    }
}

