/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type.block.crafter;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.blocks.production.AttributeCrafter;
import subvoyage.content.SvItems;
import subvoyage.core.draw.SvPal;

public class CircularCrusher
extends AttributeCrafter {
    public float sinMag = 0.0f;
    public float sinScl = 10.0f;
    public float sideOffset = 0.0f;
    public float lenOffset = 5.0f;
    public float horiOffset = 0.0f;
    public float angleOffset = 0.0f;
    public TextureRegion sand;
    public TextureRegion saw;
    public TextureRegion sawLight;
    public TextureRegion sawLightStill;
    public TextureRegion bottom;
    public TextureRegion saws;
    public TextureRegion sawStill;

    public CircularCrusher(String name) {
        super(name);
    }

    public void load() {
        super.load();
        this.bottom = Core.atlas.find(this.name + "-bottom");
        this.sand = Core.atlas.find(this.name + "-sand");
        this.saw = Core.atlas.find(this.name + "-saw");
        this.sawLight = Core.atlas.find(this.name + "-saw-light", this.saw);
        this.sawLightStill = Core.atlas.find(this.name + "-saw-light-still", this.sawLight);
        this.saws = Core.atlas.find(this.name + "-saws");
        this.sawStill = Core.atlas.find(this.name + "-saw-still");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.bottom, this.saws, this.region};
    }

    public class TugRollerBuild
    extends AttributeCrafter.AttributeCrafterBuild {
        float curEf;
        float curLen2;
        float sandPercentage;
        float crudePercentage;
        float visualSand;
        float visualCrude;

        public TugRollerBuild() {
            super((AttributeCrafter)CircularCrusher.this);
            this.curEf = 0.0f;
            this.curLen2 = 0.0f;
            this.sandPercentage = 0.0f;
            this.crudePercentage = 0.0f;
            this.visualSand = 0.0f;
            this.visualCrude = 0.0f;
        }

        public void draw() {
            int crudeCount = this.items.get(SvItems.crude);
            int sandCount = this.items.get(SvItems.finesand);
            this.crudePercentage = (float)crudeCount / (float)CircularCrusher.this.itemCapacity;
            this.sandPercentage = (float)sandCount / (float)CircularCrusher.this.itemCapacity;
            this.crudePercentage /= Math.max(1.0f, this.crudePercentage + this.sandPercentage);
            this.sandPercentage /= Math.max(1.0f, this.crudePercentage + this.sandPercentage);
            this.visualCrude = Mathf.lerp((float)this.visualCrude, (float)this.crudePercentage, (float)(Time.delta / 10.0f));
            this.visualSand = Mathf.lerp((float)this.visualSand, (float)this.sandPercentage, (float)(Time.delta / 10.0f));
            Draw.rect((TextureRegion)CircularCrusher.this.bottom, (float)this.x, (float)this.y);
            Draw.color((Color)SvPal.finesand.cpy().lerp(SvPal.crude, this.visualCrude / (this.visualCrude + this.visualSand)), (float)(this.visualCrude + this.visualSand));
            Draw.rect((TextureRegion)CircularCrusher.this.sand, (float)this.x, (float)this.y);
            Draw.color();
            for (int i = 0; i < 2; ++i) {
                float len = Mathf.absin((float)(this.progress * 90.0f + CircularCrusher.this.sideOffset * (float)i), (float)CircularCrusher.this.sinScl, (float)1.0f) + CircularCrusher.this.lenOffset;
                float thisEf = this.curEf = Mathf.lerp((float)this.curEf, (float)this.efficiency, (float)(Time.delta / 10.0f));
                float angle = CircularCrusher.this.angleOffset + (float)i * 360.0f / 2.0f;
                if (Mathf.equal((float)angle, (float)315.0f)) {
                    Draw.yscl = -1.0f;
                }
                Tmp.v1.trns(angle, CircularCrusher.this.lenOffset, -CircularCrusher.this.horiOffset);
                float rotation = Time.time * 10.0f * thisEf % 360.0f;
                Draw.scl((float)(1.03f - 0.2f * (1.0f - thisEf)));
                Drawf.spinSprite((TextureRegion)(this.efficiency < 0.3f ? CircularCrusher.this.sawStill : CircularCrusher.this.saw), (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y + Mathf.sinDeg((float)(Time.time * 2.0f)) * (float)(i * 2 - 1) * this.efficiency), (float)rotation);
                Drawf.spinSprite((TextureRegion)(this.efficiency < 0.3f ? CircularCrusher.this.sawLightStill : CircularCrusher.this.sawLight), (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y + Mathf.sinDeg((float)(Time.time * 2.0f)) * (float)(i * 2 - 1) * this.efficiency), (float)(Mathf.sinDeg((float)rotation) * 10.0f / 2.0f));
                Draw.yscl = 1.0f;
                Draw.reset();
            }
            CircularCrusher.this.drawer.draw((Building)this);
        }
    }
}

