/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.type;

import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.graphics.Pal;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import subvoyage.core.ui.PowerDisplay;

public class ConsumesOr
extends Consume {
    public Seq<Consume> consumes;

    public ConsumesOr(Consume ... consumes) {
        this.consumes = Seq.with((Object[])consumes);
    }

    public void apply(Block block) {
        super.apply(block);
        this.consumes.each(e -> e.apply(block));
    }

    public void build(Building build, Table table) {
        table.table(t -> {
            int i = 0;
            for (Consume consume : this.consumes) {
                if (consume instanceof ConsumePower) {
                    ConsumePower cp = (ConsumePower)consume;
                    Image image = new Image(Icon.power.getRegion());
                    image.setColor(Pal.powerLight);
                    t.add((Element)new ReqImage((Element)image, () -> cp.efficiency(build) > 0.01f)).size(24.0f, 32.0f).scaling(Scaling.fit);
                } else {
                    consume.build(build, t);
                }
                if (i != this.consumes.size - 1) {
                    t.label(() -> "/");
                }
                ++i;
            }
        }).left();
    }

    public void display(Stats stats) {
        int i = 0;
        for (Consume consume : this.consumes) {
            if (consume instanceof ConsumePower) {
                ConsumePower cp = (ConsumePower)consume;
                stats.add(Stat.input, table -> table.add((Element)new PowerDisplay(cp.usage)).padRight(5.0f));
            } else {
                consume.display(stats);
            }
            if (i != this.consumes.size - 1) {
                stats.add(Stat.input, table -> table.label(() -> "/"));
            }
            ++i;
        }
    }

    public void update(Building build) {
        this.active(build).update(build);
    }

    public void trigger(Building build) {
        this.active(build).trigger(build);
    }

    public float efficiency(Building build) {
        return this.active(build).efficiency(build);
    }

    public Consume active(Building build) {
        return (Consume)this.consumes.max(e -> e.efficiency(build));
    }
}

