/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.ui.advancements;

import arc.Core;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Reflect;
import arc.util.Structs;
import mindustry.Vars;
import subvoyage.core.SvSettings;
import subvoyage.core.ui.SvUI;

public class Advancement {
    public static Seq<Advancement> all = Seq.with((Object[])new Advancement[0]);
    public static Advancement welcome;
    public static Advancement beta;
    public static Advancement sectorf_thaw;
    public static Advancement sector_construction;
    public static Advancement sector_the_segment;
    public static Advancement unit_helio;
    public static Advancement unit_hydro;
    public static Advancement unit_rover;
    public static Advancement big_bubble;
    public static Advancement the_segment_hundred_wave;
    public static Advancement helicopter_tricked;
    public static Advancement water_to_sifter;
    public static Advancement laser;
    public static Advancement hard_water;
    public static Advancement uwu;
    public String id;
    public String title;
    public String description;
    public String icon;

    private Advancement() {
    }

    public static void load() {
        Advancement.add("welcome", "sublemon_frog", "beta", "sodilate-boulder1", "sectorf_thaw", "ceramic-burner", "sector_construction", "power-bubble-node", "sector_the_segment", "build-tower-adv", "hard_water", "liquid-hard-water", "laser", "laser-projector", "unit_helio", "lapetus-full", "unit_hydro", "leeft-full", "unit_rover", "stunt-full", "big_bubble", "power-bubble-node", "the_segment_hundred_wave", "core-bastion-adv", "helicopter_tricked", "commute-rupture", "water_to_sifter", "water-sifter", "uwu", "leeft-uwu");
    }

    public static Advancement get(String id) {
        return (Advancement)all.find(a -> a.id.equals(id));
    }

    public static boolean unlocked(Advancement adv) {
        return SvSettings.bool(adv.id + "-adv-unlocked");
    }

    public static void unlock(Advancement adv) {
        if (!Advancement.unlocked(adv)) {
            Advancement.toast(adv);
        }
        SvSettings.bool(adv.id + "-adv-unlocked", true);
    }

    public static void lock(Advancement adv) {
        SvSettings.bool(adv.id + "-adv-unlocked", false);
    }

    public static void toast(Advancement adv) {
        Log.info((Object)("Advancement toast: " + adv.title));
        SvUI.advancementFrag.queue.addUnique((Object)adv);
    }

    public static void add(String ... all) {
        if (all.length % 2 != 0) {
            return;
        }
        for (int i = 0; i < all.length; i += 2) {
            String t = all[i];
            String ic = all[i + 1];
            Advancement.all.add((Object)Advancement.from(t, ic));
        }
    }

    public static Advancement from(final String title_, final String icon_) {
        Advancement adv = new Advancement(){
            {
                this.id = title_;
                this.title = Core.bundle.get("sv_advancement." + title_ + ".name");
                this.description = Core.bundle.get("sv_advancement." + title_ + ".description");
                this.icon = "subvoyage-" + icon_;
            }
        };
        if (Structs.contains((Object[])Advancement.class.getFields(), t -> t.getName().equals(title_))) {
            Reflect.set(Advancement.class, (String)title_, (Object)adv);
        }
        return adv;
    }

    public void unlock() {
        boolean test = false;
        if (!Vars.state.isCampaign() && !test) {
            return;
        }
        if (Vars.state.rules.infiniteResources && !test) {
            return;
        }
        Advancement.unlock(this);
    }
}

