/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.logic;

import arc.Core;
import arc.util.Log;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.type.SectorPreset;
import mindustry.world.Block;
import mindustry.world.blocks.storage.CoreBlock;
import subvoyage.Subvoyage;
import subvoyage.content.SvItems;
import subvoyage.content.SvUnits;
import subvoyage.content.block.SvProduction;
import subvoyage.content.other.SvTeam;
import subvoyage.content.world.SvPlanets;
import subvoyage.content.world.SvSectorPresets;
import subvoyage.core.SvSettings;
import subvoyage.core.SvVars;
import subvoyage.core.UpdateManager;
import subvoyage.core.ui.SvIcons;
import subvoyage.core.ui.SvUI;
import subvoyage.core.ui.advancements.Advancement;
import subvoyage.type.block.production.Sifter;
import subvoyage.type.unit.ability.LegionfieldAbility;
import subvoyage.util.Var;

public class SvLogic {
    public static boolean beta = false;
    static int currentVersion = 1;

    public static void clientLoad() {
        Subvoyage.currentTag = Vars.mods.getMod((String)Subvoyage.ID).meta.version;
        SvLogic.checkUpdates();
        SvLogic.checkChanges();
        UpdateManager.checkFico();
        Core.bundle.getProperties().put((Object)"sector.curcapturefake", (Object)("[lightgray]" + Core.bundle.get("sector.curcapture") + "[]"));
        SvIcons.load();
        SvUnits.loadUwu(SvSettings.unitUwu());
        SvUI.load();
    }

    public static void newGame() {
        CoreBlock.CoreBuild core = Vars.player.bestCore();
        if (core == null) {
            return;
        }
        if (!Core.settings.getBool("skipcoreanimation") && !Vars.state.rules.pvp && Vars.state.rules.planet == SvPlanets.atlacian) {
            SvLogic.beginLandMusic();
        }
    }

    public static void beginLandMusic() {
    }

    public static void update() {
        if (Vars.state.isGame()) {
            SvLogic.gameUpdate();
        }
        if (Vars.state.isMenu()) {
            SvLogic.menuUpdate();
        }
        SvVars.atlacianMapControl.update();
        try {
            if (Vars.state.rules.waves) {
                Vars.state.rules.objectiveFlags.add((Object)("wave" + Vars.state.wave));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void gameUpdate() {
        String id2;
        if (Vars.player.team() == Team.sharded && Vars.state.rules.planet == SvPlanets.atlacian) {
            Vars.player.team(SvTeam.melius);
        }
        LegionfieldAbility.update();
        if (Vars.state.rules.planet == SvPlanets.atlacian) {
            Advancement.welcome.unlock();
        }
        if (Vars.state.rules.planet == SvPlanets.atlacian && beta) {
            Advancement.beta.unlock();
        }
        for (SectorPreset sect : SvSectorPresets.all) {
            String id = "sector_" + sect.name.replace("subvoyage-", "").replace("-", "_");
            if (!sect.sector.isCaptured() || Advancement.get(id) == null) continue;
            Advancement.get(id).unlock();
        }
        if (Vars.state.getSector() != null && Vars.state.getSector().isBeingPlayed() && !Vars.state.rules.objectives.all.contains(e -> !e.isCompleted()) && Advancement.get(id2 = "sectorf_" + Vars.state.getSector().preset.name.replace("subvoyage-", "").replace("-", "_")) != null) {
            Advancement.get(id2).unlock();
        }
        if (Vars.state.getSector() != null && Vars.state.getSector().preset == SvSectorPresets.segment && Vars.state.wave > 100) {
            Advancement.the_segment_hundred_wave.unlock();
        }
        if (SvItems.hardWater.unlocked()) {
            Advancement.hard_water.unlock();
        }
    }

    public static void menuUpdate() {
    }

    public static void reset() {
        SvVars.atlacianMapControl.stop();
    }

    public static void worldLoad() {
        Block block = SvProduction.sifter;
        if (block instanceof Sifter) {
            Sifter sifter = (Sifter)block;
            sifter.worldReset();
        }
        SvVars.atlacianMapControl.recalc();
    }

    public static void checkUpdates() {
        boolean autoUpdate = SvSettings.autoUpdate();
        Log.info((Object)("[Subvoyage] Autoupdate: " + (autoUpdate ? "Enabled" : "Disabled")));
        if (autoUpdate) {
            UpdateManager.begin();
        }
    }

    public static void checkChanges() {
        Var<Integer> prev = Var.stgInt("update-idx", 0);
        Log.info((Object)("[Subvoyage] Previous revision: " + prev.val));
        Log.info((Object)("[Subvoyage] Current revision: " + currentVersion));
        SvSettings.i("update-idx", currentVersion);
        if ((Integer)prev.val >= currentVersion) {
            return;
        }
        Vars.ui.showInfoOnHidden("@settings.sv-update-id.confirm", () -> {
            if ((Integer)prev.val == 0) {
                SvSettings.resetSaves(SvPlanets.atlacian);
                SvSettings.resetTree(SvPlanets.atlacian.techTree);
                Advancement.beta.unlock();
                prev.val = 1;
            }
            Core.app.exit();
        });
    }
}

