/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.shader;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.Shader;
import arc.math.geom.Vec3;
import arc.util.Time;
import mindustry.Vars;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Shaders;
import mindustry.type.Planet;
import subvoyage.core.SvVars;
import subvoyage.core.draw.SvRender;

public class SvShaders {
    public static SurfaceShader hardWater;
    public static SurfaceShader hardWaterCache;
    public static SurfaceShader powerBubbles;
    public static SurfaceShader underwaterRegion;
    public static SurfaceShader laser;
    public static boolean useDefaultBuffer;
    public static CacheLayer.ShaderLayer hardWaterLayer;
    public static PlanetTextureShader planetTextureShader;

    public static Fi file(String name) {
        return Vars.tree.get("shaders/" + name);
    }

    public static void init() {
        hardWater = new SurfaceShader("hard-water");
        hardWaterCache = new SurfaceShader("hard-water"){

            @Override
            public void apply() {
                this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
                this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
                this.setUniformf("u_time", Time.time);
                this.setUniformf("u_ww", Vars.world.width() * 8);
                this.setUniformf("u_wh", Vars.world.height() * 8);
                if (this.hasUniform("u_noise")) {
                    if (this.noiseTex == null) {
                        this.noiseTex = (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                    }
                    this.noiseTex.bind(1);
                    ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                    this.setUniformi("u_noise", 1);
                }
            }
        };
        planetTextureShader = new PlanetTextureShader();
        underwaterRegion = new SurfaceShader("underwater-region"){

            @Override
            public String textureName() {
                return "noise";
            }

            @Override
            public void apply() {
                this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
                this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
                this.setUniformf("u_time", Time.time);
                this.setUniformf("u_ww", Vars.world.width() * 8);
                this.setUniformf("u_wh", Vars.world.height() * 8);
                this.setUniformf("u_opacity", (float)Core.settings.getInt("sv-metal-fuming-opacity") / 100.0f);
                if (this.hasUniform("u_noise")) {
                    if (this.noiseTex == null) {
                        this.noiseTex = (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                    }
                    this.noiseTex.bind(1);
                    if (SvVars.effectBuffer != null) {
                        ((Texture)SvVars.effectBuffer.getTexture()).bind(0);
                    } else {
                        ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                    }
                    this.setUniformi("u_noise", 1);
                }
                if (this.hasUniform("u_distortmap")) {
                    Texture heatTex = SvVars.atlacianMapControl.toTexture();
                    if (heatTex == null) {
                        return;
                    }
                    heatTex.bind(2);
                    if (SvVars.effectBuffer != null) {
                        ((Texture)SvVars.effectBuffer.getTexture()).bind(0);
                    } else {
                        ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                    }
                    this.setUniformi("u_distortmap", 2);
                }
            }
        };
        powerBubbles = new SurfaceShader("powerbubbles"){

            @Override
            public String textureName() {
                return "noise";
            }

            @Override
            public void apply() {
                this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
                this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
                this.setUniformf("u_time", Time.time);
                this.setUniformf("u_ww", Vars.world.width() * 8);
                this.setUniformf("u_wh", Vars.world.height() * 8);
                if (this.hasUniform("u_noise")) {
                    if (this.noiseTex == null) {
                        this.noiseTex = (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                    }
                    this.noiseTex.bind(1);
                    if (SvRender.buffer != null) {
                        ((Texture)SvRender.buffer.getTexture()).bind(0);
                    } else {
                        ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                    }
                    this.setUniformi("u_noise", 1);
                }
            }
        };
        laser = new SurfaceShader("laser"){

            @Override
            public String textureName() {
                return "noise";
            }

            @Override
            public void apply() {
                this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
                this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
                this.setUniformf("u_time", Time.time);
                this.setUniformf("u_ww", Vars.world.width() * 8);
                this.setUniformf("u_wh", Vars.world.height() * 8);
                if (this.hasUniform("u_noise")) {
                    if (this.noiseTex == null) {
                        this.noiseTex = (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                    }
                    this.noiseTex.bind(1);
                    if (SvRender.buffer != null) {
                        ((Texture)SvRender.buffer.getTexture()).bind(0);
                    } else {
                        ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                    }
                    this.setUniformi("u_noise", 1);
                }
            }
        };
        CacheLayer[] cacheLayerArray = new CacheLayer[1];
        hardWaterLayer = new CacheLayer.ShaderLayer((Shader)hardWaterCache);
        cacheLayerArray[0] = hardWaterLayer;
        CacheLayer.addLast((CacheLayer[])cacheLayerArray);
    }

    public static void dispose() {
        if (!Vars.headless) {
            hardWater.dispose();
            planetTextureShader.dispose();
            underwaterRegion.dispose();
            powerBubbles.dispose();
            laser.dispose();
        }
    }

    static {
        useDefaultBuffer = false;
    }

    public static class SurfaceShader
    extends Shader {
        Texture noiseTex;

        public SurfaceShader(String frag) {
            super(Shaders.getShaderFi((String)"screenspace.vert"), SvShaders.file(frag + ".frag"));
            this.loadNoise();
        }

        public SurfaceShader(String vertRaw, String fragRaw) {
            super(vertRaw, fragRaw);
            this.loadNoise();
        }

        public String textureName() {
            return "noise";
        }

        public void loadNoise() {
            Core.assets.load((String)new StringBuilder().append((String)"sprites/").append((String)this.textureName()).append((String)".png").toString(), Texture.class).loaded = t -> {
                t.setFilter(Texture.TextureFilter.linear);
                t.setWrap(Texture.TextureWrap.repeat);
            };
        }

        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
            this.setUniformf("u_time", Time.time);
            this.setUniformf("u_ww", Vars.world.width() * 8);
            this.setUniformf("u_wh", Vars.world.height() * 8);
            if (this.hasUniform("u_noise")) {
                if (this.noiseTex == null) {
                    this.noiseTex = (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                }
                this.noiseTex.bind(1);
                if (SvVars.effectBuffer != null) {
                    ((Texture)SvVars.effectBuffer.getTexture()).bind(0);
                } else {
                    ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                }
                this.setUniformi("u_noise", 1);
            }
        }
    }

    public static class PlanetTextureShader
    extends SvLoadShader {
        public Vec3 lightDir = new Vec3(1.0f, 1.0f, 1.0f).nor();
        public Color ambientColor = Color.white.cpy();
        public Vec3 camDir = new Vec3();
        public float alpha = 1.0f;
        public Planet planet;

        public PlanetTextureShader() {
            super("circle-mesh", "circle-mesh");
        }

        @Override
        public void apply() {
            this.camDir.set(Vars.renderer.planets.cam.direction).rotate(Vec3.Y, this.planet.getRotation());
            this.setUniformf("u_alpha", this.alpha);
            this.setUniformf("u_lightdir", this.lightDir);
            this.setUniformf("u_ambientColor", this.ambientColor.r, this.ambientColor.g, this.ambientColor.b);
            this.setPlanetInfo("u_sun_info", this.planet.solarSystem);
            this.setPlanetInfo("u_planet_info", this.planet);
            this.setUniformf("u_camdir", this.camDir);
            this.setUniformf("u_campos", Vars.renderer.planets.cam.position);
        }

        private void setPlanetInfo(String name, Planet planet) {
            Vec3 position = planet.position;
            PlanetTextureShader shader = this;
            shader.setUniformf(name, position.x, position.y, position.z, planet.radius);
        }
    }

    public static class SvLoadShader
    extends Shader {
        public SvLoadShader(String fragment, String vertex) {
            super(SvShaders.file(vertex + ".vert"), SvShaders.file(fragment + ".frag"));
        }

        public void set() {
            Draw.shader((Shader)this);
        }

        public void apply() {
            super.apply();
            this.setUniformf("u_time_millis", (float)System.currentTimeMillis() / 1000.0f * 60.0f);
        }
    }
}

