/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.part;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.RegionPart;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.draw.DrawTurret;

public class SvRegionPart
extends RegionPart {
    @Nullable
    public Liquid liquidDraw;
    public TextureRegion liquid;
    public DrawTurret drawer;
    public float liquidAlpha = 1.0f;

    public SvRegionPart(DrawTurret drawer, String region) {
        this.suffix = region;
        this.drawer = drawer;
    }

    public void draw(DrawPart.PartParams params) {
        super.draw(params);
        float prog = this.progress.getClamp(params);
        float sclProg = this.growProgress.getClamp(params);
        float mx = this.moveX * prog;
        float my = this.moveY * prog;
        float mr = this.moveRot * prog + this.rotation;
        float gx = this.growX * sclProg;
        float gy = this.growY * sclProg;
        int len = this.mirror && params.sideOverride == -1 ? 2 : 1;
        Draw.xscl *= this.xScl + gx;
        Draw.yscl *= this.yScl + gy;
        for (int s = 0; s < len; ++s) {
            int i = params.sideOverride == -1 ? s : params.sideOverride;
            float sign = (i == 0 ? 1 : -1) * params.sideMultiplier;
            Tmp.v1.set((this.x + mx) * sign, this.y + my).rotateRadExact((params.rotation - 90.0f) * ((float)Math.PI / 180));
            float rx = params.x + Tmp.v1.x;
            float ry = params.y + Tmp.v1.y;
            float rot = mr * sign + params.rotation - 90.0f;
            Draw.xscl *= sign;
            if (this.liquid.found()) {
                Liquid toDraw = this.liquidDraw;
                if (toDraw == null) {
                    return;
                }
                Drawf.liquid((TextureRegion)this.liquid, (float)rx, (float)ry, (float)this.liquidAlpha, (Color)toDraw.color.write(Tmp.c1).a(1.0f), (float)rot);
            }
            Draw.xscl *= sign;
        }
    }

    public void load(String name) {
        super.load(name);
        String realName = this.name == null ? name + this.suffix : this.name;
        this.liquid = Core.atlas.find(realName + "-liquid");
    }
}

