/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.part;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import subvoyage.Subvoyage;

public class SpinningBlurRegionPart
extends DrawPart {
    public TextureRegion rotator;
    public TextureRegion outlineR;
    public TextureRegion blurR;
    public TextureRegion lightR;
    public TextureRegion top;
    public float layer = -1.0f;
    public float outlineLayerOffset = -0.001f;
    public float x;
    public float y;
    public float xScl = 1.0f;
    public float yScl = 1.0f;
    public float rotationRad = 720.0f;
    public float rotationSpeed;
    public boolean mirror = false;
    @Nullable
    public Color color;
    public String suffix = Subvoyage.ID + "-base-rotator";
    public boolean outline = false;
    public boolean blur = true;
    public boolean draw = true;

    public SpinningBlurRegionPart(String suffix) {
        this.suffix = suffix;
    }

    public SpinningBlurRegionPart() {
    }

    public void draw(DrawPart.PartParams params) {
        if (!this.draw) {
            return;
        }
        if (this.rotator.found()) {
            float layer = params.warmup > 0.1f ? this.layer + 3.0f : 78.0f;
            Vec2 vec = Tmp.v2.set(this.x, this.y).rotate(params.rotation - 90.0f);
            float t = Time.time / 60.0f;
            float accel = Mathf.clamp((float)params.warmup, (float)0.0f, (float)1.0f);
            float rx = params.x;
            float ry = params.y;
            float rot = t * this.rotationSpeed * 4.0f + (params.rotation - 90.0f);
            rot = Mathf.lerp((float)(params.rotation - 90.0f), (float)rot, (float)accel);
            Draw.xscl *= this.xScl;
            Draw.yscl *= this.yScl;
            Draw.z((float)(layer + 1.0f));
            Draw.xscl /= 1.5f;
            Draw.yscl /= 1.5f;
            Draw.rect((TextureRegion)this.top, (float)(vec.x + rx), (float)(vec.y + ry), (float)vec.angle());
            Draw.xscl *= 1.5f;
            Draw.yscl *= 1.5f;
            Draw.alpha((float)(1.0f - accel));
            Draw.z((float)(layer - 5.0f));
            Draw.rect((TextureRegion)this.outlineR, (float)(vec.x + rx), (float)(vec.y + ry), (float)rot);
            Draw.z((float)layer);
            Draw.rect((TextureRegion)this.rotator, (float)(vec.x + rx), (float)(vec.y + ry), (float)rot);
            if (this.blur) {
                Draw.z((float)(layer - 1.0f));
                Draw.alpha((float)accel);
                Draw.rect((TextureRegion)this.blurR, (float)(vec.x + rx), (float)(vec.y + ry), (float)rot);
                Draw.alpha((float)(accel * 0.8f));
                Draw.rect((TextureRegion)this.lightR, (float)(vec.x + rx), (float)(vec.y + ry), (float)0.0f);
                Draw.z((float)Draw.z());
                Draw.alpha((float)1.0f);
            }
            Vec2 mirrorVec = Tmp.v2.set(-this.x, this.y).rotate(params.rotation - 90.0f);
            if (this.mirror) {
                Draw.z((float)(layer + 1.0f));
                Draw.xscl /= 1.5f;
                Draw.yscl /= 1.5f;
                Draw.rect((TextureRegion)this.top, (float)(mirrorVec.x + rx), (float)(mirrorVec.y + ry), (float)mirrorVec.angle());
                Draw.xscl *= 1.5f;
                Draw.yscl *= 1.5f;
                Draw.alpha((float)(1.0f - accel));
                Draw.z((float)(layer - 5.0f));
                Draw.rect((TextureRegion)this.outlineR, (float)(mirrorVec.x + rx), (float)(mirrorVec.y + ry), (float)(-rot + (params.rotation - 90.0f) * 2.0f));
                Draw.z((float)layer);
                Draw.rect((TextureRegion)this.rotator, (float)(mirrorVec.x + rx), (float)(mirrorVec.y + ry), (float)(-rot + (params.rotation - 90.0f) * 2.0f));
                if (this.blur && accel > 0.3f) {
                    Draw.z((float)(layer - 1.0f));
                    Draw.alpha((float)accel);
                    Draw.rect((TextureRegion)this.blurR, (float)(mirrorVec.x + rx), (float)(mirrorVec.y + ry), (float)(-rot + (params.rotation - 90.0f) * 2.0f));
                    Draw.alpha((float)(accel * 0.8f));
                    Draw.rect((TextureRegion)this.lightR, (float)(vec.x + rx), (float)(vec.y + ry), (float)0.0f);
                    Draw.z((float)Draw.z());
                    Draw.alpha((float)1.0f);
                }
            }
            Draw.reset();
        }
    }

    public void load(String name) {
        this.rotator = Core.atlas.find(this.suffix);
        this.top = Core.atlas.find(this.suffix + "-top");
        if (this.blur) {
            this.blurR = Core.atlas.find(this.suffix + "-blur");
            this.lightR = Core.atlas.find(this.suffix + "-blur-light");
        }
        this.outlineR = Core.atlas.find(this.suffix + "-outline");
    }

    public void getOutlines(Seq<TextureRegion> out) {
        out.addAll((Object[])new TextureRegion[]{this.rotator, this.top});
    }
}

