/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.content.Liquids;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.world.draw.DrawLiquidRegion;
import subvoyage.core.draw.SvPal;

public class DrawMixer
extends DrawLiquidRegion {
    public Color metaColor = SvPal.polygen;
    public int bubbles = 14;
    public float strokeMin = 0.25f;
    public float spread = 4.0f;
    public float timeScl = 160.0f;
    public float recurrence = 6.0f;
    public float radius = 2.0f;

    public void draw(Building build) {
        float alpha = build.liquids.get(Liquids.water) / build.block.liquidCapacity;
        if (alpha > 0.0f) {
            Drawf.liquid((TextureRegion)this.liquid, (float)build.x, (float)(build.y - 1.25f), (float)(alpha / 2.0f), (Color)Liquids.water.color, (float)Mathf.sin((float)60.0f, (float)(0.0f + rand.range(this.spread))));
            Draw.color((Color)this.metaColor, (float)(alpha / 2.0f));
            rand.setSeed((long)build.pos());
            for (int i = 0; i < this.bubbles; ++i) {
                float x = rand.range(this.spread);
                float y = rand.range(this.spread) - 1.25f;
                float life = 1.0f - (Time.time / this.timeScl + rand.random(this.recurrence)) % this.recurrence;
                if (!(life > 0.0f)) continue;
                Lines.stroke((float)(life + 0.4f * (life + this.strokeMin)));
                Lines.poly((float)(build.x + x), (float)(build.y + y), (int)6, (float)((1.0f - life) * this.radius));
            }
            Draw.color();
        }
    }
}

