/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawEnergyGlow
extends DrawBlock {
    public Color color = new Color(0.45f, 0.22f, 0.65f, 1.0f);
    public float pulse = 0.15f;
    public float scl = 2.5f;
    public float layer = 31.0f;
    public TextureRegion glow;
    public String suffix = "-glow";

    public DrawEnergyGlow(float layer) {
        this.layer = layer;
    }

    public DrawEnergyGlow(String suffix) {
        this.suffix = suffix;
    }

    public DrawEnergyGlow(String suffix, Color color, float pulse, float scl) {
        this.suffix = suffix;
        this.color = color;
        this.pulse = pulse;
        this.scl = scl;
    }

    public DrawEnergyGlow() {
    }

    public void draw(Building build) {
        Draw.z((float)31.0f);
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        Draw.blend((Blending)Blending.additive);
        Draw.color((Color)this.color, (float)(Mathf.clamp((float)build.power.status) * (this.color.a * (build.power.status - this.pulse + Mathf.absin((float)this.scl, (float)this.pulse)))));
        Draw.rect((TextureRegion)this.glow, (float)build.x, (float)build.y);
        Draw.blend();
        Draw.color();
        Draw.z((float)z);
    }

    public void load(Block block) {
        this.glow = Core.atlas.find(block.name + this.suffix);
    }
}

