/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.Tmp;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import subvoyage.core.draw.SvDraw;
import subvoyage.core.draw.block.Draw3DSprite;

public class Draw3DStem
extends Draw3DSprite {
    public int segments = 24;
    public boolean enableZOffset = true;

    public Draw3DStem(String suffix) {
        super(suffix);
        this.layerTo = 140.25f;
        this.layerFrom = 140.25f;
    }

    public Draw3DStem() {
        this.layerTo = 140.25f;
        this.layerFrom = 140.25f;
    }

    @Override
    public void draw(Building build) {
        float z = Draw.z();
        Draw.z((float)this.layer(build));
        float x = this.x(build);
        float y = this.y(build);
        float off = this.off(build);
        Draw.z((float)(Draw.z() + SvDraw._3D.layerOffset(x, y)));
        float hWidth = (float)this.region.height * Draw.scl * this.region.scl() * 2.0f;
        float hScl = SvDraw._3D.hScale(off);
        float ex = SvDraw._3D.xHeight(x, off);
        float ey = SvDraw._3D.yHeight(y, off);
        float xDiff = ex - build.x;
        float yDiff = ey - build.y;
        float sDiff = hScl - 1.0f;
        for (int i = 0; i < this.segments; ++i) {
            float p1 = (float)i / (float)this.segments * ((float)i / (float)this.segments);
            float p2 = ((float)i + 1.0f) / (float)this.segments * (((float)i + 1.0f) / (float)this.segments);
            float x1 = build.x + xDiff * p1;
            float y1 = build.y + yDiff * p1;
            float x2 = build.x + xDiff * p2;
            float y2 = build.y + yDiff * p2;
            float s1 = 1.0f + sDiff * p1;
            float s2 = 1.0f + sDiff * p2;
            float len = Mathf.len((float)(x2 - x1), (float)(y2 - y1));
            float diffX = (x2 - x1) / len * hWidth;
            float diffY = (y2 - y1) / len * hWidth;
            float a1 = Tmp.c1.set(1.0f, 1.0f, 1.0f, SvDraw._3D.heightFade(off * p1)).toFloatBits();
            float a2 = Tmp.c1.set(1.0f, 1.0f, 1.0f, SvDraw._3D.heightFade(off * p2)).toFloatBits();
            if (i == 0) {
                a1 = Tmp.c1.set(1.0f, 1.0f, 1.0f, SvDraw._3D.heightFade(off * p1) * 0.0f).toFloatBits();
            }
            SvDraw.quad(this.region, x1 - diffY * s1, y1 + diffX * s1, a1, x1 + diffY * s1, y1 - diffX * s1, a1, x2 + diffY * s2, y2 - diffX * s2, a2, x2 - diffY * s2, y2 + diffX * s2, a2);
        }
        Draw.z((float)z);
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[0];
    }
}

