/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw.block;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.Time;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import subvoyage.core.draw.SvDraw;

public class Draw3DSprite
extends DrawBlock {
    public TextureRegion region;
    public String suffix = "";
    public float camOffset = 3.0f;
    public float driftScl = 30.0f;
    public float driftMag = 2.0f;
    public float animScl = 30.0f;
    public float animMag = 2.0f;
    public float surfaceTime = 0.95f;
    public float layerFrom = 140.25f;
    public float layerTo = 142.1f;
    public boolean enableZOffset = true;
    public boolean anim = false;

    public Draw3DSprite(String suffix) {
        this.suffix = suffix;
    }

    public Draw3DSprite() {
    }

    public void draw(Building build) {
        float z = Draw.z();
        Draw.z((float)this.layer(build));
        float x = this.x(build);
        float y = this.y(build);
        float off = this.off(build);
        Draw.z((float)(Draw.z() + SvDraw._3D.layerOffset(x, y) + (!this.enableZOffset ? 0.0f : Mathf.randomSeed((long)((long)(build.x * build.y + build.x + build.y))) * 0.2f)));
        Draw.scl((float)SvDraw._3D.hScale(off));
        Draw.alpha((float)SvDraw._3D.heightFade(off));
        Draw.rect((TextureRegion)this.region, (float)SvDraw._3D.xHeight(x, off), (float)SvDraw._3D.yHeight(y, off));
        Draw.scl();
        Draw.z((float)z);
    }

    public float layer(Building build) {
        return build.warmup() > this.surfaceTime ? this.layerTo : this.layerFrom;
    }

    public float x(Building build) {
        return build.x + Mathf.cos((float)Time.time, (float)this.driftScl, (float)this.driftMag);
    }

    public float y(Building build) {
        return build.y + Mathf.sin((float)Time.time, (float)(this.driftScl * 1.05f), (float)this.driftMag);
    }

    public float off(Building build) {
        return this.anim ? Math.abs(Mathf.cos((float)Time.time, (float)this.animScl, (float)this.animMag)) * this.camOffset : this.camOffset;
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.region};
    }

    public void load(Block block) {
        this.region = Core.atlas.find(block.name + this.suffix);
    }
}

