/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.core.draw;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Bloom;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.type.Weather;
import subvoyage.content.world.SvPlanets;
import subvoyage.core.SvSettings;
import subvoyage.core.SvVars;
import subvoyage.core.draw.shader.SvShaders;

public class SvRender {
    public static FrameBuffer buffer;
    @Nullable
    public static Bloom bloom;
    public static Runnable atlacianRenderer;

    public static void draw() {
        if (bloom == null) {
            bloom = new Bloom(true);
        }
        if (buffer == null) {
            buffer = new FrameBuffer();
        }
        buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
        Draw.drawRange((float)30.3f, (float)0.1f, () -> buffer.begin(Color.clear), () -> {
            buffer.end();
            buffer.blit((Shader)SvShaders.hardWater);
        });
        if (SvSettings.bool("laser-shaders")) {
            Draw.drawRange((float)72.2f, (float)0.1f, () -> {
                bloom.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                bloom.setBloomIntensity(0.5f);
                SvRender.bloom.blurPasses = 1;
                bloom.capture();
                buffer.begin(Color.clear);
            }, () -> {
                buffer.end();
                buffer.blit((Shader)SvShaders.laser);
                bloom.render();
            });
        }
        if (SvSettings.bool("power-bubble-shaders")) {
            Draw.drawRange((float)86.7f, (float)0.2f, () -> buffer.begin(Color.clear), () -> {
                buffer.end();
                Draw.blend((Blending)Blending.additive);
                buffer.blit((Shader)SvShaders.powerBubbles);
                Draw.blend();
            });
        }
        if (Core.settings.getBool("bloom") && bloom != null) {
            Vars.renderer.bloom.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            Vars.renderer.bloom.setBloomIntensity((float)Core.settings.getInt("bloomintensity", 6) / 4.0f + 1.0f);
            Vars.renderer.bloom.blurPasses = Core.settings.getInt("bloomblur", 1);
            Draw.drawRange((float)74.5f, (float)0.1f, () -> ((Bloom)Vars.renderer.bloom).capture(), () -> ((Bloom)Vars.renderer.bloom).render());
        }
        if (Vars.state.getPlanet() == SvPlanets.atlacian) {
            atlacianRenderer.run();
        }
        SvVars.effectBuffer = buffer;
    }

    public static void initEnv() {
        Color waterColor = Color.valueOf((String)"274D89");
        Color rainColor = Color.valueOf((String)"4589EF");
        Core.assets.load("sprites/distortAlpha.png", Texture.class);
        float windSpeed = 0.3f;
        float windAngle = 45.0f;
        float windx = Mathf.cosDeg((float)windAngle) * windSpeed;
        float windy = Mathf.sinDeg((float)windAngle) * windSpeed;
        atlacianRenderer = () -> {
            Texture tex = (Texture)Core.assets.get("sprites/distortAlpha.png", Texture.class);
            if (tex.getMagFilter() != Texture.TextureFilter.linear) {
                tex.setFilter(Texture.TextureFilter.linear);
                tex.setWrap(Texture.TextureWrap.repeat);
            }
            Draw.z((float)140.5f);
            Draw.blend((Blending)Blending.additive);
            Draw.color((Color)waterColor.cpy().a(0.3f));
            Draw.rect();
            Draw.blend();
            Draw.z((float)130.0f);
            Draw.color((Color)rainColor);
            Weather.drawRain((float)2.45f, (float)4.0f, (float)(windx * 2.0f), (float)(windy * 2.0f), (float)1000.0f, (float)1.0f, (float)0.8f, (Color)rainColor);
        };
    }

    public static class Layer
    extends mindustry.graphics.Layer {
        public static final float laser = 72.2f;
        public static final float powerBubbles = 86.7f;
        public static final float hardWater = 30.3f;
        public static final float effectGround = 74.5f;
    }
}

