/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.world;

import arc.util.Time;
import mindustry.content.StatusEffects;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.gen.WeatherState;
import mindustry.type.Weather;
import mindustry.type.weather.RainWeather;
import mindustry.world.meta.Attribute;

public class SvWeather {
    public static Weather rainstorm;

    public static void load() {
        rainstorm = new RainWeather("rainstorm"){
            {
                this.attrs.set(Attribute.light, 0.2f);
                this.attrs.set(Attribute.water, 0.5f);
                this.status = StatusEffects.wet;
                this.sound = Sounds.rain;
                this.soundVol = 0.25f;
                this.sizeMin = 30.0f;
                this.sizeMax = 50.0f;
                this.xspeed = 4.0f;
                this.yspeed = 10.0f;
                this.padding = 32.0f;
                this.density = 2400.0f;
                this.stroke = 1.25f;
                this.duration = 14400.0f;
            }

            public void update(WeatherState state) {
                float speed = 0.2f * state.intensity * Time.delta;
                if (speed > 0.001f) {
                    float windx = state.windVector.x * speed;
                    float windy = state.windVector.y * speed;
                    for (Unit unit : Groups.unit) {
                        unit.impulse(windx, windy);
                    }
                }
                state.windVector.rotate(Time.delta / 10.0f);
            }
        };
    }
}

