/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.ost;

import arc.Core;
import arc.Events;
import arc.audio.Music;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Planets;
import mindustry.game.EventType;
import mindustry.gen.Musics;
import subvoyage.content.world.SvPlanets;
import subvoyage.type.block.storage.core.AtlacianCore;

public class SvMusic {
    public static Music land;
    public static Music theAtlacian;
    public static Music ambient1;
    public static Music ambient2;
    public static Music ambient3;
    public static Music atlLand;
    private static final ObjectMap<String, Seq<Music>> musicSets;

    public static void load() {
        land = Musics.land;
        Core.assets.load((String)"music/atl_land.ogg", Music.class).loaded = a -> {
            atlLand = a;
        };
        Core.assets.load((String)"music/atl-ambient1.ogg", Music.class).loaded = a -> {
            ambient1 = theAtlacian = a;
        };
        Core.assets.load((String)"music/atl-ambient2.ogg", Music.class).loaded = a -> {
            ambient2 = a;
        };
        Core.assets.load((String)"music/atl-ambient3.ogg", Music.class).loaded = a -> {
            ambient3 = a;
        };
        musicSets.put((Object)"vanillaAmbient", (Object)new Seq(Vars.control.sound.ambientMusic));
        musicSets.put((Object)"atlacianAmbient", (Object)Seq.with((Object[])new Music[]{ambient1, ambient2, ambient3}));
        musicSets.put((Object)"atlacianDark", (Object)Seq.with((Object[])new Music[]{ambient1, ambient2, ambient3}));
        musicSets.put((Object)"atlacianBoss", (Object)Seq.with((Object[])new Music[0]));
        Events.on(EventType.WorldLoadEvent.class, e -> {
            SvMusic.updateLandMusic();
            SvMusic.updatePlanetMusic();
        });
    }

    private static void updateLandMusic() {
        Vars.state.rules.defaultTeam.cores().each(core -> {
            Musics.land = core.block instanceof AtlacianCore ? atlLand : land;
        });
    }

    private static void updatePlanetMusic() {
        if (Vars.state.rules.planet != Planets.sun) {
            String prefix = Vars.state.rules.planet == SvPlanets.atlacian ? "atlacian" : "vanilla";
            SvMusic.setMusicSet(prefix + "Ambient", (Seq<Music>)Vars.control.sound.ambientMusic);
            SvMusic.setMusicSet(prefix + "Dark", (Seq<Music>)Vars.control.sound.darkMusic);
            SvMusic.setMusicSet(prefix + "Boss", (Seq<Music>)Vars.control.sound.bossMusic);
        } else {
            SvMusic.mixMusic();
        }
    }

    private static void setMusicSet(String setName, Seq<Music> target) {
        Seq set = (Seq)musicSets.get((Object)setName);
        if (set != null) {
            target.set(set);
        }
    }

    private static void mixMusic() {
        SvMusic.mixMusicSets("vanillaAmbient", "atlacianAmbient", (Seq<Music>)Vars.control.sound.ambientMusic);
        SvMusic.mixMusicSets("vanillaDark", "atlacianDark", (Seq<Music>)Vars.control.sound.darkMusic);
        SvMusic.mixMusicSets("vanillaBoss", "atlacianBoss", (Seq<Music>)Vars.control.sound.bossMusic);
    }

    private static void mixMusicSets(String vanillaSetName, String modSetName, Seq<Music> target) {
        Seq vanillaSet = (Seq)musicSets.get((Object)vanillaSetName);
        Seq modSet = (Seq)musicSets.get((Object)modSetName);
        if (vanillaSet != null && modSet != null) {
            target.clear();
            target.addAll(vanillaSet);
            target.addAll(modSet);
        }
    }

    static {
        theAtlacian = new Music();
        ambient1 = new Music();
        ambient2 = new Music();
        ambient3 = new Music();
        atlLand = new Music();
        musicSets = new ObjectMap();
    }
}

