/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.block;

import arc.func.Boolf;
import arc.struct.Seq;
import java.lang.invoke.LambdaMetafactory;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.entities.effect.MultiEffect;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.production.BurstDrill;
import mindustry.world.blocks.production.Pump;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawBlurSpin;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawLiquidRegion;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BuildVisibility;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import subvoyage.content.SvBlocks;
import subvoyage.content.SvItems;
import subvoyage.content.other.SvAttribute;
import subvoyage.type.ConsumesOr;
import subvoyage.type.block.crafter.AttributeCrafterBoostable;
import subvoyage.type.block.production.CoralliteGrinder;
import subvoyage.type.block.production.ProductionAnchor;
import subvoyage.type.block.production.Sifter;

public class SvProduction {
    public static Block coralliteGrinder;
    public static Block sifter;
    public static Block featherDrill;
    public static Block crudeDrill;
    public static Block productionAnchor;
    public static Block centrifugalPump;

    public static void load() {
        coralliteGrinder = new CoralliteGrinder("corallite-grinder"){
            {
                this.requirements(Category.production, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 12}));
                this.size = 2;
                this.craftTime = 270.0f;
                this.itemCapacity = 50;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 5});
                this.buildCostMultiplier = 2.0f;
                this.squareSprite = false;
                this.consumeLiquid(Liquids.water, 0.25f);
                this.envDisabled |= 0x10;
                this.sulfurDrawer = new DrawRegion("-sulfur");
                this.outputItems = new ItemStack[]{new ItemStack(SvItems.corallite, 3), new ItemStack(SvItems.finesand, 1)};
                this.sulfurVariant = new ItemStack[]{new ItemStack(SvItems.sulfur, 2), new ItemStack(SvItems.finesand, 2)};
                this.maxLiquidTiles = 3;
            }
        };
        sifter = new Sifter("water-sifter"){
            {
                this.requirements(Category.production, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 20, SvItems.corallite, 60}));
                this.harvestTime = 30.0f;
                this.itemCapacity = 50;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 100, SvItems.corallite, 60, SvItems.clay, 50});
                this.buildCostMultiplier = 2.0f;
                this.consume(new ConsumesOr(new Consume[]{new ConsumeItems(ItemStack.with((Object[])new Object[]{SvItems.finesand, 2})), new ConsumePower(0.6f, 0.0f, false)}));
                this.size = 2;
                this.envDisabled |= 0x10;
                this.squareSprite = false;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault()});
            }
        };
        crudeDrill = new AttributeCrafterBoostable("tectonic-drill"){
            {
                this.requirements(Category.production, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 200, SvItems.clay, 150, SvItems.iridium, 100, SvItems.finesand, 30}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 1000, SvItems.spaclanium, 600, SvItems.iridium, 400});
                this.attribute = SvAttribute.crude;
                this.minEfficiency = 8.9999f;
                this.baseEfficiency = 0.0f;
                this.displayEfficiency = false;
                this.craftTime = 200.0f;
                this.size = 3;
                this.itemCapacity = 20;
                this.outputItem = new ItemStack(SvItems.crude, 3);
                this.hasPower = true;
                this.hasLiquids = false;
                this.ambientSound = Sounds.drill;
                this.ambientSoundVolume = 0.15f;
                this.consumeLiquid(SvItems.hydrogen, 0.06666667f).boost();
                this.boostScale = 0.11111111f;
                this.craftEffect = new MultiEffect(new Effect[]{Fx.drillSteam, Fx.mineImpactWave.wrap(Pal.orangeSpark, 20.0f)});
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawBlurSpin("-rotator", 4.0f), new DrawDefault(), new DrawRegion("-top")});
                this.fogRadius = 4;
                this.squareSprite = false;
                this.consumePower(0.2f);
            }

            public void drawPlace(int x, int y, int rotation, boolean valid) {
                super.drawPlace(x, y, rotation, valid);
                int efficiency = (int)((this.baseEfficiency + Math.min(this.maxBoost, this.boostScale * this.sumAttribute(this.attribute, x, y))) * 100.0f);
                if (efficiency < 100) {
                    Seq errors = Seq.with((Object[])new String[]{"tectonic-drill.place.message"});
                    Sifter.drawErrorInfo(this.size, (float)(x * 8) - 4.0f, (float)(y * 8) - 8.0f, (Seq<String>)errors);
                }
            }
        };
        featherDrill = new BurstDrill("feather-drill"){
            {
                this.requirements(Category.production, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 250, SvItems.spaclanium, 300, SvItems.clay, 250, SvItems.iridium, 190}));
                this.tier = 2;
                this.drillTime = 480.0f;
                this.size = 3;
                this.itemCapacity = 40;
                this.blockedItem = Items.sand;
                this.fogRadius = 4;
                this.squareSprite = false;
                this.updateEffect = Fx.none;
                this.drillEffect = new MultiEffect(new Effect[]{Fx.mineImpact, Fx.drillSteam, Fx.mineImpactWave.wrap(Pal.redLight, 40.0f)});
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 200, SvItems.spaclanium, 100});
                this.consumeLiquid(Liquids.water, 0.25f);
                this.consumeLiquid(SvItems.hydrogen, 0.13333334f).boost();
            }

            public void setStats() {
                super.setStats();
                Consume consume = this.findConsumer(f -> f instanceof ConsumeLiquidBase && f.booster);
                if (consume instanceof ConsumeLiquidBase) {
                    ConsumeLiquidBase consBase = (ConsumeLiquidBase)consume;
                    this.stats.remove(Stat.booster);
                    this.stats.add(Stat.booster, StatValues.speedBoosters((String)("{0}" + StatUnit.timesSpeed.localized()), (float)consBase.amount, (float)this.liquidBoostIntensity, (boolean)false, l -> this.consumesLiquid((Liquid)l) && (this.findConsumer((Boolf)(Boolf)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$setStats$1(mindustry.world.consumers.Consume ), (Lmindustry/world/consumers/Consume;)Z)()).booster || ((ConsumeLiquid)this.findConsumer((Boolf)(Boolf)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$setStats$2(mindustry.world.consumers.Consume ), (Lmindustry/world/consumers/Consume;)Z)())).liquid != l)));
                }
            }

            private static /* synthetic */ boolean lambda$setStats$2(Consume f) {
                return f instanceof ConsumeLiquid;
            }

            private static /* synthetic */ boolean lambda$setStats$1(Consume f) {
                return f instanceof ConsumeLiquid;
            }
        };
        productionAnchor = new ProductionAnchor("production-anchor"){
            {
                this.requirements(Category.effect, BuildVisibility.editorOnly, ItemStack.with((Object[])new Object[0]));
                this.health = 1500;
                this.size = 3;
                this.priority = 1.8f;
                this.itemBatches = ItemStack.with((Object[])new Object[]{SvItems.corallite, 40, SvItems.corallite, 40, SvItems.spaclanium, 35, SvItems.spaclanium, 35, SvItems.finesand, 20, SvItems.sulfur, 15, SvItems.spaclanium, 35, SvItems.spaclanium, 35, SvItems.finesand, 20, SvItems.sulfur, 15, SvItems.corallite, 40, SvItems.corallite, 40});
            }
        };
        centrifugalPump = new Pump("centrifugal-pump"){
            {
                this.requirements(Category.liquid, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 20}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 5});
                this.size = 2;
                this.squareSprite = false;
                this.envDisabled |= 0x10;
                this.pumpAmount = 0.0625f;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidRegion(), new DrawRegion("-top-shadow"), new DrawRegion(""){
                    {
                        super(arg0);
                        this.layer = 35.0f;
                    }
                }, new DrawRegion("-top")});
            }
        };
    }
}

